package io.intino.sezzet.editor.box;

import io.intino.sezzet.editor.box.displays.*;
import io.intino.sezzet.editor.box.displays.notifiers.*;
import io.intino.sezzet.editor.box.displays.requesters.*;
import io.intino.sezzet.editor.box.resources.*;

import io.intino.konos.alexandria.ui.UIAlexandriaSpark;
import io.intino.konos.alexandria.ui.AssetResourceLoader;
import io.intino.konos.alexandria.ui.displays.AlexandriaDisplayNotifier;
import io.intino.konos.alexandria.ui.displays.AlexandriaDisplayNotifierProvider;
import io.intino.konos.alexandria.ui.services.push.PushService;
import io.intino.konos.alexandria.ui.spark.resources.AfterDisplayRequest;
import io.intino.konos.alexandria.ui.spark.resources.AssetResource;
import io.intino.konos.alexandria.ui.spark.resources.AuthenticateCallbackResource;
import io.intino.konos.alexandria.ui.spark.resources.BeforeDisplayRequest;

import java.net.MalformedURLException;
import java.net.URL;

public class EditorUi extends io.intino.konos.alexandria.ui.UI {

	public static void init(UIAlexandriaSpark spark, EditorBox box) {
		EditorConfiguration configuration = box.configuration();
		spark.route("/push").push(new PushService());
		spark.route("/authenticate-callback").get(manager -> new AuthenticateCallbackResource(manager, notifierProvider()).execute());
		spark.route("/asset/:name").get(manager -> new AssetResource(name -> new AssetResourceLoader(box).load(name), manager, notifierProvider()).execute());
		spark.route("/").get(manager -> new HomeResource(box, manager, notifierProvider()).execute());



		initDisplays(spark);
	}

	public static void initDisplays(UIAlexandriaSpark spark) {
		spark.route("/sezzeteditorhome/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());//BBB
		spark.route("/sezzeteditorhome/:displayId").post(manager -> new SezzetEditorHomeRequester(manager, notifierProvider()).execute());
		spark.route("/sezzeteditorhome/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());

		spark.route("/sezzeteditormold/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());//BBB
		spark.route("/sezzeteditormold/:displayId").post(manager -> new SezzetEditorMoldRequester(manager, notifierProvider()).execute());
		spark.route("/sezzeteditormold/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());

		spark.route("/sezzeteditor/:displayId").before(manager -> new BeforeDisplayRequest(manager).execute());//BBB
		spark.route("/sezzeteditor/:displayId").post(manager -> new SezzetEditorRequester(manager, notifierProvider()).execute());
		spark.route("/sezzeteditor/:displayId").after(manager -> new AfterDisplayRequest(manager).execute());


		registerNotifiers();
	}

	private static void registerNotifiers() {
		register(SezzetEditorHomeNotifier.class).forDisplay(io.intino.sezzet.editor.box.displays.SezzetEditorHome.class);
		register(SezzetEditorMoldNotifier.class).forDisplay(io.intino.sezzet.editor.box.displays.SezzetEditorMold.class);
		register(SezzetEditorNotifier.class).forDisplay(io.intino.sezzet.editor.box.displays.SezzetEditor.class);

	}
}