/*
 * Decompiled with CFR 0.152.
 */
package io.intino.builderservice;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import io.intino.alexandria.Resource;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.exceptions.Conflict;
import io.intino.alexandria.exceptions.InternalServerError;
import io.intino.alexandria.exceptions.NotFound;
import io.intino.alexandria.restaccessor.OutBox;
import io.intino.alexandria.restaccessor.RequestBuilder;
import io.intino.alexandria.restaccessor.Response;
import io.intino.alexandria.restaccessor.adapters.RequestAdapter;
import io.intino.alexandria.restaccessor.adapters.ResponseAdapter;
import io.intino.alexandria.restaccessor.core.RestAccessorNotifier;
import io.intino.builderservice.schemas.BuilderInfo;
import io.intino.builderservice.schemas.OperationResult;
import io.intino.builderservice.schemas.RegisterBuilder;
import io.intino.builderservice.schemas.RunOperationContext;
import java.io.File;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class QuassarBuilderServiceAccessor {
    private final URL url;
    private final RestAccessorNotifier notifier = new RestAccessorNotifier();
    private int timeoutMillis = 120000;
    private OutBox outBox = null;
    private Map<String, String> additionalHeaders = new HashMap<String, String>();

    public QuassarBuilderServiceAccessor(URL url) {
        this.url = url;
    }

    public QuassarBuilderServiceAccessor(URL url, int timeoutMillis) {
        this.url = url;
        this.timeoutMillis = timeoutMillis;
    }

    public QuassarBuilderServiceAccessor(URL url, int timeoutMillis, File outBoxDirectory, int intervalRetrySeconds) {
        this.url = url;
        this.timeoutMillis = timeoutMillis;
        this.outBox = new OutBox(outBoxDirectory, intervalRetrySeconds);
    }

    public void addCommonHeader(String name, String value) {
        this.additionalHeaders.put(name, value);
    }

    public void addRequestSerializer(Type type, JsonSerializer<?> adapter) {
        RequestAdapter.addCustomAdapter((Type)type, adapter);
    }

    public void addResponseDeserializer(Type type, JsonDeserializer<?> adapter) {
        ResponseAdapter.addCustomAdapter((Type)type, adapter);
    }

    public List<BuilderInfo> getBuilders() throws InternalServerError {
        RequestBuilder builder = new RequestBuilder(this.url).timeOut(this.timeoutMillis);
        this.additionalHeaders.forEach((k, v) -> builder.headerParameter(k, v));
        RequestBuilder.Request request = builder.build(RequestBuilder.Method.GET, "/api/builders");
        try {
            Response response = request.execute();
            return (List)ResponseAdapter.adapt((String)response.content(), (Type)new TypeToken<ArrayList<BuilderInfo>>(){}.getType());
        }
        catch (AlexandriaException e) {
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public void postBuilders(RegisterBuilder info) throws InternalServerError {
        RequestBuilder builder = new RequestBuilder(this.url).timeOut(this.timeoutMillis);
        this.additionalHeaders.forEach((k, v) -> builder.headerParameter(k, v));
        RequestBuilder.Request request = builder.entityPart("info", (Object)info).build(RequestBuilder.Method.POST, "/api/builders");
        try {
            Response response = request.execute();
        }
        catch (AlexandriaException e) {
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public BuilderInfo getBuilderInfo(String imageURL, String registryToken) throws Conflict, InternalServerError {
        RequestBuilder builder = new RequestBuilder(this.url).timeOut(this.timeoutMillis);
        this.additionalHeaders.forEach((k, v) -> builder.headerParameter(k, v));
        RequestBuilder.Request request = builder.queryParameter("imageURL", (Object)imageURL).entityPart("registryToken", (Object)registryToken).build(RequestBuilder.Method.GET, "/api/builders/info");
        try {
            Response response = request.execute();
            return (BuilderInfo)ResponseAdapter.adapt((String)response.content(), BuilderInfo.class);
        }
        catch (AlexandriaException e) {
            if (e instanceof Conflict) {
                throw (Conflict)e;
            }
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public String postRunOperation(RunOperationContext runOperationContext, Resource.InputStreamProvider filesInTar) throws InternalServerError {
        RequestBuilder builder = new RequestBuilder(this.url).timeOut(this.timeoutMillis);
        this.additionalHeaders.forEach((k, v) -> builder.headerParameter(k, v));
        RequestBuilder.Request request = builder.entityPart("runOperationContext", (Object)runOperationContext).entityPart(new Resource("filesInTar", filesInTar)).build(RequestBuilder.Method.POST, "/api/operations/run");
        try {
            Response response = request.execute();
            return (String)ResponseAdapter.adapt((String)response.content(), String.class);
        }
        catch (AlexandriaException e) {
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public OperationResult getOperationOutput(String ticket) throws InternalServerError {
        RequestBuilder builder = new RequestBuilder(this.url).timeOut(this.timeoutMillis);
        this.additionalHeaders.forEach((k, v) -> builder.headerParameter(k, v));
        RequestBuilder.Request request = builder.build(RequestBuilder.Method.GET, "/api/operation/" + ticket + "/output");
        try {
            Response response = request.execute();
            return (OperationResult)ResponseAdapter.adapt((String)response.content(), OperationResult.class);
        }
        catch (AlexandriaException e) {
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public Resource getOutputResource(String ticket, OutputResourceOutput output, String excludeFilePattern) throws NotFound, InternalServerError {
        RequestBuilder builder = new RequestBuilder(this.url).timeOut(this.timeoutMillis);
        this.additionalHeaders.forEach((k, v) -> builder.headerParameter(k, v));
        RequestBuilder.Request request = builder.queryParameter("excludeFilePattern", (Object)excludeFilePattern).build(RequestBuilder.Method.GET, "/api/operation/" + ticket + "/outputs/" + String.valueOf((Object)output));
        try {
            Response response = request.execute();
            String filename = !response.headers().containsKey("Content-Disposition") ? "filename=content" : (String)Arrays.stream(((String)response.headers().get("Content-Disposition")).split(";")).filter(c -> c.startsWith("filename")).findFirst().orElse(null);
            return new Resource(filename.split("=")[1], response.contentType(), response.contentAsStream());
        }
        catch (AlexandriaException e) {
            if (e instanceof NotFound) {
                throw (NotFound)e;
            }
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }

    public void listenSubscribeOperation(String ticket, Consumer<String> listener) throws InternalServerError {
        RequestBuilder.Request request = new RequestBuilder(this.url).timeOut(this.timeoutMillis).build(RequestBuilder.Method.POST, "operation/:ticket/messages");
        try {
            this.notifier.listen(listener, request.execute().content().trim());
        }
        catch (AlexandriaException e) {
            throw new InternalServerError(e.message());
        }
    }

    public void stopListenSubscribeOperation() {
        this.notifier.close();
    }

    public static enum OutputResourceOutput {
        Src,
        Gen,
        Res,
        Out,
        Build;

    }
}

