package io.intino.builderservice.schemas;

import io.intino.builderservice.schemas.*;

public class Message implements java.io.Serializable {

	@com.google.gson.annotations.SerializedName("type")
	private String type;
	private Kind kind;

	public enum Kind {
		INFO, WARNING, ERROR
	}

	@com.google.gson.annotations.SerializedName("content")
	private String content;
	@com.google.gson.annotations.SerializedName("uri")
	private String uri;
	@com.google.gson.annotations.SerializedName("line")
	private int line = 0;
	@com.google.gson.annotations.SerializedName("column")
	private int column = 0;

	public String type() {
		return this.type;
	}

	public Kind kind() {
		return kind;
	}

	public String content() {
		return this.content;
	}

	public String uri() {
		return this.uri;
	}

	public int line() {
		return this.line;
	}

	public int column() {
		return this.column;
	}

	public Message type(String type) {
		this.type = type;
		return this;
	}

	public Message kind(Kind kind) {
		this.kind = kind;
		return this;
	}

	public Message content(String content) {
		this.content = content;
		return this;
	}

	public Message uri(String uri) {
		this.uri = uri;
		return this;
	}

	public Message line(int line) {
		this.line = line;
		return this;
	}

	public Message column(int column) {
		this.column = column;
		return this;
	}
}