/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.terminal.builder.codegeneration.terminal;

import com.google.gson.Gson;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.model.Datalake;
import io.intino.datahub.model.Namespace;
import io.intino.datahub.model.Terminal;
import io.intino.magritte.framework.Layer;
import io.intino.ness.terminal.builder.IntinoException;
import io.intino.ness.terminal.builder.codegeneration.Formatters;
import io.intino.ness.terminal.builder.codegeneration.PomRenderer;
import io.intino.ness.terminal.builder.codegeneration.Project;
import io.intino.ness.terminal.builder.codegeneration.terminal.Manifest;
import io.intino.ness.terminal.builder.codegeneration.terminal.TerminalRenderer;
import io.intino.ness.terminal.builder.util.ErrorUtils;
import io.intino.plugin.CompilerConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TerminalBuilder {
    private final File root;
    private final Terminal terminal;
    private final CompilerConfiguration configuration;
    private final Map<String, String> versions;
    private final String basePackage;

    public TerminalBuilder(File root, Terminal terminal, CompilerConfiguration configuration, Map<String, String> versions) {
        this.root = root;
        this.terminal = terminal;
        this.configuration = configuration;
        this.versions = versions;
        this.basePackage = configuration.groupId().toLowerCase() + "." + Formatters.snakeCaseToCamelCase().format((Object)configuration.artifactId()).toString().toLowerCase();
    }

    public Project build() throws IntinoException {
        try {
            this.createSources();
            this.configuration.out().println("@#$%@# Presentable:Terminalc: Terminal " + this.terminal.name$() + " created!");
            PomRenderer pomRenderer = new PomRenderer(this.configuration, this.versions, this.root, this.basePackage);
            return new Project(pomRenderer.coors(this.terminal), pomRenderer.render(this.terminal));
        }
        catch (IntinoException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IntinoException("Error rendering terminal: " + ErrorUtils.getMessage(e));
        }
    }

    private void createSources() throws IntinoException {
        File srcDirectory = new File(this.root, "src");
        srcDirectory.mkdirs();
        this.checkDuplicatedEvents();
        new TerminalRenderer(this.terminal, srcDirectory, this.basePackage, this.configuration).render();
        File resDirectory = new File(this.root, "res");
        resDirectory.mkdirs();
        this.writeManifest(resDirectory);
    }

    private void checkDuplicatedEvents() throws IntinoException {
        Set duplicatedSubscribe;
        Set duplicatedPublish = this.terminal.publish() != null ? this.findDuplicates(this.terminal.publish().messageTanks().stream().map(Datalake.Tank.Message::qn).toList()) : Collections.emptySet();
        Set<Object> set = duplicatedSubscribe = this.terminal.subscribe() != null ? this.findDuplicates(this.terminal.subscribe().messageTanks().stream().map(Datalake.Tank.Message::qn).toList()) : Collections.emptySet();
        if (!duplicatedPublish.isEmpty()) {
            this.configuration.out().println("@#$%@# Presentable:Terminalc: Duplicated publishing event in terminal " + this.terminal.name$() + ": " + String.join((CharSequence)", ", duplicatedPublish));
            throw new IntinoException("Duplicated publishing event in terminal " + this.terminal.name$() + ": " + String.join((CharSequence)", ", duplicatedPublish));
        }
        if (!duplicatedSubscribe.isEmpty()) {
            this.configuration.out().println("@#$%@# Presentable:Terminalc: Duplicated subscription event in terminal " + this.terminal.name$() + ": " + String.join((CharSequence)", ", duplicatedPublish));
            throw new IntinoException("Duplicated subscription event in terminal " + this.terminal.name$() + ": " + String.join((CharSequence)", ", duplicatedPublish));
        }
    }

    public Set<String> findDuplicates(List<String> listContainingDuplicates) {
        HashSet set = new HashSet();
        return listContainingDuplicates.stream().filter(yourInt -> !set.add(yourInt)).collect(Collectors.toSet());
    }

    private void writeManifest(File srcDirectory) {
        ArrayList<String> subscribe;
        ArrayList<String> publish;
        List<String> list = publish = this.terminal.publish() != null ? this.terminal.publish().messageTanks().stream().map(this::eventQn).collect(Collectors.toList()) : new ArrayList<String>();
        if (this.terminal.publish() != null) {
            publish.addAll(this.terminal.publish().measurementTanks().stream().map(this::eventQn).toList());
            publish.addAll(this.terminal.publish().resourceTanks().stream().map(this::eventQn).toList());
        }
        List<String> list2 = subscribe = this.terminal.subscribe() != null ? this.terminal.subscribe().messageTanks().stream().map(this::eventQn).collect(Collectors.toList()) : new ArrayList<String>();
        if (this.terminal.subscribe() != null) {
            subscribe.addAll(this.terminal.subscribe().measurementTanks().stream().map(this::eventQn).toList());
            subscribe.addAll(this.terminal.subscribe().resourceTanks().stream().map(this::eventQn).toList());
        }
        Manifest manifest = new Manifest(this.terminal.name$(), this.basePackage + "." + Formatters.firstUpperCase(Formatters.snakeCaseToCamelCase().format((Object)this.terminal.name$()).toString()), publish, subscribe, this.tankClasses(), this.terminal.datamarts() != null && this.terminal.datamarts().autoLoad());
        try {
            Files.write(new File(srcDirectory, "terminal.mf").toPath(), new Gson().toJson((Object)manifest).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private Map<String, String> tankClasses() {
        HashMap<String, String> tankClasses = new HashMap<String, String>();
        if (this.terminal.publish() != null) {
            this.terminal.publish().messageTanks().forEach(t -> tankClasses.putIfAbsent(this.eventQn((Datalake.Tank.Message)t), this.basePackage + ".messages." + this.eventQn((Datalake.Tank.Message)t)));
            this.terminal.publish().measurementTanks().forEach(t -> tankClasses.putIfAbsent(this.eventQn((Datalake.Tank.Measurement)t), this.basePackage + ".measurements." + this.eventQn((Datalake.Tank.Measurement)t)));
            this.terminal.publish().resourceTanks().forEach(t -> tankClasses.putIfAbsent(this.eventQn((Datalake.Tank.Resource)t), this.basePackage + ".resources." + this.eventQn((Datalake.Tank.Resource)t)));
        }
        if (this.terminal.subscribe() != null) {
            this.terminal.subscribe().messageTanks().forEach(t -> tankClasses.putIfAbsent(this.eventQn((Datalake.Tank.Message)t), this.basePackage + ".messages." + this.eventQn((Datalake.Tank.Message)t)));
            this.terminal.subscribe().measurementTanks().forEach(t -> tankClasses.putIfAbsent(this.eventQn((Datalake.Tank.Measurement)t), this.basePackage + ".measurements." + this.eventQn((Datalake.Tank.Measurement)t)));
            this.terminal.subscribe().resourceTanks().forEach(t -> tankClasses.putIfAbsent(this.eventQn((Datalake.Tank.Resource)t), this.basePackage + ".resources." + this.eventQn((Datalake.Tank.Resource)t)));
        }
        if (this.terminal.bpm() != null) {
            tankClasses.put(this.terminal.bpm().processStatusClass().substring(this.terminal.bpm().processStatusClass().lastIndexOf(".") + 1), this.terminal.bpm().processStatusClass());
        }
        return tankClasses;
    }

    private String eventQn(Datalake.Tank.Message tank) {
        return this.namespace((Layer)tank.message()) + tank.message().name$();
    }

    private String eventQn(Datalake.Tank.Resource tank) {
        return this.namespace((Layer)tank.resourceEvent()) + tank.resourceEvent().name$();
    }

    private String eventQn(Datalake.Tank.Measurement tank) {
        return this.namespace((Layer)tank.sensor()) + tank.sensor().name$();
    }

    private String namespace(Layer event) {
        return event.core$().owner().is(Namespace.class) ? ((Namespace)event.core$().ownerAs(Namespace.class)).qn() + "." : "";
    }
}

