/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.terminal.builder.codegeneration.resource;

import io.intino.datahub.model.Namespace;
import io.intino.datahub.model.Resource;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.ness.terminal.builder.codegeneration.Commons;
import io.intino.ness.terminal.builder.codegeneration.Formatters;
import io.intino.ness.terminal.builder.codegeneration.resource.ResourceTemplate;
import java.io.File;

public class ResourceRenderer {
    private static final String EVENT = "io.intino.alexandria.event.resource.ResourceEvent";
    private final Resource resource;
    private final File destination;
    private final String rootPackage;

    public ResourceRenderer(Resource resource, File destination, String rootPackage) {
        this.resource = resource;
        this.destination = destination;
        this.rootPackage = rootPackage;
    }

    public void render() {
        Object rootPackage = this.resourcesPackage();
        if (this.resource.core$().owner().is(Namespace.class)) {
            rootPackage = (String)rootPackage + "." + ((Namespace)this.resource.core$().ownerAs(Namespace.class)).qn();
        }
        File packageFolder = new File(this.destination, ((String)rootPackage).replace(".", File.separator));
        Frame frame = this.createEventFrame(this.resource, (String)rootPackage);
        Commons.writeFrame(packageFolder, this.resource.name$(), this.template().render((Object)new FrameBuilder(new String[]{"root"}).add("root", rootPackage).add("package", rootPackage).add("event", (Object)frame)));
    }

    private Frame createEventFrame(Resource event, String packageName) {
        FrameBuilder eventFrame = new FrameBuilder(new String[]{"event"}).add("name", (Object)event.name$()).add("package", (Object)packageName).add("parent", (Object)this.parent(event));
        return eventFrame.toFrame();
    }

    private String parent(Resource resource) {
        return EVENT;
    }

    private String resourcesPackage() {
        return this.rootPackage + ".resources";
    }

    private Template template() {
        return Formatters.customize(new ResourceTemplate()).add("typeFormat", value -> {
            if (value.toString().contains(".")) {
                return Formatters.firstLowerCase(value.toString());
            }
            return value;
        });
    }
}

