/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.terminal.builder.codegeneration.ontology;

import io.intino.Configuration;
import io.intino.datahub.model.NessGraph;
import io.intino.itrules.FrameBuilder;
import io.intino.ness.terminal.builder.ArtifactoryConnector;
import io.intino.ness.terminal.builder.IntinoException;
import io.intino.ness.terminal.builder.codegeneration.Commons;
import io.intino.ness.terminal.builder.codegeneration.Formatters;
import io.intino.ness.terminal.builder.codegeneration.PomTemplate;
import io.intino.ness.terminal.builder.codegeneration.Project;
import io.intino.ness.terminal.builder.codegeneration.ontology.OntologyRenderer;
import io.intino.ness.terminal.builder.util.Version;
import io.intino.plugin.CompilerConfiguration;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class OntologyBuilder {
    private final File root;
    private final NessGraph graph;
    private final CompilerConfiguration configuration;
    private final List<File> sourceDirectories;
    private final Map<String, String> versions;
    private final String basePackage;

    public OntologyBuilder(File root, NessGraph graph, CompilerConfiguration configuration, Map<String, String> versions) {
        this.root = root;
        this.graph = graph;
        this.configuration = configuration;
        this.sourceDirectories = List.of(configuration.srcDirectory());
        this.versions = versions;
        this.basePackage = configuration.groupId().toLowerCase() + "." + Formatters.snakeCaseToCamelCase().format((Object)configuration.artifactId()).toString().toLowerCase();
    }

    public Project build() throws IntinoException {
        if (this.configuration.phase().equals((Object)CompilerConfiguration.Phase.DISTRIBUTE) && !this.isSnapshotVersion() && this.isDistributed()) {
            throw new IntinoException("The Version " + this.configuration.version() + " is Already Distributed.");
        }
        new OntologyRenderer(this.graph, this.configuration, this.sourceDirectory(), this.basePackage).render();
        File pom = this.createPom(this.root, this.basePackage, this.configuration.version());
        this.configuration.out().println("@#$%@# Presentable:Terminalc: Ontology created!");
        return new Project(this.coords(), pom);
    }

    private boolean isDistributed() {
        String identifier = this.basePackage + ":ontology";
        if (this.configuration.releaseDistributionRepository() == null) {
            return false;
        }
        List<Version> versions = ArtifactoryConnector.versions(this.configuration.releaseDistributionRepository(), identifier);
        return versions.stream().anyMatch(v -> v.get().equals(this.configuration.version()));
    }

    private File sourceDirectory() {
        return new File(this.root, "src");
    }

    private File createPom(File root, String group, String version) {
        FrameBuilder builder = new FrameBuilder(new String[]{"pom"}).add("group", (Object)group).add("artifact", (Object)"ontology").add("version", (Object)version);
        this.configuration.repositories().forEach(r -> this.buildRepoFrame(builder, (Configuration.Repository)r));
        if (this.configuration.snapshotDistributionRepository() != null && this.isSnapshotVersion()) {
            this.buildDistroFrame(builder, this.configuration.snapshotDistributionRepository());
        }
        if (this.configuration.releaseDistributionRepository() != null && !this.isSnapshotVersion()) {
            this.buildDistroFrame(builder, this.configuration.releaseDistributionRepository());
        }
        this.addSourceDirectories(builder);
        this.addDependencies(builder);
        return OntologyBuilder.renderPom(root, builder);
    }

    private String coords() {
        return String.join((CharSequence)":", this.basePackage, "ontology", this.configuration.version());
    }

    private static File renderPom(File root, FrameBuilder builder) {
        File pomFile = new File(root, "pom.xml");
        Commons.write(pomFile.toPath(), new PomTemplate().render(builder.toFrame()));
        return pomFile;
    }

    private void addDependencies(FrameBuilder builder) {
        builder.add("event", (Object)new FrameBuilder().add("version", (Object)this.versions.get("event")));
        builder.add("master", (Object)new FrameBuilder().add("version", (Object)this.versions.get("master")));
        builder.add("chronos", (Object)new FrameBuilder().add("version", (Object)this.versions.get("chronos")));
    }

    private void addSourceDirectories(FrameBuilder builder) {
        builder.add("sourceDirectory", (Object)this.sourceDirectory().getAbsolutePath());
        for (File sourceDirectory : this.sourceDirectories) {
            if (!sourceDirectory.getName().equals("shared")) continue;
            builder.add("sourceDirectory", (Object)sourceDirectory.getAbsolutePath());
        }
    }

    private boolean isSnapshotVersion() {
        return this.configuration.version().contains("SNAPSHOT");
    }

    private void buildRepoFrame(FrameBuilder builder, Configuration.Repository r) {
        builder.add("repository", (Object)this.createRepositoryFrame(r).toFrame());
    }

    private void buildDistroFrame(FrameBuilder builder, Configuration.Repository r) {
        builder.add("repository", (Object)this.createRepositoryFrame(r).add("distribution").toFrame());
    }

    private FrameBuilder createRepositoryFrame(Configuration.Repository repository) {
        return new FrameBuilder(new String[]{"repository", repository.getClass().getSimpleName()}).add("name", (Object)repository.identifier()).add("random", (Object)UUID.randomUUID().toString()).add("url", (Object)repository.url());
    }
}

