/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.terminal.builder;

import io.intino.alexandria.logger.Logger;
import io.intino.datahub.model.NessGraph;
import io.intino.datahub.model.Terminal;
import io.intino.ness.terminal.builder.IntinoException;
import io.intino.ness.terminal.builder.VersionBounds;
import io.intino.ness.terminal.builder.codegeneration.Project;
import io.intino.ness.terminal.builder.codegeneration.ontology.OntologyBuilder;
import io.intino.ness.terminal.builder.codegeneration.terminal.TerminalBuilder;
import io.intino.ness.terminal.builder.util.ErrorUtils;
import io.intino.plugin.CompilerConfiguration;
import io.intino.plugin.CompilerMessage;
import io.intino.plugin.MavenBuildActionMessage;
import io.intino.plugin.OutputItem;
import io.intino.plugin.PostCompileActionMessage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class TerminalCompiler {
    private final CompilerConfiguration configuration;
    private final List<CompilerMessage> messages;
    private final List<PostCompileActionMessage> postCompileActionMessages;

    public TerminalCompiler(CompilerConfiguration configuration, List<CompilerMessage> messages, List<PostCompileActionMessage> postCompileActionMessages) {
        this.configuration = configuration;
        this.messages = messages;
        this.postCompileActionMessages = postCompileActionMessages;
    }

    public List<OutputItem> compile() {
        this.configuration.out().println("@#$%@# Presentable:Terminalc: Building " + this.configuration.artifactId() + " terminals...");
        try {
            File tempDir = this.configuration.getTempDirectory();
            tempDir.mkdirs();
            this.run(tempDir);
        }
        catch (IntinoException | IOException e) {
            this.messages.add(new CompilerMessage("error", ErrorUtils.getMessage(e)));
        }
        return List.of();
    }

    public void run(File tempDir) throws IOException, IntinoException {
        File outDirectory = this.configuration.outDirectory();
        if (!outDirectory.exists()) {
            this.messages.add(new CompilerMessage("error", "Compiled model not found. Please compile module"));
            return;
        }
        NessGraph graph = this.loadGraph(outDirectory);
        if (this.hasErrors(graph)) {
            return;
        }
        Map<String, String> versions = this.versions();
        Project project = this.buildOntology(graph, versions, tempDir);
        this.postCompileActionMessages.add((PostCompileActionMessage)this.actionMessage(project));
        List<Project> projects = this.buildTerminals(graph, versions, tempDir);
        projects.stream().map(this::actionMessage).forEach(this.postCompileActionMessages::add);
        this.configuration.out().println("@#$%@# Presentable:Terminalc: Finished generation of terminals!");
    }

    private MavenBuildActionMessage actionMessage(Project project) {
        return new MavenBuildActionMessage(this.configuration.module(), project.pom(), project.coords(), this.configuration.phase().name());
    }

    private Map<String, String> versions() {
        return Map.of("terminal-jms", VersionBounds.terminalJmsVersion(), "ingestion", VersionBounds.ingestionVersion(), "bpm", VersionBounds.bpmVersion(), "master", VersionBounds.masterVersion(), "event", VersionBounds.eventVersion(), "datalake", VersionBounds.datalakeVersion(), "chronos", VersionBounds.chronosVersion());
    }

    private Project buildOntology(NessGraph graph, Map<String, String> versions, File tempDir) throws IntinoException {
        return new OntologyBuilder(new File(tempDir, "ontology"), graph, this.configuration, versions).build();
    }

    private List<Project> buildTerminals(NessGraph nessGraph, Map<String, String> versions, File tempDir) throws IntinoException {
        try {
            ExecutorService threadPool = Executors.newFixedThreadPool(Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
            List futures = threadPool.invokeAll(nessGraph.terminalList().stream().map(terminal -> () -> this.renderTerminal(versions, tempDir, (Terminal)terminal)).toList());
            threadPool.shutdownNow();
            threadPool.awaitTermination(10L, TimeUnit.MINUTES);
            ArrayList<Project> projects = new ArrayList<Project>();
            for (Future future : futures) {
                projects.add((Project)future.get());
            }
            return projects;
        }
        catch (Throwable e) {
            throw new IntinoException("Error building terminals: " + ErrorUtils.getMessage(e));
        }
    }

    private Project renderTerminal(Map<String, String> versions, File tempDir, Terminal terminal) throws IntinoException {
        return new TerminalBuilder(new File(tempDir, terminal.name$()), terminal, this.configuration, versions).build();
    }

    private NessGraph loadGraph(File outDirectory) {
        NessGraph nessGraph;
        URLClassLoader urlClassLoader = new URLClassLoader(this.urlOf(outDirectory), this.getClass().getClassLoader());
        try {
            Class<?> aClass = urlClassLoader.loadClass(this.configuration.generationPackage() + "." + this.configuration.model().generationPackage() + ".GraphLoader");
            NessGraph graph = (NessGraph)aClass.getMethod("load", new Class[0]).invoke(null, new Object[0]);
            if (graph.messageList(t -> t.name$().equals("Session")).findAny().isEmpty()) {
                graph.create("Session", "Session").message();
            }
            nessGraph = graph;
        }
        catch (Throwable throwable) {
            try {
                try {
                    urlClassLoader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                Logger.error((Throwable)e);
                return null;
            }
        }
        urlClassLoader.close();
        return nessGraph;
    }

    private URL[] urlOf(File outDirectory) {
        try {
            return new URL[]{outDirectory.toPath().toUri().toURL()};
        }
        catch (MalformedURLException e) {
            Logger.error((Throwable)e);
            return new URL[0];
        }
    }

    private boolean hasErrors(NessGraph graph) {
        if (graph == null) {
            this.messages.add(new CompilerMessage("error", "Couldn't load graph. Please recompile module"));
            return true;
        }
        return false;
    }
}

