/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.terminal.builder;

import io.intino.Configuration;
import io.intino.alexandria.logger.Logger;
import io.intino.ness.terminal.builder.IntinoException;
import io.intino.ness.terminal.builder.util.Version;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.codec.binary.Base64;

public class ArtifactoryConnector {
    public static final String MAVEN_URL = "https://repo1.maven.org/maven2/";
    public static final String INTINO_RELEASES = "https://artifactory.intino.io/artifactory/releases";

    private static InputStream connect(URL url) {
        try {
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(2000);
            connection.setReadTimeout(2000);
            return connection.getInputStream();
        }
        catch (Throwable e) {
            return InputStream.nullInputStream();
        }
    }

    public static List<Version> chronosVersions() {
        try {
            URL url = new URL("https://artifactory.intino.io/artifactory/releases/io/intino/sumus/chronos/maven-metadata.xml");
            return ArtifactoryConnector.extractVersions(ArtifactoryConnector.read(ArtifactoryConnector.connect(url)).toString());
        }
        catch (Throwable e) {
            return Collections.emptyList();
        }
    }

    public static List<Version> terminalVersions() {
        try {
            URL url = new URL("https://artifactory.intino.io/artifactory/releases/io/intino/alexandria/terminal-jms/maven-metadata.xml");
            return ArtifactoryConnector.extractVersions(ArtifactoryConnector.read(ArtifactoryConnector.connect(url)).toString());
        }
        catch (Throwable e) {
            return Collections.emptyList();
        }
    }

    public static List<Version> ingestionVersions() {
        try {
            URL url = new URL("https://artifactory.intino.io/artifactory/releases/io/intino/alexandria/ingestion/maven-metadata.xml");
            return ArtifactoryConnector.extractVersions(ArtifactoryConnector.read(ArtifactoryConnector.connect(url)).toString());
        }
        catch (Throwable e) {
            return Collections.emptyList();
        }
    }

    public static List<Version> masterVersions() {
        try {
            URL url = new URL("https://artifactory.intino.io/artifactory/releases/io/intino/ness/master/maven-metadata.xml");
            return ArtifactoryConnector.extractVersions(ArtifactoryConnector.read(ArtifactoryConnector.connect(url)).toString());
        }
        catch (Throwable e) {
            return Collections.emptyList();
        }
    }

    public static List<Version> eventVersions() {
        try {
            URL url = new URL("https://artifactory.intino.io/artifactory/releases/io/intino/alexandria/event/maven-metadata.xml");
            return ArtifactoryConnector.extractVersions(ArtifactoryConnector.read(ArtifactoryConnector.connect(url)).toString());
        }
        catch (Throwable e) {
            return Collections.emptyList();
        }
    }

    public static List<Version> datalakeVersions() {
        try {
            URL url = new URL("https://artifactory.intino.io/artifactory/releases/io/intino/alexandria/datalake/maven-metadata.xml");
            return ArtifactoryConnector.extractVersions(ArtifactoryConnector.read(ArtifactoryConnector.connect(url)).toString());
        }
        catch (Throwable e) {
            return Collections.emptyList();
        }
    }

    public static List<Version> bpmVersions() {
        try {
            URL url = new URL("https://artifactory.intino.io/artifactory/releases/io/intino/alexandria/bpm-framework/maven-metadata.xml");
            return ArtifactoryConnector.extractVersions(ArtifactoryConnector.read(ArtifactoryConnector.connect(url)).toString());
        }
        catch (Throwable e) {
            return Collections.emptyList();
        }
    }

    public static List<Version> versions(Configuration.Repository repo, String artifact) {
        try {
            String spec = repo.url() + (repo.url().endsWith("/") ? "" : "/") + artifact.replace(":", "/").replace(".", "/") + "/maven-metadata.xml";
            URL url = new URL(spec);
            String mavenMetadata = ArtifactoryConnector.read(ArtifactoryConnector.connect(repo, url)).toString();
            if (!mavenMetadata.isEmpty()) {
                return ArtifactoryConnector.extractVersions(mavenMetadata);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private static InputStream connect(Configuration.Repository repository, URL url) {
        try {
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(2000);
            connection.setReadTimeout(2000);
            if (repository.user() != null) {
                String auth = repository.user() + ":" + repository.password();
                byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.UTF_8));
                String authHeaderValue = "Basic " + new String(encodedAuth);
                connection.setRequestProperty("Authorization", authHeaderValue);
                return connection.getInputStream();
            }
            return ArtifactoryConnector.connect(url);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static List<Version> extractVersions(String metadata) {
        if (!metadata.contains("<versions>")) {
            return Collections.emptyList();
        }
        metadata = metadata.substring(metadata.indexOf("<versions>")).substring("<versions>".length() + 1);
        metadata = metadata.substring(0, metadata.indexOf("</versions>"));
        metadata = metadata.replace("<version>", "").replace("</version>", "");
        return Arrays.stream(metadata.trim().split("\n")).map(ArtifactoryConnector.version()).filter(Objects::nonNull).toList();
    }

    private static Function<String, Version> version() {
        return s -> {
            try {
                return new Version(s.trim());
            }
            catch (IntinoException e) {
                Logger.error((Throwable)e);
                return null;
            }
        };
    }

    private static ByteArrayOutputStream read(InputStream stream) throws Throwable {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        try (InputStream inputStream = stream;){
            stream.transferTo(baos);
        }
        return baos;
    }
}

