/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.terminal.builder.codegeneration.terminal;

import io.intino.datahub.model.Datalake;
import io.intino.datahub.model.Datamart;
import io.intino.datahub.model.Entity;
import io.intino.datahub.model.Message;
import io.intino.datahub.model.Namespace;
import io.intino.datahub.model.Reel;
import io.intino.datahub.model.Resource;
import io.intino.datahub.model.Sensor;
import io.intino.datahub.model.Terminal;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.magritte.framework.Layer;
import io.intino.ness.terminal.builder.IntinoException;
import io.intino.ness.terminal.builder.codegeneration.Commons;
import io.intino.ness.terminal.builder.codegeneration.Formatters;
import io.intino.ness.terminal.builder.codegeneration.datamarts.DatamartsRenderer;
import io.intino.ness.terminal.builder.codegeneration.datamarts.TimelineUtils;
import io.intino.ness.terminal.builder.codegeneration.terminal.TerminalTemplate;
import io.intino.plugin.CompilerConfiguration;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class TerminalRenderer {
    private final Terminal terminal;
    private final File srcDir;
    private final String rootPackage;
    private final CompilerConfiguration configuration;
    private final String ontologyPackage;
    private final Set<Datalake.Tank.Message> messageTanks = new HashSet<Datalake.Tank.Message>();
    private final Set<Datalake.Tank.Measurement> measurementTanks = new HashSet<Datalake.Tank.Measurement>();
    private final Set<Datalake.Tank.Resource> resourceTanks = new HashSet<Datalake.Tank.Resource>();
    private final Datalake datalake;

    TerminalRenderer(Terminal terminal, File srcDir, String rootPackage, CompilerConfiguration configuration) {
        this.terminal = terminal;
        this.datalake = terminal.graph().datalake();
        this.srcDir = srcDir;
        this.rootPackage = rootPackage;
        this.configuration = configuration;
        this.ontologyPackage = configuration.groupId().toLowerCase() + "." + Formatters.snakeCaseToCamelCase().format((Object)configuration.artifactId()).toString().toLowerCase();
    }

    void render() throws IntinoException {
        File packageFolder = new File(this.srcDir, this.rootPackage.replace(".", File.separator));
        Commons.writeFrame(packageFolder, Formatters.snakeCaseToCamelCase().format((Object)this.terminal.name$()).toString(), this.template().render((Object)this.createTerminalFrame()));
    }

    private Frame createTerminalFrame() throws IntinoException {
        Datalake datalake = this.terminal.graph().datalake();
        FrameBuilder builder = new FrameBuilder(new String[]{"terminal"}).add("package", (Object)this.rootPackage).add("name", (Object)this.terminal.name$());
        if (datalake != null) {
            builder.add("datalake", (Object)"").add("scale", (Object)datalake.scale().name());
        }
        if (this.terminal.publish() != null) {
            this.addPublish(builder);
        }
        if (this.terminal.subscribe() != null) {
            this.addSubscribe(builder);
        }
        if (this.terminal.bpm() != null) {
            this.addBpm(builder);
        }
        if (this.terminal.datamarts() != null) {
            this.renderDatamarts(builder);
            this.addSubscribeForTheEvents(builder);
        }
        if (!this.messageTanks.isEmpty()) {
            builder.add("message", (Object)this.messageFrames());
        }
        if (!this.measurementTanks.isEmpty()) {
            builder.add("measurement", (Object)this.measurementFrames());
        }
        if (!this.resourceTanks.isEmpty()) {
            builder.add("resource", (Object)this.resourceFrames());
        }
        return builder.toFrame();
    }

    private void addSubscribe(FrameBuilder builder) {
        this.terminal.subscribe().messageTanks().forEach(tank -> builder.add("subscribe", (Object)this.frameOf((Datalake.Tank.Message)tank)));
        this.terminal.subscribe().measurementTanks().forEach(tank -> builder.add("subscribe", (Object)this.frameOf((Datalake.Tank.Measurement)tank)));
        this.terminal.subscribe().resourceTanks().forEach(tank -> builder.add("subscribe", (Object)this.frameOf((Datalake.Tank.Resource)tank)));
    }

    private void addSubscribeForTheEvents(FrameBuilder builder) {
        HashSet<String> tanksAlreadySubscribedTo = new HashSet<String>();
        if (this.terminal.subscribe() != null) {
            this.terminal.subscribe().messageTanks().stream().map(Datalake.Tank.Message::qn).forEach(tanksAlreadySubscribedTo::add);
            this.terminal.subscribe().measurementTanks().stream().map(Datalake.Tank.Measurement::qn).forEach(tanksAlreadySubscribedTo::add);
            this.terminal.subscribe().resourceTanks().stream().map(Datalake.Tank.Resource::qn).forEach(tanksAlreadySubscribedTo::add);
        }
        for (Datamart datamart : this.terminal.datamarts().list()) {
            this.addSubscribersForEntityEvents(builder, tanksAlreadySubscribedTo, datamart);
            this.addSubscribersForTimelineEvents(builder, tanksAlreadySubscribedTo, datamart);
            this.addSubscriberForReelEvents(builder, tanksAlreadySubscribedTo, datamart);
        }
    }

    private void addSubscriberForReelEvents(FrameBuilder builder, Set<String> tanksAlreadySubscribedTo, Datamart datamart) {
        datamart.reelList().stream().map(Reel::tank).filter(Objects::nonNull).distinct().filter(tank -> tanksAlreadySubscribedTo.add(tank.qn())).forEach(tank -> builder.add("subscribe", (Object)this.frameOf((Datalake.Tank.Message)tank)));
    }

    private void addSubscribersForTimelineEvents(FrameBuilder builder, Set<String> tanksAlreadySubscribedTo, Datamart datamart) {
        datamart.timelineList().stream().collect(Collectors.toMap(t -> t, t -> TimelineUtils.tanksOf(t).toList())).values().stream().flatMap(Collection::stream).distinct().filter(tanksAlreadySubscribedTo::add).forEach(tank -> builder.add("subscribe", (Object)this.frameOf(this.findTankByQn((String)tank))));
    }

    private void addSubscribersForEntityEvents(FrameBuilder builder, Set<String> tanksAlreadySubscribedTo, Datamart datamart) {
        datamart.entityList().stream().map(Entity::from).filter(Objects::nonNull).distinct().filter(tank -> tanksAlreadySubscribedTo.add(tank.qn())).forEach(tank -> builder.add("subscribe", (Object)this.frameOf((Datalake.Tank.Message)tank)));
    }

    private Frame frameOf(Datalake.Tank tank) {
        return tank.isMessage() ? this.frameOf(tank.asMessage()) : this.frameOf(tank.asMeasurement());
    }

    private Datalake.Tank findTankByQn(String tank) {
        return this.datalake.tank(t -> t.qn().equals(tank));
    }

    private void addPublish(FrameBuilder builder) {
        this.terminal.publish().messageTanks().forEach(tank -> builder.add("publish", (Object)this.frameOf((Datalake.Tank.Message)tank)));
        this.terminal.publish().measurementTanks().forEach(tank -> builder.add("publish", (Object)this.frameOf((Datalake.Tank.Measurement)tank)));
        this.terminal.publish().resourceTanks().forEach(tank -> builder.add("publish", (Object)this.frameOf((Datalake.Tank.Resource)tank)));
    }

    private void renderDatamarts(FrameBuilder builder) throws IntinoException {
        for (Datamart datamart : this.terminal.datamarts().list()) {
            builder.add("datamart", (Object)this.frameOf(datamart));
        }
        new DatamartsRenderer(this.srcDir, this.terminal.graph(), this.configuration, this.ontologyPackage).render(this.terminal, this.rootPackage);
    }

    private FrameBuilder frameOf(Datamart datamart) {
        return new FrameBuilder(new String[]{"datamart"}).add("name", (Object)datamart.name$()).add("terminal", (Object)this.terminal.name$()).add("package", (Object)(this.ontologyPackage + ".datamarts." + Formatters.javaValidName().format((Object)datamart.name$().toLowerCase()).toString())).add("devent", (Object)this.eventsOf(datamart));
    }

    private FrameBuilder[] eventsOf(Datamart datamart) {
        HashMap<String, FrameBuilder> events = new HashMap<String, FrameBuilder>(this.entityEventsOf(datamart));
        return (FrameBuilder[])events.values().toArray(FrameBuilder[]::new);
    }

    private Map<String, FrameBuilder> entityEventsOf(Datamart datamart) {
        return datamart.entityList().stream().map(Entity::from).filter(Objects::nonNull).map(Datalake.Tank.Message::message).distinct().collect(Collectors.toMap(Layer::name$, tank -> this.frameOf((Message)tank, datamart)));
    }

    private FrameBuilder frameOf(Message message, Datamart datamart) {
        return new FrameBuilder(new String[]{"devent"}).add("message", (Object)message.name$()).add("namespaceQn", (Object)this.namespace((Layer)message).replace(".", "")).add("datamart", (Object)datamart.name$());
    }

    private Frame[] messageFrames() {
        return (Frame[])this.messageTanks.stream().map(Datalake.Tank.Message::message).distinct().map(m -> new FrameBuilder(new String[]{"message"}).add("namespace", (Object)this.namespace((Layer)m)).add("namespaceQn", (Object)this.namespace((Layer)m).replace(".", "")).add("name", (Object)m.name$()).add("typename", (Object)Formatters.firstUpperCase(m.name$())).add("type", (Object)(this.messagePackage((Message)m) + "." + Formatters.firstUpperCase(m.name$()))).toFrame()).toArray(Frame[]::new);
    }

    private Frame[] measurementFrames() {
        return (Frame[])this.measurementTanks.stream().map(Datalake.Tank.Measurement::sensor).distinct().map(m -> new FrameBuilder(new String[]{"measurement"}).add("namespace", (Object)this.namespace((Layer)m)).add("namespaceQn", (Object)this.namespace((Layer)m).replace(".", "")).add("name", (Object)m.name$()).add("typename", (Object)Formatters.firstUpperCase(m.name$())).add("type", (Object)(this.measurementPackage((Sensor)m) + "." + Formatters.firstUpperCase(m.name$()))).toFrame()).toArray(Frame[]::new);
    }

    private Frame[] resourceFrames() {
        return (Frame[])this.resourceTanks.stream().map(Datalake.Tank.Resource::resourceEvent).distinct().map(r -> new FrameBuilder(new String[]{"resource"}).add("namespace", (Object)this.namespace((Layer)r)).add("namespaceQn", (Object)this.namespace((Layer)r).replace(".", "")).add("name", (Object)r.name$()).add("typename", (Object)Formatters.firstUpperCase(r.name$())).add("type", (Object)(this.resourcePackage((Resource)r) + "." + Formatters.firstUpperCase(r.name$()))).toFrame()).toArray(Frame[]::new);
    }

    private void addBpm(FrameBuilder builder) {
        String statusQn = this.terminal.bpm().processStatusClass();
        String processStatusQName = statusQn.substring(statusQn.lastIndexOf(".") + 1);
        String namespace = Optional.ofNullable(this.terminal.bpm().namespace()).orElse("");
        String channel = namespace.isEmpty() ? processStatusQName : namespace + "." + processStatusQName;
        FrameBuilder bpmBuilder = new FrameBuilder(new String[]{"default", "bpm"}).add("type", (Object)statusQn).add("namespaceQn", (Object)statusQn).add("typeName", (Object)processStatusQName).add("message", (Object)processStatusQName).add("channel", (Object)channel);
        builder.add("event", (Object)new FrameBuilder(new String[]{"event"}).add("type", (Object)statusQn).add("name", (Object)processStatusQName).add("typename", (Object)processStatusQName).toFrame());
        builder.add("processstatus", (Object)new FrameBuilder(new String[]{"event"}).add("type", (Object)statusQn).add("name", (Object)processStatusQName).add("typename", (Object)processStatusQName).add("channel", (Object)channel).toFrame());
        builder.add("subscribe", (Object)bpmBuilder);
        builder.add("publish", (Object)bpmBuilder);
    }

    private Frame frameOf(Datalake.Tank.Message tank) {
        this.messageTanks.add(tank);
        String messagesPackage = this.messagePackage(tank.message());
        String namespace = this.namespace((Layer)tank.message());
        return new FrameBuilder(new String[]{"message"}).add("type", (Object)(messagesPackage + "." + Formatters.firstUpperCase(tank.message().name$()))).add("message", (Object)tank.message().name$()).add("typeName", (Object)tank.message().name$()).add("namespace", (Object)namespace).add("namespaceQn", (Object)namespace.replace(".", "")).add("typeWithNamespace", (Object)((String)(namespace.isEmpty() ? "" : namespace + ".") + Formatters.firstUpperCase(tank.name$()))).add("channel", (Object)tank.qn()).toFrame();
    }

    private Frame frameOf(Datalake.Tank.Resource tank) {
        this.resourceTanks.add(tank);
        String messagesPackage = this.resourcePackage(tank.resourceEvent());
        String namespace = this.namespace((Layer)tank.resourceEvent());
        return new FrameBuilder(new String[]{"resource"}).add("type", (Object)(messagesPackage + "." + Formatters.firstUpperCase(tank.resourceEvent().name$()))).add("message", (Object)tank.resourceEvent().name$()).add("typeName", (Object)tank.resourceEvent().name$()).add("namespace", (Object)namespace).add("namespaceQn", (Object)namespace.replace(".", "")).add("typeWithNamespace", (Object)((String)(namespace.isEmpty() ? "" : namespace + ".") + Formatters.firstUpperCase(tank.name$()))).add("channel", (Object)tank.qn()).toFrame();
    }

    private Frame frameOf(Datalake.Tank.Measurement tank) {
        this.measurementTanks.add(tank);
        String messagesPackage = this.measurementPackage(tank.sensor());
        String namespace = this.namespace((Layer)tank.sensor());
        return new FrameBuilder(new String[]{"measurement"}).add("type", (Object)(messagesPackage + "." + Formatters.firstUpperCase(tank.sensor().name$()))).add("message", (Object)tank.sensor().name$()).add("typeName", (Object)tank.sensor().name$()).add("namespace", (Object)namespace).add("namespaceQn", (Object)namespace.replace(".", "")).add("typeWithNamespace", (Object)((String)(namespace.isEmpty() ? "" : namespace + ".") + Formatters.firstUpperCase(tank.name$()))).add("channel", (Object)tank.qn()).toFrame();
    }

    private String messagePackage(Message event) {
        String aPackage = this.rootPackage + ".messages";
        if (event.core$().owner().is(Namespace.class)) {
            aPackage = aPackage + "." + this.namespace((Layer)event);
        }
        return aPackage;
    }

    private String measurementPackage(Sensor event) {
        String aPackage = this.rootPackage + ".measurements";
        if (event.core$().owner().is(Namespace.class)) {
            aPackage = aPackage + "." + this.namespace((Layer)event);
        }
        return aPackage;
    }

    private String resourcePackage(Resource event) {
        String aPackage = this.rootPackage + ".resources";
        if (event.core$().owner().is(Namespace.class)) {
            aPackage = aPackage + "." + this.namespace((Layer)event);
        }
        return aPackage;
    }

    private String namespace(Layer event) {
        return event.core$().owner().is(Namespace.class) ? ((Namespace)event.core$().ownerAs(Namespace.class)).qn().toLowerCase() : "";
    }

    private Template template() {
        return Formatters.customize(new TerminalTemplate()).add("typeFormat", value -> {
            if (value.toString().contains(".")) {
                return Formatters.firstLowerCase(value.toString());
            }
            return value;
        });
    }
}

