/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.terminal.builder.codegeneration.ontology;

import io.intino.datahub.model.Datalake;
import io.intino.datahub.model.Message;
import io.intino.datahub.model.NessGraph;
import io.intino.datahub.model.Resource;
import io.intino.datahub.model.Sensor;
import io.intino.ness.terminal.builder.IntinoException;
import io.intino.ness.terminal.builder.codegeneration.datamarts.DatamartsRenderer;
import io.intino.ness.terminal.builder.codegeneration.measurement.MeasurementRenderer;
import io.intino.ness.terminal.builder.codegeneration.message.MessageRenderer;
import io.intino.ness.terminal.builder.codegeneration.resource.ResourceRenderer;
import io.intino.plugin.CompilerConfiguration;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class OntologyRenderer {
    private final NessGraph graph;
    private final CompilerConfiguration configuration;
    private final File srcDir;
    private final String basePackage;

    OntologyRenderer(NessGraph graph, CompilerConfiguration configuration, File srcDir, String basePackage) {
        this.graph = graph;
        this.configuration = configuration;
        this.srcDir = srcDir;
        this.basePackage = basePackage;
        srcDir.mkdirs();
    }

    public void render() throws IntinoException {
        this.renderMessages();
        this.renderMeasurements();
        this.renderResources();
        this.renderDatamarts();
    }

    private void renderMessages() {
        this.graph.core$().find(Message.class).forEach(event -> new MessageRenderer((Message)event, this.srcDir, this.basePackage).render());
    }

    private void renderMeasurements() {
        this.measurements().forEach(m -> new MeasurementRenderer((Sensor)m, this.srcDir, this.basePackage).render());
    }

    private void renderResources() {
        this.graph.core$().find(Resource.class).forEach(r -> new ResourceRenderer((Resource)r, this.srcDir, this.basePackage).render());
    }

    private void renderDatamarts() throws IntinoException {
        new DatamartsRenderer(this.srcDir, this.graph, this.configuration, this.basePackage).render();
    }

    private List<Sensor> measurements() {
        return this.graph.datalake() == null ? Collections.emptyList() : this.graph.datalake().tankList().stream().filter(Datalake.Tank::isMeasurement).map(tank -> tank.asMeasurement().sensor()).collect(Collectors.toList());
    }
}

