/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.terminal.builder.codegeneration.message;

import io.intino.datahub.model.Attribute;
import io.intino.datahub.model.Component;
import io.intino.datahub.model.Data;
import io.intino.datahub.model.Message;
import io.intino.datahub.model.Namespace;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.ness.terminal.builder.codegeneration.Commons;
import io.intino.ness.terminal.builder.codegeneration.Formatters;
import io.intino.ness.terminal.builder.codegeneration.message.MessageTemplate;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MessageRenderer {
    private static final String EVENT = "io.intino.alexandria.event.message.MessageEvent";
    private final Message message;
    private final File destination;
    private final String rootPackage;

    public MessageRenderer(Message message, File destination, String rootPackage) {
        this.message = message;
        this.destination = destination;
        this.rootPackage = rootPackage;
    }

    public void render() {
        Object rootPackage = this.messagesPackage();
        if (this.message.core$().owner().is(Namespace.class)) {
            rootPackage = (String)rootPackage + "." + ((Namespace)this.message.core$().ownerAs(Namespace.class)).qn();
        }
        File packageFolder = new File(this.destination, ((String)rootPackage).replace(".", File.separator));
        Frame frame = this.createEventFrame(this.message, (String)rootPackage);
        Commons.writeFrame(packageFolder, this.message.name$(), this.template().render((Object)new FrameBuilder(new String[]{"root"}).add("root", rootPackage).add("package", rootPackage).add("event", (Object)frame)));
    }

    private Frame createEventFrame(Message event, String packageName) {
        FrameBuilder eventFrame = new FrameBuilder(new String[]{"event"}).add("name", (Object)event.name$()).add("package", (Object)packageName).add("parent", (Object)this.parent(event));
        if (this.isAssertion(event)) {
            eventFrame.add("assertionId", (Object)"id").add("assertionInfo", (Object)new FrameBuilder(new String[]{"assertion"}).add("name", (Object)event.name$()));
        }
        eventFrame.add("attribute", (Object)this.processAttributesOf(this.attributesOf(event), event.name$()));
        Map<Component, Boolean> components = this.collectComponents(event);
        if (!components.isEmpty()) {
            eventFrame.add("component", (Object)this.processComponents(components, event.name$()));
        }
        return eventFrame.toFrame();
    }

    private boolean isAssertion(Message m) {
        return m.isAssertion() || m.isExtensionOf() && this.isAssertion(m.asExtensionOf().parent());
    }

    private String parent(Message message) {
        if (message.isExtensionOf()) {
            Message parent = message.asExtensionOf().parent();
            Object eventPackage = this.messagesPackage();
            if (parent.core$().owner().is(Namespace.class)) {
                eventPackage = (String)eventPackage + "." + ((Namespace)parent.core$().ownerAs(Namespace.class)).qn();
            }
            return (String)eventPackage + "." + parent.name$();
        }
        return EVENT;
    }

    private FrameBuilder[] processAttributesOf(Stream<Attribute> attributes, String owner) {
        FrameBuilder[] frames = (FrameBuilder[])attributes.map(this::process).toArray(FrameBuilder[]::new);
        Arrays.stream(frames).forEach(f -> f.add("owner", (Object)owner));
        return frames;
    }

    private Stream<Attribute> attributesOf(Message message) {
        return message.attributeList().stream();
    }

    private FrameBuilder[] processComponents(Map<Component, Boolean> components, String owner) {
        return (FrameBuilder[])components.entrySet().stream().map(e -> this.processComponent((Component)e.getKey(), owner, (Boolean)e.getValue())).toArray(FrameBuilder[]::new);
    }

    private FrameBuilder processComponent(Component component, String owner, boolean multiple) {
        Map<Component, Boolean> components;
        FrameBuilder builder = new FrameBuilder(new String[]{"component", multiple ? "multiple" : "single"}).add("name", (Object)component.name$()).add("type", (Object)component.name$()).add("owner", (Object)owner).add("attribute", (Object)this.processAttributesOf(component.attributeList().stream(), component.name$()));
        if (component.isExtensionOf()) {
            builder.add("parent", (Object)component.asExtensionOf().parent().name$());
        }
        if (!(components = this.collectComponents(component)).isEmpty()) {
            builder.add("component", (Object)this.processComponents(components, component.name$()));
        }
        return builder;
    }

    private Map<Component, Boolean> collectComponents(Message message) {
        Map<Component, Boolean> components = message.componentList().stream().collect(Collectors.toMap(c -> c, Component::multiple));
        components.putAll(message.hasList().stream().collect(Collectors.toMap(Message.Has::element, Message.Has::multiple)));
        return components;
    }

    private Map<Component, Boolean> collectComponents(Component component) {
        Map<Component, Boolean> components = component.componentList().stream().collect(Collectors.toMap(c -> c, Component::multiple));
        components.putAll(component.hasList().stream().collect(Collectors.toMap(Component.Has::element, Component.Has::multiple)));
        return components;
    }

    private FrameBuilder process(Attribute attribute) {
        if (attribute.isReal()) {
            return this.process(attribute.asReal());
        }
        if (attribute.isInteger()) {
            return this.process(attribute.asInteger());
        }
        if (attribute.isBool()) {
            return this.process(attribute.asBool());
        }
        if (attribute.isText()) {
            return this.process(attribute.asText());
        }
        if (attribute.isDateTime()) {
            return this.process(attribute.asDateTime());
        }
        if (attribute.isDate()) {
            return this.process(attribute.asDate());
        }
        if (attribute.isLongInteger()) {
            return this.process(attribute.asLongInteger());
        }
        if (attribute.isWord()) {
            return this.process(attribute.asWord());
        }
        return null;
    }

    private FrameBuilder process(Data.Real attribute) {
        FrameBuilder frameBuilder = new FrameBuilder(new String[]{"primitive", this.multiple((Data.Type)attribute) ? "multiple" : "single", "double"});
        if (this.message.isRetrocompatible()) {
            frameBuilder.add("retrocompatible");
        }
        return frameBuilder.add("name", (Object)((Attribute)attribute.a$(Attribute.class)).name$()).add("type", (Object)attribute.type()).add("simpleType", (Object)attribute.type().substring(attribute.type().lastIndexOf(".") + 1)).add("objectType", (Object)attribute.type()).add("defaultValue", (Object)attribute.defaultValue());
    }

    private FrameBuilder process(Data.Integer attribute) {
        FrameBuilder frameBuilder = new FrameBuilder(new String[]{"primitive", this.multiple((Data.Type)attribute) ? "multiple" : "single", attribute.type(), "int"});
        if (this.message.isRetrocompatible()) {
            frameBuilder.add("retrocompatible");
        }
        return frameBuilder.add("name", (Object)((Attribute)attribute.a$(Attribute.class)).name$()).add("type", (Object)attribute.type()).add("simpleType", (Object)attribute.type().substring(attribute.type().lastIndexOf(".") + 1)).add("objectType", (Object)attribute.type()).add("defaultValue", (Object)attribute.defaultValue());
    }

    private FrameBuilder process(Data.LongInteger attribute) {
        FrameBuilder frameBuilder = new FrameBuilder(new String[]{"primitive", this.multiple((Data.Type)attribute) ? "multiple" : "single", attribute.type(), "long"});
        if (this.message.isRetrocompatible()) {
            frameBuilder.add("retrocompatible");
        }
        return frameBuilder.add("name", (Object)((Attribute)attribute.a$(Attribute.class)).name$()).add("type", (Object)attribute.type()).add("simpleType", (Object)attribute.type().substring(attribute.type().lastIndexOf(".") + 1)).add("defaultValue", (Object)(attribute.defaultValue() + "L"));
    }

    private FrameBuilder process(Data.Bool attribute) {
        FrameBuilder frameBuilder = new FrameBuilder(new String[]{"primitive", this.multiple((Data.Type)attribute) ? "multiple" : "single", attribute.type(), "bool"});
        if (this.message.isRetrocompatible()) {
            frameBuilder.add("retrocompatible");
        }
        return frameBuilder.add("name", (Object)((Attribute)attribute.a$(Attribute.class)).name$()).add("type", (Object)attribute.type()).add("simpleType", (Object)attribute.type()).add("defaultValue", (Object)attribute.defaultValue());
    }

    private FrameBuilder process(Data.Text attribute) {
        return new FrameBuilder(new String[]{"primitive", this.multiple((Data.Type)attribute) ? "multiple" : "single", attribute.type(), "text"}).add("name", (Object)((Attribute)attribute.a$(Attribute.class)).name$()).add("type", (Object)attribute.type()).add("simpleType", (Object)attribute.type()).add("defaultValue", (Object)attribute.defaultValue());
    }

    private FrameBuilder process(Data.DateTime attribute) {
        return new FrameBuilder(new String[]{"primitive", this.multiple((Data.Type)attribute) ? "multiple" : "single", attribute.type(), "datetime"}).add("name", (Object)((Attribute)attribute.a$(Attribute.class)).name$()).add("type", (Object)attribute.type()).add("simpleType", (Object)attribute.type().substring(attribute.type().lastIndexOf(".") + 1)).add("defaultValue", (Object)"null");
    }

    private FrameBuilder process(Data.Date attribute) {
        return new FrameBuilder(new String[]{"primitive", this.multiple((Data.Type)attribute) ? "multiple" : "single", attribute.type(), "date"}).add("name", (Object)((Attribute)attribute.a$(Attribute.class)).name$()).add("simpleType", (Object)attribute.type().substring(attribute.type().lastIndexOf(".") + 1)).add("type", (Object)attribute.type());
    }

    private FrameBuilder process(Data.Word attribute) {
        Attribute a = (Attribute)attribute.a$(Attribute.class);
        return new FrameBuilder(new String[]{"primitive", "word", this.multiple((Data.Type)attribute) ? "multiple" : "single", attribute.type()}).add("name", (Object)a.name$()).add("words", (Object)attribute.values().toArray(new String[0])).add("type", (Object)a.name$());
    }

    private String messagesPackage() {
        return this.rootPackage + ".messages";
    }

    private boolean multiple(Data.Type attribute) {
        return attribute.asData().isList();
    }

    private Template template() {
        return Formatters.customize(new MessageTemplate()).add("typeFormat", value -> {
            if (value.toString().contains(".")) {
                return Formatters.firstLowerCase(value.toString());
            }
            return value;
        });
    }
}

