package io.intino.ness.terminal.builder.codegeneration.datamarts;

import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class DatamartTemplate extends Template {

	public RuleSet ruleSet() {
		return new RuleSet().add(
				rule().condition((allTypes("datamart", "interface"))).output(literal("package ")).output(mark("package")).output(literal(";\n\nimport java.io.IOException;\nimport java.util.List;\nimport java.util.Map;\nimport java.util.HashMap;\nimport java.util.concurrent.ConcurrentHashMap;\nimport java.util.stream.Stream;\nimport java.util.stream.Collectors;\nimport java.time.Instant;\nimport java.util.Optional;\n\nimport io.intino.ness.master.Datamart;\nimport io.intino.ness.master.model.Entity;\nimport io.intino.ness.master.reflection.*;\n\npublic interface ")).output(mark("name", "FirstUpperCase")).output(literal("Datamart extends Datamart {\n\n\tDatamartDefinition definition = new ")).output(mark("name", "FirstUpperCase")).output(literal("Datamart.DatamartDefinitionInternal();\n\n\tList<String> listSnapshots();\n\t")).output(mark("name", "FirstUpperCase")).output(literal("Datamart snapshot(String timetag);\n\n\tint sizeDisabled();\n\n\t")).output(expression().output(mark("entity", "getterSignature").multiple("\n\n"))).output(literal("\n\n\t")).output(expression().output(mark("hasTimelines")).output(literal("Stream<TimelineNode> timelines(String id);"))).output(literal("\n\n\t")).output(expression().output(mark("timeline", "getterSignature").multiple("\n\n"))).output(literal("\n\n\t")).output(expression().output(mark("hasReels")).output(literal("Stream<ReelNode> reels(String id);"))).output(literal("\n\n\t")).output(expression().output(mark("reel", "getterSignature").multiple("\n\n"))).output(literal("\n\n\t")).output(expression().output(mark("indicator", "getterSignature").multiple("\n\n"))).output(literal("\n\n\t")).output(expression().output(literal("default List<String> indicators() {")).output(literal("\n")).output(literal("\treturn List.of(")).output(mark("indicator", "name").multiple(", ")).output(literal(");")).output(literal("\n")).output(literal("}"))).output(literal("\n\n\t")).output(expression().output(literal("default IndicatorNode indicator(String name) {")).output(literal("\n")).output(literal("\treturn switch(name) {")).output(literal("\n")).output(literal("\t\t")).output(mark("indicator", "case").multiple("\n")).output(literal("\n")).output(literal("\t\tdefault -> null;")).output(literal("\n")).output(literal("\t};")).output(literal("\n")).output(literal("}"))).output(literal("\n\n\tTranslator translator();\n\n\tvoid translator(Translator translator);\n\n\tclass Entities {\n\t\tprivate final ")).output(mark("name", "FirstUpperCase")).output(literal("Datamart datamart;\n\t\tprivate final Map<EntityDefinition, Map<String, ")).output(mark("name", "FirstUpperCase")).output(literal("Entity>> entitiesByType;\n\t\tprivate final Map<EntityDefinition, Map<String, ")).output(mark("name", "FirstUpperCase")).output(literal("Entity>> entitiesByTypeDisabled;\n\n\t\tpublic Entities(")).output(mark("name", "FirstUpperCase")).output(literal("Datamart datamart) {\n\t\t\tthis.datamart = datamart;\n\t\t\tthis.entitiesByType = new ConcurrentHashMap<>();\n\t\t\tthis.entitiesByTypeDisabled = new ConcurrentHashMap<>();\n\t\t\tdatamart.getDefinition().entities().stream().filter(e -> !e.isAbstract()).forEach(entity -> entitiesByType.put(entity, new ConcurrentHashMap<>()));\n\t\t\tdatamart.getDefinition().entities().stream().filter(e -> !e.isAbstract()).forEach(entity -> entitiesByTypeDisabled.put(entity, new ConcurrentHashMap<>()));\n\t\t}\n\n\t\tpublic ")).output(mark("name", "FirstUpperCase")).output(literal("Datamart datamart() {\n\t\t\treturn datamart;\n\t\t}\n\n    \tpublic int size() {\n    \t\treturn entitiesByType.values().stream().mapToInt(Map::size).sum();\n    \t}\n\n    \tpublic int sizeDisabled() {\n    \t\treturn entitiesByTypeDisabled.values().stream().mapToInt(Map::size).sum();\n    \t}\n\n    \tpublic boolean exists(String id) {\n    \t\treturn contains(id) || containsDisabled(id);\n    \t}\n\n    \tpublic boolean contains(String id) {\n    \t\treturn get(id) != null;\n    \t}\n\n    \tpublic boolean containsDisabled(String id) {\n    \t\treturn getDisabled(id) != null;\n    \t}\n\n    \tpublic boolean exists(EntityDefinition definition, String id) {\n    \t\treturn contains(definition, id) || containsDisabled(definition, id);\n    \t}\n\n    \tpublic boolean contains(EntityDefinition definition, String id) {\n    \t\treturn get(definition, id) != null;\n    \t}\n\n    \tpublic boolean containsDisabled(EntityDefinition definition, String id) {\n    \t\treturn getDisabled(definition, id) != null;\n    \t}\n\n    \tpublic ")).output(mark("name", "FirstUpperCase")).output(literal("Entity get(String id) {\n    \t\treturn mapOf(id).map(map -> map.get(id)).orElse(null);\n    \t}\n\n    \tpublic ")).output(mark("name", "FirstUpperCase")).output(literal("Entity getDisabled(String id) {\n    \t\treturn mapOfDisabled(id).map(map -> map.get(id)).orElse(null);\n    \t}\n\n    \tpublic <T extends ")).output(mark("name", "FirstUpperCase")).output(literal("Entity> T getDescendant(EntityDefinition definition, String id) {\n    \t\tT entity = get(definition, id);\n    \t\treturn entity != null ? entity: definition.descendants().stream()\n    \t\t\t.filter(descendant -> !descendant.isAbstract())\n    \t\t\t.map(descendant -> this.<T>get(descendant, id))\n    \t\t\t.filter(java.util.Objects::nonNull).findFirst().orElse(null);\n    \t}\n\n    \tpublic <T extends ")).output(mark("name", "FirstUpperCase")).output(literal("Entity> T getDescendantDisabled(EntityDefinition definition, String id) {\n    \t\tT entity = getDisabled(definition, id);\n    \t\treturn entity != null ? entity: definition.descendants().stream()\n    \t\t\t.filter(descendant -> !descendant.isAbstract())\n    \t\t\t.map(descendant -> this.<T>getDisabled(descendant, id))\n    \t\t\t.filter(java.util.Objects::nonNull).findFirst().orElse(null);\n    \t}\n\n\t\t@SuppressWarnings(\"unchecked\")\n    \tpublic <T extends ")).output(mark("name", "FirstUpperCase")).output(literal("Entity> T get(EntityDefinition type, String id) {\n    \t\treturn entitiesByType.containsKey(type) ? (T) entitiesByType.get(type).get(id) : null;\n        }\n\n\t\t@SuppressWarnings(\"unchecked\")\n    \tpublic <T extends ")).output(mark("name", "FirstUpperCase")).output(literal("Entity> T getDisabled(EntityDefinition type, String id) {\n    \t\treturn entitiesByTypeDisabled.containsKey(type) ? (T) entitiesByTypeDisabled.get(type).get(id) : null;\n        }\n\n    \tpublic void add(")).output(mark("name", "FirstUpperCase")).output(literal("Entity entity) {\n    \t\tentitiesByType.get(entity.getDefinition()).put(entity.id(), entity);\n    \t}\n\n    \tpublic void addDisabled(")).output(mark("name", "FirstUpperCase")).output(literal("Entity entity) {\n    \t\tentitiesByTypeDisabled.get(entity.getDefinition()).put(entity.id(), entity);\n    \t}\n\n    \tpublic void disable(String id) {\n    \t\tmapOf(id).map(m -> m.remove(id)).ifPresent(this::addDisabled);\n    \t}\n\n    \tpublic void enable(String id) {\n    \t\tmapOfDisabled(id).map(m -> m.remove(id)).ifPresent(this::add);\n    \t}\n\n    \tpublic void delete(String id) {\n    \t\tmapOf(id).ifPresent(map -> map.remove(id));\n    \t\tmapOfDisabled(id).ifPresent(map -> map.remove(id));\n    \t}\n\n    \tpublic Stream<")).output(mark("name", "FirstUpperCase")).output(literal("Entity> stream() {\n    \t\treturn entitiesByType.values().stream().flatMap(map -> map.values().stream());\n    \t}\n\n    \tpublic Stream<")).output(mark("name", "FirstUpperCase")).output(literal("Entity> streamDisabled() {\n    \t\treturn entitiesByTypeDisabled.values().stream().flatMap(map -> map.values().stream());\n    \t}\n\n\t\t@SuppressWarnings(\"unchecked\")\n    \tpublic <T extends ")).output(mark("name", "FirstUpperCase")).output(literal("Entity> Stream<T> stream(EntityDefinition type) {\n    \t\treturn (Stream<T>) (entitiesByType.containsKey(type) ? entitiesByType.get(type).values().stream() : Stream.empty());\n    \t}\n\n\t\t@SuppressWarnings(\"unchecked\")\n    \tpublic <T extends ")).output(mark("name", "FirstUpperCase")).output(literal("Entity> Stream<T> streamDisabled(EntityDefinition type) {\n    \t\treturn (Stream<T>) (entitiesByTypeDisabled.containsKey(type) ? entitiesByTypeDisabled.get(type).values().stream() : Stream.empty());\n    \t}\n\n    \tpublic Stream<Entity> streamGeneric() {\n        \treturn entitiesByType.values().stream().flatMap(map -> map.values().stream());\n        }\n\n    \tpublic Stream<Entity> streamGenericDisabled() {\n        \treturn entitiesByTypeDisabled.values().stream().flatMap(map -> map.values().stream());\n        }\n\n    \tprivate java.util.Optional<Map<String, ")).output(mark("name", "FirstUpperCase")).output(literal("Entity>> mapOf(String id) {\n    \t\treturn entitiesByType.values().stream().filter(map -> map.containsKey(id)).findFirst();\n    \t}\n\n    \tprivate java.util.Optional<Map<String, ")).output(mark("name", "FirstUpperCase")).output(literal("Entity>> mapOfDisabled(String id) {\n    \t\treturn entitiesByTypeDisabled.values().stream().filter(map -> map.containsKey(id)).findFirst();\n    \t}\n    }\n\n\n    interface IndicatorNode {\n    \tboolean exists();\n    \tIndicator get() throws IndicatorNotAvailableException;\n\n    \tstatic IndicatorNode empty() {\n\t\t\treturn new IndicatorNode() {\n\t\t\t\tpublic boolean exists() {return false;}\n\t\t\t\tpublic Indicator get() throws IndicatorNotAvailableException {throw new IndicatorNotAvailableException();}\n\t\t\t};\n\t\t}\n    }\n\n    record Indicator(Map<String, Shot> shots) {\n    \tpublic Shot get(String sensor) {\n    \t\treturn shots.get(sensor);\n    \t}\n\n    \tpublic record Shot(Instant ts, double value) {\n    \t}\n\n    \tpublic static Indicator load(java.io.InputStream is) throws IOException {\n\t\t\tMap<String, Indicator.Shot> shots;\n\t\t\tif (is.available() == 0) return new Indicator(new HashMap<>());\n\t\t\ttry (var stream = new java.io.ObjectInputStream(new java.io.BufferedInputStream(is))) {\n\t\t\t\tint size = stream.readInt();\n\t\t\t\tshots = new HashMap<>(size);\n\t\t\t\tfor (int i = 0; i < size; i++)\n\t\t\t\t\tshots.put(stream.readUTF(), new Indicator.Shot(Instant.ofEpochMilli(stream.readLong()), stream.readDouble()));\n\t\t\t}\n\t\t\treturn new Indicator(shots);\n\t\t}\n\n\t\tpublic static void serialize(Indicator indicator, java.io.OutputStream os) throws IOException {\n\t\t\ttry (var stream = new java.io.ObjectOutputStream(new java.io.BufferedOutputStream(os))) {\n\t\t\t\tstream.writeInt(indicator.shots().size());\n\t\t\t\tfor (Map.Entry<String, Shot> entry : indicator.shots().entrySet()) {\n\t\t\t\t\tstream.writeUTF(entry.getKey());\n\t\t\t\t\tstream.writeLong(entry.getValue().ts().toEpochMilli());\n\t\t\t\t\tstream.writeDouble(entry.getValue().value());\n\t\t\t\t}\n\t\t\t}\n\t\t}\n    }\n\n    interface ChronosNode {\n    \t/**<p>Returns the id of the chronos object</p>*/\n    \tString id();\n    \t/**<p>Returns the type of the chronos object, as defined in the model</p>*/\n    \tString type();\n    \t/**Clears this node's internal cache, if any, and notifies the datamart to unload this node from memory.*/\n    \tvoid dispose();\n    }\n\n    interface TimelineNode extends ChronosNode {\n    \tjava.util.concurrent.atomic.AtomicBoolean AlwaysDownloadFromDatahub = new java.util.concurrent.atomic.AtomicBoolean();\n\t\tboolean exists();\n\t\tio.intino.sumus.chronos.TimelineStore.TimeModel timeModel() throws TimelineNotAvailableException;\n\t\tio.intino.sumus.chronos.TimelineStore.SensorModel sensorModel() throws TimelineNotAvailableException;\n\t\tInstant first() throws TimelineNotAvailableException;\n\t\tInstant last() throws TimelineNotAvailableException;\n    \tio.intino.sumus.chronos.Timeline get() throws TimelineNotAvailableException;\n\n    \tvoid setChangeListener(ChangeListener listener);\n\n \t\tinterface ChangeListener {\n    \t\tvoid notifyChange(TimelineNode timeline);\n    \t}\n\n    \tstatic TimelineNode empty() {\n    \t\treturn new TimelineNode() {\n                public String id(){return \"\";}\n                public String type(){return \"\";}\n                public void dispose(){}\n            \tpublic boolean exists() {return false;}\n            \tpublic io.intino.sumus.chronos.TimelineStore.TimeModel timeModel() throws TimelineNotAvailableException {throw new TimelineNotAvailableException();}\n            \tpublic io.intino.sumus.chronos.TimelineStore.SensorModel sensorModel() throws TimelineNotAvailableException {throw new TimelineNotAvailableException();}\n            \tpublic Instant first() throws TimelineNotAvailableException {throw new TimelineNotAvailableException();}\n            \tpublic Instant last() throws TimelineNotAvailableException {throw new TimelineNotAvailableException();}\n            \tpublic io.intino.sumus.chronos.Timeline get() throws TimelineNotAvailableException {throw new TimelineNotAvailableException();}\n            \tpublic void setChangeListener(ChangeListener listener) {}\n    \t\t};\n    \t}\n    }\n\n    interface ReelNode extends ChronosNode {\n\t\tboolean exists();\n    \tjava.time.Instant start() throws ReelNotAvailableException;\n    \tio.intino.sumus.chronos.State stateOf(String signal) throws ReelNotAvailableException;\n    \tjava.util.Set<String> signals() throws ReelNotAvailableException;\n\t\tdefault List<io.intino.sumus.chronos.State> stateOf(List<String> signals) throws ReelNotAvailableException {return signals.isEmpty() ? java.util.Collections.emptyList() : stateOf(signals.stream());}\n\t\tList<io.intino.sumus.chronos.State> stateOf(Stream<String> signals) throws ReelNotAvailableException;\n\t\tio.intino.sumus.chronos.Shot lastShotOf(String signal) throws ReelNotAvailableException;\n        List<io.intino.sumus.chronos.Shot> lastShots() throws ReelNotAvailableException;\n        List<io.intino.sumus.chronos.Shot> lastShots(String group) throws ReelNotAvailableException;\n        List<io.intino.sumus.chronos.Shot> lastShots(io.intino.sumus.chronos.Group group) throws ReelNotAvailableException;\n    \tio.intino.sumus.chronos.Reel get(io.intino.sumus.chronos.Period period) throws ReelNotAvailableException;\n    \tio.intino.sumus.chronos.Reel get(java.time.Instant from, java.time.Instant to, io.intino.sumus.chronos.Period period) throws ReelNotAvailableException;\n    \tvoid setChangeListener(ChangeListener listener);\n\n \t\tinterface ChangeListener {\n    \t\tvoid notifyChange(ReelNode reel);\n    \t}\n\n    \tstatic ReelNode empty() {\n    \t\treturn new ReelNode() {\n    \t        public String id(){return \"\";}\n                public String type(){return \"\";}\n                public void dispose(){}\n    \t\t\tpublic boolean exists() {return false;}\n            \tpublic java.time.Instant start() throws ReelNotAvailableException {throw new ReelNotAvailableException();}\n            \tpublic io.intino.sumus.chronos.State stateOf(String signal) throws ReelNotAvailableException{throw new ReelNotAvailableException();}\n            \tpublic java.util.Set<String> signals() throws ReelNotAvailableException {throw new ReelNotAvailableException();}\n            \tpublic List<io.intino.sumus.chronos.State> stateOf(Stream<String> signals) throws ReelNotAvailableException{throw new ReelNotAvailableException();}\n            \tpublic io.intino.sumus.chronos.Shot lastShotOf(String signal) throws ReelNotAvailableException{throw new ReelNotAvailableException();}\n\t\t\t\tpublic List<io.intino.sumus.chronos.Shot> lastShots() throws ReelNotAvailableException{throw new ReelNotAvailableException();}\n\t\t\t\tpublic List<io.intino.sumus.chronos.Shot> lastShots(String group) throws ReelNotAvailableException{throw new ReelNotAvailableException();}\n\t\t\t\tpublic List<io.intino.sumus.chronos.Shot> lastShots(io.intino.sumus.chronos.Group group) throws ReelNotAvailableException{throw new ReelNotAvailableException();}\n            \tpublic io.intino.sumus.chronos.Reel get(io.intino.sumus.chronos.Period period) throws ReelNotAvailableException{throw new ReelNotAvailableException();}\n            \tpublic io.intino.sumus.chronos.Reel get(java.time.Instant from, java.time.Instant to, io.intino.sumus.chronos.Period period) throws ReelNotAvailableException{throw new ReelNotAvailableException();}\n            \tpublic void setChangeListener(ChangeListener listener) {}\n    \t\t};\n    \t}\n    }\n\n\tfinal class DatamartDefinitionInternal implements DatamartDefinition {\n\t\tprivate DatamartDefinition definition;\n\t\tprivate DatamartDefinitionInternal() {}\n\t\t@Override\n\t\tpublic String name() {return definition().name();}\n\t\t@Override\n\t\tpublic Datamart.Scale scale() {return definition().scale();}\n\t\t@Override\n\t\tpublic Query<EntityDefinition> entities() {return definition().entities();}\n\t\t@Override\n\t\tpublic Query<StructDefinition> structs() {return definition().structs();}\n\t\t@Override\n\t\tpublic Optional<EntityDefinition> entity(String fullName) {\n        \treturn definition().entity(fullName);\n        }\n        @Override\n        public Optional<StructDefinition> struct(String fullName) {\n        \treturn definition().struct(fullName);\n        }\n\t\tprivate DatamartDefinition definition() {\n\t\t\tif (definition == null) throw new IllegalStateException(\"")).output(mark("name", "FirstUpperCase")).output(literal("Datamart is not initialized\");\n\t\t\treturn definition;\n\t\t}\n\t}\n\n\tpublic static class DatahubRequestException extends Exception {\n\t\tpublic DatahubRequestException() {}\n\t\tpublic DatahubRequestException(String message) {super(message);}\n\t\tpublic DatahubRequestException(String message, Throwable cause) {super(message, cause);}\n\t}\n\n\tpublic static class IndicatorNotAvailableException extends Exception {\n    \tpublic IndicatorNotAvailableException() {}\n    \tpublic IndicatorNotAvailableException(String message) {super(message);}\n    \tpublic IndicatorNotAvailableException(Throwable e) {super(e);}\n    }\n\n    public static class TimelineNotAvailableException extends Exception {\n\t\tpublic TimelineNotAvailableException() {}\n\t\tpublic TimelineNotAvailableException(String message) {super(message);}\n\t\tpublic TimelineNotAvailableException(Throwable e) {super(e);}\n\t}\n\n\tpublic static class ReelNotAvailableException extends Exception {\n    \tpublic ReelNotAvailableException() {}\n    \tpublic ReelNotAvailableException(String message) {super(message);}\n    \tpublic ReelNotAvailableException(Throwable e) {super(e);}\n    }\n}")),
			rule().condition((type("entity")), (trigger("gettersignature"))).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("(String id);\n")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal(" ")).output(mark("name", "firstLowerCase")).output(literal("Disabled(String id);\nStream<")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal("> ")).output(mark("name", "Plural", "firstLowerCase")).output(literal("();\nStream<")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal("> ")).output(mark("name", "Plural", "firstLowerCase")).output(literal("Disabled();\ndefault List<")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(literal("List() {return ")).output(mark("name", "Plural", "firstLowerCase")).output(literal("().collect(Collectors.toList());}\ndefault List<")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(literal("DisabledList() {return ")).output(mark("name", "Plural", "firstLowerCase")).output(literal("Disabled().collect(Collectors.toList());}\ndefault java.util.Optional<")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(literal("(java.util.function.Predicate<")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal("> predicate) {return ")).output(mark("name", "Plural", "firstLowerCase")).output(literal("().filter(predicate).findFirst();}\ndefault java.util.Optional<")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal("> ")).output(mark("name", "firstLowerCase")).output(literal("Disabled(java.util.function.Predicate<")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal("> predicate) {return ")).output(mark("name", "Plural", "firstLowerCase")).output(literal("Disabled().filter(predicate).findFirst();}")),
			rule().condition((type("timeline")), (trigger("gettersignature"))).output(literal("default TimelineNode ")).output(mark("name", "firstLowerCase")).output(literal("Timeline(")).output(mark("package")).output(literal(".entities.")).output(mark("entity", "firstUpperCase")).output(literal(" entity) {return ")).output(mark("name", "firstLowerCase")).output(literal("Timeline(entity.id());}\nTimelineNode ")).output(mark("name", "firstLowerCase")).output(literal("Timeline(String id);")),
			rule().condition((type("reel")), (trigger("gettersignature"))).output(literal("default ReelNode ")).output(mark("name", "firstLowerCase")).output(literal("Reel(")).output(mark("package")).output(literal(".entities.")).output(mark("entity", "firstUpperCase")).output(literal(" entity) {return ")).output(mark("name", "firstLowerCase")).output(literal("Reel(entity.id());}\nReelNode ")).output(mark("name", "firstLowerCase")).output(literal("Reel(String id);\nStream<ReelNode> ")).output(mark("name", "firstLowerCase")).output(literal("Reels();")),
				rule().condition((type("indicator")), (trigger("gettersignature"))).output(literal("IndicatorNode ")).output(mark("label", "firstLowerCase")).output(literal("Indicator();")),
				rule().condition((type("indicator")), (trigger("case"))).output(literal("case \"")).output(mark("name")).output(literal("\" -> ")).output(mark("label", "firstLowerCase")).output(literal("Indicator();")),
				rule().condition((type("indicator")), (trigger("name"))).output(literal("\"")).output(mark("name")).output(literal("\""))
		);
	}
}