/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.reflection;

import io.intino.ness.master.reflection.AttributeDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface ConceptDefinition<T extends ConceptDefinition<T>> {
    public static final char NAME_SEPARATOR = '.';

    public String fullName();

    default public String name() {
        String fullName = this.fullName();
        int nameBegin = fullName.lastIndexOf(46);
        return nameBegin < 0 ? fullName : fullName.substring(nameBegin + 1);
    }

    default public List<AttributeDefinition> attributes() {
        return Stream.of(this.parent().map(ConceptDefinition::attributes).stream().flatMap(Collection::stream), this.declaredAttributes().stream()).flatMap(Function.identity()).collect(Collectors.toList());
    }

    public List<AttributeDefinition> declaredAttributes();

    default public Optional<AttributeDefinition> attribute(String name) {
        return this.attributes().stream().filter(attr -> attr.name().equals(name)).findFirst();
    }

    default public Optional<AttributeDefinition> declaredAttribute(String name) {
        return this.declaredAttributes().stream().filter(attr -> attr.name().equals(name)).findFirst();
    }

    public Optional<T> parent();

    default public List<T> ancestors() {
        ArrayList<ConceptDefinition> ancestors = new ArrayList<ConceptDefinition>();
        Optional<T> parent = this.parent();
        while (parent.isPresent()) {
            ancestors.add((ConceptDefinition)parent.get());
            parent = ((ConceptDefinition)parent.get()).parent();
        }
        Collections.reverse(ancestors);
        return ancestors;
    }

    public List<T> descendants();

    default public boolean isAncestorOf(T other) {
        return this.descendants().stream().anyMatch(a -> a.fullName().equals(other.fullName()));
    }

    default public boolean isDescendantOf(T other) {
        return this.ancestors().stream().anyMatch(a -> a.fullName().equals(other.fullName()));
    }

    public Class<?> javaClass();
}

