/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.model;

import io.intino.ness.master.Datamart;
import io.intino.ness.master.reflection.AttributeDefinition;
import io.intino.ness.master.reflection.ConceptDefinition;
import java.util.List;
import java.util.Objects;

public interface Concept {
    public Attribute attribute(String var1);

    public List<Attribute> attributes();

    public Datamart datamart();

    public void addChangeListener(ChangeListener var1);

    public ConceptDefinition<?> getDefinition();

    default public boolean instanceOf(ConceptDefinition definition) {
        ConceptDefinition<?> myDefinition = this.getDefinition();
        return myDefinition.equals(definition) || myDefinition.isDescendantOf(definition);
    }

    @FunctionalInterface
    public static interface ChangeListener {
        public void onChange(Concept var1, Attribute var2, Attribute.Value var3);
    }

    public static interface Attribute {
        default public String name() {
            return this.getDefinition().name();
        }

        default public Class<?> type() {
            return this.getDefinition().type();
        }

        public Value value();

        public void addChangeListener(ChangeListener var1);

        public AttributeDefinition getDefinition();

        @FunctionalInterface
        public static interface ChangeListener {
            public void onValueChange(Value var1, Value var2);
        }

        public static class Value {
            private final Object value;

            public Value(Object value) {
                this.value = value;
            }

            public Object get() {
                return this.value;
            }

            public <T> T as(Class<T> type) {
                return type.cast(this.value);
            }

            public <T> T as() {
                return (T)this.value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                return Objects.equals(this.value, ((Value)o).value);
            }

            public int hashCode() {
                return Objects.hash(this.value);
            }

            public String toString() {
                return String.valueOf(this.get());
            }
        }
    }
}

