/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master;

import io.intino.ness.master.model.Entity;
import io.intino.ness.master.reflection.DatamartDefinition;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Datamart {
    default public String name() {
        return this.getDefinition().name();
    }

    default public Scale scale() {
        return this.getDefinition().scale();
    }

    public int size();

    public <T extends Entity> T get(String var1);

    public Stream<Entity> entities();

    default public Map<String, Entity> toMap() {
        return this.entities().collect(Collectors.toMap(Entity::id, Function.identity()));
    }

    public void addEntityListener(EntityListener var1);

    public DatamartDefinition getDefinition();

    public static enum Scale {
        Year,
        Month,
        Week,
        Day;

    }

    public static interface EntityListener {
        public void onCreate(Entity var1);

        public void onUpdate(Entity var1);

        public void onRemove(Entity var1);

        public static interface OnRemove
        extends EntityListener {
            @Override
            default public void onCreate(Entity entity) {
            }

            @Override
            default public void onUpdate(Entity entity) {
            }
        }

        public static interface OnUpdate
        extends EntityListener {
            @Override
            default public void onCreate(Entity entity) {
            }

            @Override
            default public void onRemove(Entity entity) {
            }
        }

        public static interface OnCreate
        extends EntityListener {
            @Override
            default public void onUpdate(Entity entity) {
            }

            @Override
            default public void onRemove(Entity entity) {
            }
        }
    }
}

