/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.model;

import io.intino.ness.master.model.Triplet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TripletRecord {
    private final String id;
    private final Map<String, Triplet> triplets;

    public TripletRecord(String id, Map<String, Triplet> triplets) {
        this.id = Objects.requireNonNull(id);
        this.triplets = triplets == null ? new LinkedHashMap() : triplets;
    }

    public TripletRecord(String id, List<Triplet> triplets) {
        this.id = Objects.requireNonNull(id);
        this.triplets = triplets == null ? new LinkedHashMap<String, Triplet>() : triplets.stream().collect(Collectors.toMap(Triplet::predicate, Function.identity(), (a, b) -> b));
    }

    public TripletRecord(Map<String, Triplet> triplets) {
        if (triplets.isEmpty()) {
            throw new IllegalArgumentException("triplets cannot be null. Consider using TripletRecord(String id) constructor instead.");
        }
        this.id = ((Triplet)((Map.Entry)triplets.entrySet().stream().findFirst().get()).getValue()).subject();
        this.triplets = triplets;
    }

    public TripletRecord(String id) {
        this(id, new LinkedHashMap<String, Triplet>());
    }

    public String id() {
        return this.id;
    }

    public String type() {
        return Triplet.typeOf(this.id);
    }

    public Stream<Triplet> triplets() {
        return this.triplets.values().stream();
    }

    public Triplet getTriplet(String name) {
        return this.triplets.get(name);
    }

    public String getValue(String name) {
        Triplet t = this.getTriplet(name);
        return t == null ? null : t.value();
    }

    public String getValueOrDefault(String predicate, String defaultValue) {
        return this.contains(predicate) ? this.getValue(predicate) : defaultValue;
    }

    public TripletRecord put(Triplet triplet) {
        this.triplets.put(triplet.predicate(), triplet);
        return this;
    }

    public boolean contains(String predicate) {
        return this.triplets.containsKey(predicate);
    }

    public boolean contains(String predicate, String value) {
        return this.triplets.containsKey(predicate) && Objects.equals(this.triplets.get(predicate).value(), value);
    }

    public boolean contains(Triplet triplet) {
        return Objects.equals(triplet, this.getTriplet(triplet.predicate()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TripletRecord that = (TripletRecord)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.triplets().map(Triplet::toString).collect(Collectors.joining("\n"));
    }
}

