/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.model;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Triplet
implements Serializable {
    public static final String TRIPLET_SEPARATOR = "\t";
    public static final int TRIPLET_MIN_SIZE = 3;
    public static final String NULL = "<null>";
    private final String[] attributes;

    public static String stringValueOf(Object obj) {
        return obj == null ? NULL : String.valueOf(obj);
    }

    public static String idOf(String subject) {
        int end = subject.indexOf(58);
        return end < 0 ? subject : subject.substring(0, end);
    }

    public static String typeOf(String subject) {
        int start = subject.indexOf(58);
        return start < 0 ? "" : subject.substring(start + 1);
    }

    public static String typeOf(Triplet triplet) {
        return triplet.type();
    }

    public static Triplet withAuthor(Triplet triplet, String author) {
        if (Objects.equals(triplet.author(), author)) {
            return triplet;
        }
        String[] attributes = Arrays.copyOf(triplet.attributes, triplet.attributes.length + 1);
        attributes[3] = Triplet.toNormalized(author);
        return new Triplet(attributes);
    }

    public Triplet(String line) {
        this(line.split(TRIPLET_SEPARATOR));
    }

    public Triplet(String[] record) {
        this.attributes = record;
        for (int i = 2; i < this.attributes.length; ++i) {
            this.attributes[i] = Triplet.toNormalized(this.attributes[i]);
        }
        this.validate();
    }

    public Triplet(String subject, String predicate, String value) {
        this.attributes = new String[]{subject, predicate, Triplet.toNormalized(value)};
        this.validate();
    }

    public Triplet(String subject, String predicate, String value, String author) {
        this.attributes = new String[]{subject, predicate, Triplet.toNormalized(value), Triplet.toNormalized(author)};
        this.validate();
    }

    public String id() {
        return Triplet.idOf(this.subject());
    }

    public String type() {
        return Triplet.typeOf(this.subject());
    }

    public String subject() {
        return this.attributes[0];
    }

    public String predicate() {
        return this.attributes[1];
    }

    public String value() {
        return Triplet.fromNormalized(this.attributes[2]);
    }

    public String author() {
        return this.size() <= 3 ? null : Triplet.fromNormalized(this.attributes[3]);
    }

    public String get(int index) {
        return Triplet.fromNormalized(this.attributes[index]);
    }

    public int size() {
        return this.attributes.length;
    }

    public List<String> attributes() {
        return new AbstractList<String>(){

            @Override
            public String get(int index) {
                return Triplet.this.attributes[index];
            }

            @Override
            public int size() {
                return Triplet.this.attributes.length;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Triplet triplet = (Triplet)o;
        return Arrays.equals(this.attributes, triplet.attributes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.attributes);
    }

    public String toString() {
        return String.join((CharSequence)TRIPLET_SEPARATOR, this.attributes);
    }

    private void validate() {
        if (this.attributes.length < 3) {
            throw new MalformedException("Triplets must have at least 3 fields (subject, predicate and value), but it has " + this.attributes.length + ": " + Arrays.toString(this.attributes));
        }
        this.checkIfAnyAttributeContainIllegalCharacters(this.attributes);
        if (this.isNullOrBlank(this.attributes[0])) {
            throw new NullPointerException("Subject cannot be null nor blank");
        }
        if (this.isNullOrBlank(this.id())) {
            throw new NullPointerException("Id cannot be null nor blank");
        }
        if (this.isNullOrBlank(this.attributes[1])) {
            throw new NullPointerException("Predicate cannot be null nor blank");
        }
    }

    private void checkIfAnyAttributeContainIllegalCharacters(String[] attributes) {
        for (int i = 0; i < attributes.length; ++i) {
            String attribute = attributes[i];
            if (!attribute.contains(TRIPLET_SEPARATOR)) continue;
            throw new MalformedException("Attribute (column=" + i + ") contains the triplet separator character (TAB).");
        }
    }

    private boolean isNullOrBlank(String s) {
        return this.isNull(s) || s.isBlank();
    }

    private boolean isNull(String s) {
        return s == null || s.equals(NULL);
    }

    private static String toNormalized(String value) {
        return value == null ? NULL : value;
    }

    private static String fromNormalized(String value) {
        return value.equals(NULL) ? null : value;
    }

    public static class MalformedException
    extends RuntimeException {
        public MalformedException(String message) {
            super(message);
        }
    }
}

