/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.messages;

import io.intino.ness.master.messages.listeners.EntityListener;
import io.intino.ness.master.messages.listeners.ErrorListener;
import io.intino.ness.master.model.Entity;

public interface Response<T extends Entity> {
    public boolean success();

    default public boolean failed() {
        return !this.success();
    }

    public EntityListener.Event<T> event();

    public ErrorListener.Error error();

    public static <E extends Entity> Response<E> ofSuccessful(final EntityListener.Event<E> event) {
        return new Response<E>(){

            @Override
            public boolean success() {
                return true;
            }

            @Override
            public EntityListener.Event<E> event() {
                return event;
            }

            @Override
            public ErrorListener.Error error() {
                return null;
            }
        };
    }

    public static <E extends Entity> Response<E> ofFailure(final ErrorListener.Error error) {
        return new Response<E>(){

            @Override
            public boolean success() {
                return false;
            }

            @Override
            public EntityListener.Event<E> event() {
                return null;
            }

            @Override
            public ErrorListener.Error error() {
                return error;
            }
        };
    }
}

