/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.messages;

import io.intino.alexandria.message.Message;
import io.intino.ness.master.messages.MasterMessageIdGenerator;
import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;

public abstract class MasterMessage
implements Serializable {
    public static final String INL_TYPE = "MasterMessage";
    protected final Message message;

    public MasterMessage() {
        this.message = new Message(INL_TYPE);
        this.setBaseInfo();
    }

    public MasterMessage(Message message) {
        this.message = message;
    }

    public String messageClass() {
        return this.message.get("messageClass").asString();
    }

    public final String id() {
        return this.message.get("id").asString();
    }

    public Instant ts() {
        return this.message.get("ts").asInstant();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MasterMessage that = (MasterMessage)o;
        return Objects.equals(this.id(), that.id());
    }

    public int hashCode() {
        return Objects.hash(this.id());
    }

    public String toString() {
        return this.message.toString();
    }

    private void setBaseInfo() {
        this.message.set("messageClass", this.getClass().getName());
        this.message.set("id", MasterMessageIdGenerator.generateFor(this.getClass()));
        this.message.set("ts", Instant.now());
    }

    public static class Unknown
    extends MasterMessage {
        public Unknown(Message message) {
            super(message);
        }
    }
}

