/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.data.validation;

import io.intino.ness.master.data.validation.Issue;
import io.intino.ness.master.data.validation.RecordValidator;
import io.intino.ness.master.data.validation.TripletRecordStore;
import io.intino.ness.master.data.validation.ValidationLayers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class RecordValidationLayer {
    protected final List<RecordValidator> generalValidators = new ArrayList<RecordValidator>();
    protected final Map<String, RecordValidator> validatorsPerType = new HashMap<String, RecordValidator>();

    public Stream<Issue> validate(TripletRecordStore store) {
        return store.stream().flatMap(record -> this.validate((RecordValidator.TripletRecord)record, store));
    }

    public Stream<Issue> validate(RecordValidator.TripletRecord record, TripletRecordStore store) {
        return Stream.concat(this.generalValidators.stream().flatMap(v -> v.validate(record, store)).filter(Objects::nonNull), this.validatorsPerType.getOrDefault(record.type(), RecordValidator.none()).validate(record, store).filter(Objects::nonNull).peek(issue -> issue.scope(ValidationLayers.Scope.RECORDS)));
    }

    public RecordValidationLayer addValidator(RecordValidator validator) {
        if (validator == null) {
            return this;
        }
        this.generalValidators.add(validator);
        return this;
    }

    public RecordValidationLayer setValidator(String type, RecordValidator validator) {
        if (validator == null) {
            return this;
        }
        this.validatorsPerType.put(type, validator);
        return this;
    }

    public RecordValidationLayer removeValidator(String type) {
        this.validatorsPerType.remove(type);
        return this;
    }
}

