/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.data.validation;

import io.intino.ness.master.data.validation.TripletSource;
import io.intino.ness.master.data.validation.ValidationLayers;
import java.util.Objects;

public class Issue
implements Comparable<Issue> {
    private final String type;
    private final Level level;
    private final String message;
    private ValidationLayers.Scope scope;
    private TripletSource source;

    public static Issue error(String type, String message) {
        return new Issue(type, Level.Error, message);
    }

    public static Issue warning(String type, String message) {
        return new Issue(type, Level.Warning, message);
    }

    public static Issue create(Level level, String type, String message) {
        return new Issue(type, level, message);
    }

    public Issue(String type, Level level, String message) {
        this.type = Objects.requireNonNull(type);
        this.level = level;
        this.message = message;
    }

    public String type() {
        return this.type;
    }

    public Level level() {
        return this.level;
    }

    public String message() {
        return this.message;
    }

    public Issue scope(ValidationLayers.Scope scope) {
        this.scope = scope;
        return this;
    }

    public TripletSource source() {
        return this.source;
    }

    public Issue source(TripletSource source) {
        this.source = source;
        return this;
    }

    public String levelMsg() {
        return "[" + this.level.name().toUpperCase() + "] [" + this.type + "] " + this.message;
    }

    public String toString() {
        return this.levelMsg() + (String)(this.source == null ? "" : "\n\t" + this.source.get());
    }

    @Override
    public int compareTo(Issue o) {
        if (o == null) {
            return -1;
        }
        return this.level == o.level ? this.compareSources(o.source) : this.level.compareTo(o.level);
    }

    private int compareSources(TripletSource otherSource) {
        if (this.source == null) {
            return 1;
        }
        if (otherSource == null) {
            return -1;
        }
        if (this.source instanceof TripletSource.PublisherTripletSource) {
            return 1;
        }
        if (otherSource instanceof TripletSource.PublisherTripletSource) {
            return 1;
        }
        if (this.source instanceof TripletSource.FileTripletSource && otherSource instanceof TripletSource.FileTripletSource) {
            return Integer.compare(((TripletSource.FileTripletSource)this.source).line(), ((TripletSource.FileTripletSource)otherSource).line());
        }
        return 0;
    }

    public static class Type {
        public static final String SYNTAX_ERROR = "Syntax error";
        public static final String SUBJECT_WITHOUT_TYPE = "Subject without type";
        public static final String MISSING_ATTRIBUTE = "Missing attribute";
        public static final String DUPLICATED_ATTRIBUTE = "Duplicated attribute";
        public static final String INVALID_VALUE = "Invalid value";
        public static final String INVALID_REFERENCE = "Invalid reference";
    }

    public static enum Level {
        Error,
        Warning;

    }
}

