/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.core;

import io.intino.alexandria.Json;
import io.intino.alexandria.logger.Logger;
import io.intino.ness.master.core.MasterInitializationException;
import io.intino.ness.master.data.EntityLoader;
import io.intino.ness.master.data.FileEntityLoader;
import io.intino.ness.master.data.MasterTripletsDigester;
import io.intino.ness.master.model.Triplet;
import io.intino.ness.master.model.TripletRecord;
import io.intino.ness.master.serialization.MasterSerializer;
import io.intino.ness.master.serialization.MasterSerializers;
import java.io.File;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class Master {
    public static final String NONE_TYPE = "";
    private final Config config;
    private Map<String, String> masterMap;

    public Master(Config config) {
        this.config = Objects.requireNonNull(config);
        this.checkConfigValues();
    }

    public Map<String, String> masterMap() {
        return this.masterMap;
    }

    public File datalakeRootPath() {
        return this.config.datalakeRootPath();
    }

    public MasterTripletsDigester tripletsDigester() {
        return this.config.tripletsDigester();
    }

    public EntityLoader tripletLoader() {
        return this.config.tripletLoader();
    }

    public void start() {
        Logger.trace((String)"Initializing Master...");
        Map<String, TripletRecord> data = this.loadData();
        this.initMaps(data);
        System.gc();
        Logger.trace((String)("Data loaded into Master:\n" + this.histogram()));
        Logger.info((String)("Master initialized. Using " + this.getMemoryUsedMB() + " MB"));
    }

    public void stop() {
        this.masterMap = new ConcurrentHashMap<String, String>(0);
        System.gc();
    }

    protected void initMaps(Map<String, TripletRecord> data) {
        MasterSerializer serializer = this.serializer();
        this.masterMap = new ConcurrentHashMap<String, String>(data.size());
        this.masterMap.putAll(data.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, String>((String)e.getKey(), serializer.serialize((TripletRecord)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    protected Map<String, TripletRecord> loadData() {
        try {
            Logger.trace((String)"Loading data...");
            long start = System.currentTimeMillis();
            MasterTripletsDigester.Result result = this.config.tripletsDigester().load(this.config.tripletLoader(), this.serializer());
            result.stats().put("Num records", result.records().size());
            long time = System.currentTimeMillis() - start;
            Logger.debug((String)("Data loaded after " + time + " ms. Stats:\n" + Json.toJsonPretty(result.stats().map())));
            return result.records();
        }
        catch (Exception e) {
            throw new MasterInitializationException("Could not load master data due to a " + e.getClass().getSimpleName() + ": " + e.getMessage(), e);
        }
    }

    public MasterSerializer serializer() {
        return this.config.serializer();
    }

    private void checkConfigValues() {
        if (this.config.datalakeRootPath() == null) {
            throw new MasterInitializationException("Data directory cannot be null");
        }
        if (this.config.serializer() == null) {
            throw new MasterInitializationException("Serializer cannot be null");
        }
        if (this.config.serializer().name() == null) {
            throw new MasterInitializationException("Serializer name cannot be null");
        }
        if (this.config.tripletsDigester() == null) {
            throw new MasterInitializationException("Triplet digester cannot be null");
        }
        if (this.config.tripletLoader() == null) {
            throw new MasterInitializationException("Triplet loader cannot be null");
        }
    }

    private float getMemoryUsedMB() {
        System.gc();
        Runtime r = Runtime.getRuntime();
        long memory = r.totalMemory() - r.freeMemory();
        return (float)memory / 1024.0f / 1024.0f;
    }

    private String histogram() {
        HashMap histogram = new HashMap();
        this.masterMap.keySet().stream().map(Triplet::typeOf).map(t -> "\"" + t + "\"").forEach(key -> histogram.compute(key, (k, v) -> v == null ? 1 : v + 1));
        return "  " + histogram.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).map(e -> (String)e.getKey() + ": " + e.getValue()).collect(Collectors.joining("\n  "));
    }

    public static class Config {
        private File datalakeRootPath;
        private MasterSerializer serializer = MasterSerializers.getDefault();
        private MasterTripletsDigester tripletsDigester = MasterTripletsDigester.createDefault();
        private EntityLoader entityLoader;

        public Config() {
        }

        public Config(Map<String, String> arguments) {
            this.datalakeRootPath = new File(arguments.get("datalake_path"));
            this.serializer = MasterSerializers.get(arguments.getOrDefault("serializer", MasterSerializers.Standard.getDefault()));
            this.entityLoader = new FileEntityLoader(this.datalakeRootPath);
        }

        public Config(String[] args) {
            this(Config.toMap(args));
        }

        public File datalakeRootPath() {
            return this.datalakeRootPath;
        }

        public Config datalakeRootPath(File datalakeRootPath) {
            this.datalakeRootPath = datalakeRootPath;
            return this;
        }

        public MasterSerializer serializer() {
            return this.serializer;
        }

        public Config serializer(MasterSerializer serializer) {
            this.serializer = serializer == null ? MasterSerializers.getDefault() : serializer;
            return this;
        }

        private static Map<String, String> toMap(String[] args) {
            return Arrays.stream(args).map(s -> s.split("=")).collect(Collectors.toMap(s -> s[0].trim(), s -> s[1].trim()));
        }

        public MasterTripletsDigester tripletsDigester() {
            return this.tripletsDigester;
        }

        public Config tripletsDigester(MasterTripletsDigester digester) {
            this.tripletsDigester = digester;
            return this;
        }

        public EntityLoader tripletLoader() {
            return this.entityLoader;
        }

        public Config tripletsLoader(EntityLoader entityLoader) {
            this.entityLoader = entityLoader;
            return this;
        }
    }
}

