/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.persistence;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.ness.master.model.Triplet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class MasterTripletWriter {
    private static final String TRIPLETS_EXTENSION = ".triplets";
    private final File datalakeTripletsPath;

    public MasterTripletWriter(File datalakeTripletsPath) {
        this.datalakeTripletsPath = Objects.requireNonNull(datalakeTripletsPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(List<Triplet> triplets) throws IOException {
        Class<MasterTripletWriter> clazz = MasterTripletWriter.class;
        synchronized (MasterTripletWriter.class) {
            for (Map.Entry<String, List<Triplet>> entry : MasterTripletWriter.groupByType(triplets)) {
                this.write(entry.getKey(), entry.getValue());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String tank, List<Triplet> triplets) throws IOException {
        File tankDir = new File(this.datalakeTripletsPath, this.capitalize(tank));
        tankDir.mkdirs();
        File file = new File(tankDir, this.todaysTimetag() + TRIPLETS_EXTENSION);
        File tmp = new File(file.getAbsolutePath() + "_" + System.nanoTime() + ".tmp");
        tmp.deleteOnExit();
        try {
            if (file.exists()) {
                Files.copy(file.toPath(), tmp.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            Files.write(tmp.toPath(), this.serialize(triplets), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
            Files.move(tmp.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        finally {
            tmp.delete();
        }
    }

    private String capitalize(String s) {
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    private Iterable<String> serialize(List<Triplet> triplets) {
        List<String> lines = triplets.stream().map(Triplet::toString).collect(Collectors.toList());
        lines.add("");
        return lines;
    }

    private static Iterable<Map.Entry<String, List<Triplet>>> groupByType(List<Triplet> triplets) {
        return triplets.stream().collect(Collectors.groupingBy(Triplet::type)).entrySet();
    }

    private String todaysTimetag() {
        return Timetag.of((LocalDate)LocalDate.now(), (Scale)Scale.Day).value();
    }
}

