/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.model;

import io.intino.ness.master.model.Triplet;
import io.intino.ness.master.model.TripletRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class Entity {
    private final Id id;
    private final Map<String, Triplet> extraTriplets = new HashMap<String, Triplet>(1);

    public Entity(String id) {
        this.id = new Id(id);
        this.extraTriplets.put("enabled", new Triplet(id, "enabled", "true"));
    }

    public Id id() {
        return this.id;
    }

    public boolean enabled() {
        return "true".equalsIgnoreCase(this.getExtraAttribute("enabled"));
    }

    private void setEnabled(boolean enabled) {
        boolean oldValue = this.enabled();
        if (oldValue == enabled) {
            return;
        }
        if (enabled) {
            this.onEnable();
        } else {
            this.onDisable();
        }
    }

    protected void onEnable() {
    }

    protected void onDisable() {
    }

    public Entity add(Triplet t) {
        if (t.predicate().equals("enabled")) {
            this.setEnabled(this.parseBoolean(t.value()));
        }
        this.extraTriplets.put(t.predicate(), t);
        return this;
    }

    private boolean parseBoolean(String value) {
        return value.trim().equalsIgnoreCase("true");
    }

    public Entity remove(Triplet t) {
        this.extraTriplets.remove(t.predicate());
        return this;
    }

    public List<Triplet> triplets() {
        return new ArrayList<Triplet>(0);
    }

    public TripletRecord asTripletRecord() {
        return new TripletRecord(this.id.id, this.triplets());
    }

    public Map<String, Triplet> extraTriplets() {
        return Collections.unmodifiableMap(this.extraTriplets);
    }

    public Triplet getExtraTriplet(String predicate) {
        return this.extraTriplets.get(predicate);
    }

    public boolean hasExtraAttribute(String predicate) {
        return this.extraTriplets.containsKey(predicate);
    }

    public String getExtraAttribute(String predicate) {
        return this.hasExtraAttribute(predicate) ? this.getExtraTriplet(predicate).value() : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Entity entity = (Entity)o;
        return Objects.equals(this.id, entity.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.id.toString();
    }

    public static final class Id {
        private final String id;

        public Id(String id) {
            this.id = Objects.requireNonNull(id);
        }

        public String get() {
            return this.id;
        }

        public String value() {
            int index = this.id.indexOf(58);
            return index < 0 ? this.id : this.id.substring(0, index);
        }

        public String type() {
            return Triplet.typeOf(this.id);
        }

        public String toString() {
            return this.get();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Id id1 = (Id)o;
            return Objects.equals(this.id, id1.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }
}

