/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.messages.handlers;

import io.intino.ness.master.core.Master;
import io.intino.ness.master.messages.ListenerMasterMessage;
import io.intino.ness.master.messages.MasterMessageException;
import io.intino.ness.master.messages.MasterMessagePublisher;
import io.intino.ness.master.messages.UpdateMasterMessage;
import io.intino.ness.master.messages.handlers.MasterMessageHandler;
import io.intino.ness.master.model.Triplet;
import io.intino.ness.master.model.TripletRecord;
import io.intino.ness.master.persistence.MasterTripletWriter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public class UpdateMasterMessageHandler
implements MasterMessageHandler<UpdateMasterMessage> {
    private final Master master;

    public UpdateMasterMessageHandler(Master master) {
        this.master = master;
    }

    @Override
    public Class<UpdateMasterMessage> messageClass() {
        return UpdateMasterMessage.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(UpdateMasterMessage message) throws MasterMessageException {
        try {
            Class<UpdateMasterMessageHandler> clazz = UpdateMasterMessageHandler.class;
            synchronized (UpdateMasterMessageHandler.class) {
                switch (message.action()) {
                    case Publish: {
                        this.handlePublish(message);
                        break;
                    }
                    case Enable: {
                        this.handleEnable(message);
                        break;
                    }
                    case Disable: {
                        this.handleDisable(message);
                        break;
                    }
                    case Remove: {
                        this.handleRemove(message);
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (Throwable e) {
            throw new MasterMessageException("Error while processing the UpdateMasterMessage " + message.id(), e).serverName(this.master.instanceName()).clientName(message.clientName()).originalMessage(message);
        }
        {
            return;
        }
    }

    private void handlePublish(UpdateMasterMessage message) throws Exception {
        TripletRecord record = this.master.serializer().deserialize(message.value());
        if (this.publishNewOrModifiedTriplets(message)) {
            boolean wasAlreadyCreated = this.master.masterMap().containsKey((Object)record.id());
            this.master.masterMap().set((Object)record.id(), (Object)message.value());
            this.publishListenerMessage(message.clientName(), wasAlreadyCreated ? ListenerMasterMessage.Action.Updated : ListenerMasterMessage.Action.Created, message.id(), record.id(), message.value());
        } else {
            this.publishListenerMessage(message.clientName(), ListenerMasterMessage.Action.None, message.id(), record.id(), message.value());
        }
    }

    private void handleEnable(UpdateMasterMessage message) throws IOException {
        if (!this.setEnableOrDisable(message, true)) {
            this.publishListenerMessage(message.clientName(), ListenerMasterMessage.Action.None, message.id(), message.value(), null);
        }
    }

    private void handleDisable(UpdateMasterMessage message) throws IOException {
        if (!this.setEnableOrDisable(message, false)) {
            this.publishListenerMessage(message.clientName(), ListenerMasterMessage.Action.None, message.id(), message.value(), null);
        }
    }

    private boolean setEnableOrDisable(UpdateMasterMessage message, boolean enabledNewValue) throws IOException {
        String serializedRecord = (String)this.master.masterMap().get((Object)message.value());
        if (serializedRecord == null) {
            return false;
        }
        TripletRecord record = this.master.serializer().deserialize(serializedRecord);
        boolean wasEnabled = "true".equals(record.getValueOrDefault("enabled", "true"));
        if (wasEnabled == enabledNewValue) {
            return false;
        }
        record.put(new Triplet(record.id(), "enabled", String.valueOf(enabledNewValue)));
        serializedRecord = this.master.serializer().serialize(record);
        this.master.masterMap().set((Object)record.id(), (Object)serializedRecord);
        new MasterTripletWriter(new File(this.master.datalakeRootPath(), "triplets")).write(List.of(record.getTriplet("enabled")));
        this.publishListenerMessage(message.clientName(), enabledNewValue ? ListenerMasterMessage.Action.Enabled : ListenerMasterMessage.Action.Disabled, message.id(), record.id(), serializedRecord);
        return true;
    }

    private void handleRemove(UpdateMasterMessage message) {
        String recordId = message.value();
        if (!this.master.masterMap().containsKey((Object)recordId)) {
            this.publishListenerMessage(message.clientName(), ListenerMasterMessage.Action.None, message.id(), recordId, null);
            return;
        }
        String removedRecord = (String)this.master.masterMap().remove((Object)recordId);
        this.publishListenerMessage(message.clientName(), ListenerMasterMessage.Action.Removed, message.id(), recordId, removedRecord);
    }

    private void publishListenerMessage(String clientName, ListenerMasterMessage.Action action, String updateMessageId, String recordId, String record) {
        MasterMessagePublisher.publishMessage(this.master.hazelcast(), "MASTER_LISTENER_TOPIC", new ListenerMasterMessage(this.master.instanceName(), clientName, action, updateMessageId, recordId, record));
    }

    private boolean publishNewOrModifiedTriplets(UpdateMasterMessage message) throws Exception {
        List<Triplet> tripletsToPublish = this.getNewOrModifiedTriplets(this.master.serializer().deserialize(message.value()));
        if (tripletsToPublish.isEmpty()) {
            return false;
        }
        this.setAuthorToTriplets(message.clientName(), tripletsToPublish);
        new MasterTripletWriter(new File(this.master.datalakeRootPath(), "triplets")).write(tripletsToPublish);
        return true;
    }

    private List<Triplet> getNewOrModifiedTriplets(TripletRecord newRecord) {
        List<Triplet> triplets = newRecord.triplets().collect(Collectors.toList());
        if (!this.master.masterMap().containsKey((Object)newRecord.id())) {
            return triplets;
        }
        TripletRecord oldRecord = this.master.serializer().deserialize((String)this.master.masterMap().get((Object)newRecord.id()));
        triplets.removeIf(oldRecord::contains);
        return triplets;
    }

    private void setAuthorToTriplets(String clientName, List<Triplet> triplets) {
        if (clientName == null) {
            return;
        }
        int size = triplets.size();
        for (int i = 0; i < size; ++i) {
            Triplet t = triplets.get(i);
            if (t.author() != null) continue;
            triplets.set(i, Triplet.withAuthor(t, clientName));
        }
    }
}

