/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.data.validation.validators;

import io.intino.ness.master.data.validation.Issue;
import io.intino.ness.master.data.validation.RecordValidator;
import io.intino.ness.master.data.validation.TripletRecordStore;
import io.intino.ness.master.data.validation.TripletSource;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DuplicatedTripletRecordValidator
implements RecordValidator {
    private final Issue.Level level;

    public DuplicatedTripletRecordValidator() {
        this(Issue.Level.Error);
    }

    public DuplicatedTripletRecordValidator(Issue.Level level) {
        this.level = Objects.requireNonNull(level);
    }

    @Override
    public Stream<Issue> validate(RecordValidator.TripletRecord record, TripletRecordStore store) {
        return record.attributes().entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).map(e -> this.getIssue(record, (Map.Entry<String, List<RecordValidator.TripletRecord.Value>>)e));
    }

    private Issue getIssue(RecordValidator.TripletRecord record, Map.Entry<String, List<RecordValidator.TripletRecord.Value>> e) {
        TripletSource source0 = e.getValue().get(0).source();
        if (e.getValue().stream().allMatch(v -> Objects.equals(source0, v.source()))) {
            return Issue.create(this.level, "Duplicated attribute", "Record (" + record.id() + ") defines " + e.getKey() + " " + e.getValue().size() + " times.").source(e.getValue().get(e.getValue().size() - 1).source());
        }
        return Issue.create(this.level, "Duplicated attribute", "Record (" + record.id() + ") defines " + e.getKey() + " " + e.getValue().size() + " times in different files.").source(new CombinedTripletSource(e.getValue().stream().map(RecordValidator.TripletRecord.Value::source).map(TripletSource::get).collect(Collectors.toList())));
    }

    public static class CombinedTripletSource
    implements TripletSource {
        private final List<String> names;

        public CombinedTripletSource(List<String> names) {
            this.names = names;
        }

        public List<String> names() {
            return this.names;
        }

        @Override
        public String name() {
            return "Duplicated fields across different sources";
        }

        @Override
        public String get() {
            return "Sources:\n\t\t" + String.join((CharSequence)"\n\t\t", this.names);
        }
    }
}

