/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.data.validation.report;

import io.intino.ness.master.data.validation.Issue;
import io.intino.ness.master.data.validation.TripletSource;
import io.intino.ness.master.data.validation.report.IssueReport;
import io.intino.ness.master.data.validation.validators.DuplicatedTripletRecordValidator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class HtmlIssueReportDocumentBuilder {
    private static final String BLANK_LINE = "<p>&nbsp;</p>";
    private final IssueReport issueReport;

    public HtmlIssueReportDocumentBuilder(IssueReport issueReport) {
        this.issueReport = issueReport;
    }

    public void build(File file) {
        file.getParentFile().mkdirs();
        HtmlBuilder builder = new HtmlBuilder();
        builder.addHtmlTag(false);
        HtmlTemplate template = HtmlTemplate.get("issues-report.html");
        template.set("count", String.valueOf(this.issueReport.count()));
        template.set("error-count", String.valueOf(this.issueReport.errorCount()));
        template.set("warnings-count", String.valueOf(this.issueReport.warningCount()));
        template.set("sources-count", String.valueOf(this.issueReport.getAll().size()));
        template.set("issues", this.renderIssues());
        template.set("issues-levels-chart-data", this.renderIssuesLevelsChartData());
        template.set("issues-types-chart-data", this.renderIssuesTypesChartData());
        template.set("content", this.renderContent());
        builder.append(template.html());
        try {
            Files.writeString(file.toPath(), (CharSequence)builder.build(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String renderContent1() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<Issue>> entry : this.sortByNumErrors(new HashSet<Map.Entry<String, List<Issue>>>(this.issueReport.getAll().entrySet()))) {
            sb.append("<h4 id=\"").append(entry.getKey().hashCode()).append("\">").append(entry.getKey()).append(" (").append(entry.getValue().size()).append("):</h4>");
            sb.append("<ul class=\"list-group\">");
            entry.getValue().stream().filter(e -> e.level() == Issue.Level.Error).sorted(this.sortByLine()).map(this::render).forEach(sb::append);
            entry.getValue().stream().filter(e -> e.level() == Issue.Level.Warning).sorted(this.sortByLine()).map(this::render).forEach(sb::append);
            sb.append("</ul>").append(BLANK_LINE);
        }
        return sb.toString();
    }

    private String renderContent() {
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"accordion\" id=\"accordionContent\">");
        int index = 0;
        for (Map.Entry<String, List<Issue>> entry : this.sortByNumErrors(new HashSet<Map.Entry<String, List<Issue>>>(this.issueReport.getAll().entrySet()))) {
            this.renderCard(sb, entry, index++);
        }
        sb.append("</div>");
        return sb.toString();
    }

    private void renderCard(StringBuilder sb, Map.Entry<String, List<Issue>> entry, int index) {
        int errors = this.numErrors(entry.getValue());
        int warnings = entry.getValue().size() - errors;
        sb.append("<div class=\"card\">");
        sb.append("<div class=\"card-header d-flex\" id=\"heading").append(index).append("\">");
        sb.append("<h5 class=\"mb-0\">");
        sb.append(String.format("<div class=\"btn\" type=\"button\" data-toggle=\"collapse\" data-target=\"#collapse%d\" aria-expanded=\"true\" aria-controls=\"collapse%d\">", index, index));
        sb.append("<div>").append(entry.getKey()).append("</div>");
        sb.append("</div></h5>");
        sb.append(this.badgeGroup(warnings, errors));
        sb.append("</div>");
        sb.append(String.format("<div id=\"collapse%d\" class=\"collapse\" aria-labelledby=\"heading%d\" data-parent=\"#accordionContent\">", index, index));
        sb.append("<div class=\"card-body\">");
        sb.append("<ul class=\"list-group\">");
        entry.getValue().stream().filter(e -> e.level() == Issue.Level.Error).sorted(this.sortByLine()).map(this::render).forEach(sb::append);
        entry.getValue().stream().filter(e -> e.level() == Issue.Level.Warning).sorted(this.sortByLine()).map(this::render).forEach(sb::append);
        sb.append("</ul>");
        sb.append("</div></div></div>");
    }

    private String badgeGroup(int warnings, int errors) {
        return "<div class=\"d-flex align-items-right ml-auto align-items-center ml-auto\">\n<span class=\"badge badge-danger badge-pill mr-1\">" + errors + "</span>\n<span class=\"badge badge-warning badge-pill mr-1\">" + warnings + "</span>\n<span class=\"badge badge-primary badge-pill mr-1\">" + (errors + warnings) + "</span>\n</div>";
    }

    private Comparator<? super Issue> sortByLine() {
        return Comparator.comparing(issue -> !(issue.source() instanceof TripletSource.FileTripletSource) ? Integer.MAX_VALUE : ((TripletSource.FileTripletSource)issue.source()).line());
    }

    private String render(Issue issue) {
        if (issue.source() instanceof DuplicatedTripletRecordValidator.CombinedTripletSource) {
            return this.renderIssueCombinedSource(issue);
        }
        String level = issue.level() == Issue.Level.Error ? "danger" : "warning";
        return "<div class=\"list-group-item list-group-item-" + level + " mb-1\"><div><i class=\"fa-solid fa-skating fa-fw\" style=\"background:DodgerBlue\"></i>" + issue.levelMsg() + "</div>" + (String)(issue.source() == null ? "" : "<small>At " + issue.source().get() + "</small>") + "</div>";
    }

    private String renderIssueCombinedSource(Issue issue) {
        String level = issue.level() == Issue.Level.Error ? "danger" : "warning";
        StringBuilder sb = new StringBuilder("<div class=\"list-group-item list-group-item-" + level + " mb-1\">");
        sb.append("<p><b>[").append(issue.level().name()).append("]</b> ").append(issue.message()).append("</p>");
        for (String name : ((DuplicatedTripletRecordValidator.CombinedTripletSource)issue.source()).names()) {
            sb.append("<p><small>At ").append(name).append("</small></p>");
        }
        return sb.append("</div>").toString();
    }

    private String renderIssues() {
        StringBuilder sb = new StringBuilder();
        float total = this.issueReport.count();
        for (Map.Entry<String, IssueReport.IssuesCount> entry : this.issueReport.issueTypes().entrySet()) {
            IssueReport.IssuesCount count = entry.getValue();
            String percentage = String.format("%.02f", Float.valueOf((float)count.total() / total * 100.0f));
            sb.append(this.listItemBadge(entry.getKey() + " <b>(" + percentage + "%)</b>", count.warnings(), count.errors()));
        }
        return sb.toString();
    }

    private String renderIssuesLevelsChartData() {
        StringBuilder sb = new StringBuilder();
        int errors = this.issueReport.errorCount();
        int warnings = this.issueReport.warningCount();
        float total = errors + warnings;
        sb.append("{ name: '").append("Errors").append("'").append(", y: ").append(String.format("%.02f", Float.valueOf((float)errors / total * 100.0f)).replace(",", ".")).append("},");
        sb.append("{ name: '").append("Warnings").append("'").append(", y: ").append(String.format("%.02f", Float.valueOf((float)warnings / total * 100.0f)).replace(",", ".")).append("}");
        return sb.toString();
    }

    private String renderIssuesTypesChartData() {
        StringBuilder sb = new StringBuilder();
        float total = this.issueReport.count();
        boolean first = true;
        for (Map.Entry<String, IssueReport.IssuesCount> entry : this.issueReport.issueTypes().entrySet()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            IssueReport.IssuesCount count = entry.getValue();
            String percentage = String.format("%.02f", Float.valueOf((float)count.total() / total * 100.0f)).replace(",", ".");
            sb.append("{ name: '").append(entry.getKey()).append("'").append(", y: ").append(percentage).append("}");
        }
        return sb.toString();
    }

    private List<? extends Map.Entry<String, List<Issue>>> sortByNumErrors(Set<Map.Entry<String, List<Issue>>> entrySet) {
        return entrySet.stream().sorted((e1, e2) -> -Integer.compare(this.numErrors((List)e1.getValue()), this.numErrors((List)e2.getValue()))).collect(Collectors.toList());
    }

    private int numErrors(List<Issue> issueList) {
        return (int)issueList.stream().filter(issue -> issue.level().equals((Object)Issue.Level.Error)).count();
    }

    private String listItemBadge(String text, int warnings, int errors) {
        return "<li class=\"list-group-item d-flex\"><div>" + text + "</div>\n<div class=\"d-flex align-items-right ml-auto align-items-center ml-auto\"><span class=\"badge badge-danger badge-pill mr-1\">" + errors + "</span><span class=\"badge badge-warning badge-pill mr-1\">" + warnings + "</span><span class=\"badge badge-primary badge-pill mr-1\">" + (warnings + errors) + "</span></div>\n<span class=\"border-bottom-1\"></span></li>";
    }

    public static class HtmlTemplate {
        private final StringBuilder html;

        public static HtmlTemplate get(String name) {
            HtmlTemplate htmlTemplate;
            BufferedReader reader = new BufferedReader(new InputStreamReader(HtmlTemplate.class.getResourceAsStream("/" + name)));
            try {
                htmlTemplate = new HtmlTemplate(reader.lines().collect(Collectors.joining("\n")));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to open " + name, e);
                }
            }
            reader.close();
            return htmlTemplate;
        }

        public HtmlTemplate(String html) {
            this.html = new StringBuilder(html);
        }

        public HtmlTemplate set(String variable, String value) {
            int index;
            variable = String.format("'$%s'", variable);
            while ((index = this.html.indexOf(variable)) >= 0) {
                this.html.replace(index, index + variable.length(), value);
            }
            return this;
        }

        public String html() {
            return this.html.toString();
        }

        public String toString() {
            return this.html();
        }
    }

    public static class HtmlBuilder {
        private final StringBuilder html = new StringBuilder(8192);
        private boolean addHtmlTag = true;

        public HtmlBuilder addHtmlTag(boolean addHtmlTag) {
            this.addHtmlTag = addHtmlTag;
            return this;
        }

        public HtmlBuilder append(HtmlTemplate template) {
            this.html.append(template.html());
            return this;
        }

        public HtmlBuilder append(String str) {
            this.html.append(str);
            return this;
        }

        public String build() {
            return this.addHtmlTag ? "<html>" + this.html + "</html>" : this.html.toString();
        }

        public String toString() {
            return this.build();
        }
    }
}

