/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.data.validation;

public interface TripletSource {
    public static TripletSource ofFile(String path, int line) {
        return new FileTripletSource(path, line);
    }

    public static TripletSource ofPublisher(String senderName) {
        return new PublisherTripletSource(senderName);
    }

    public String name();

    public String get();

    public static class PublisherTripletSource
    implements TripletSource {
        private final String senderName;

        public PublisherTripletSource(String senderName) {
            this.senderName = senderName;
        }

        @Override
        public String name() {
            return this.senderName;
        }

        @Override
        public String get() {
            return "Publisher '" + this.senderName + "'";
        }

        public String toString() {
            return this.get();
        }
    }

    public static class FileTripletSource
    implements TripletSource {
        private final String path;
        private final int line;

        public FileTripletSource(String path, int line) {
            this.path = path;
            this.line = line;
        }

        @Override
        public String name() {
            return this.path;
        }

        @Override
        public String get() {
            return "File " + this.path + "(" + this.line + ")";
        }

        public String path() {
            return this.path;
        }

        public int line() {
            return this.line;
        }

        public String toString() {
            return this.get();
        }
    }
}

