/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.data;

import io.intino.ness.master.data.ComponentAttributeDefinition;
import io.intino.ness.master.data.DefaultTripletsDigester;
import io.intino.ness.master.data.MasterTripletsDigester;
import io.intino.ness.master.data.TripletLoader;
import io.intino.ness.master.model.Triplet;
import io.intino.ness.master.model.TripletRecord;
import io.intino.ness.master.serialization.MasterSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ComponentsTripletsDigester
extends DefaultTripletsDigester {
    protected static final String LIST_ENTRY_SEPARATOR = ",";
    protected static final String MAP_ENTRY_SEPARATOR = ",";
    private final Map<String, List<ComponentAttributeDefinition>> componentsByEntityType;
    private final Set<String> typesWithComponents;
    private final Set<String> componentTypes;

    public ComponentsTripletsDigester(Map<String, List<ComponentAttributeDefinition>> componentsByEntityType, Set<String> typesWithComponents, Set<String> componentTypes) {
        this.componentsByEntityType = componentsByEntityType;
        this.typesWithComponents = typesWithComponents;
        this.componentTypes = componentTypes;
    }

    @Override
    public MasterTripletsDigester.Result load(TripletLoader tripletLoader, MasterSerializer serializer) throws Exception {
        MasterTripletsDigester.WritableResult result = MasterTripletsDigester.Result.create();
        Map<String, TripletRecord> entities = result.records();
        HashMap<String, TripletRecord> components = new HashMap<String, TripletRecord>();
        tripletLoader.loadTriplets(result.stats()).forEach(t -> this.register(entities, (Map<String, TripletRecord>)components, (Triplet)t));
        this.handleComponents(entities, components, serializer);
        return result;
    }

    private void register(Map<String, TripletRecord> entities, Map<String, TripletRecord> components, Triplet triplet) {
        Map<String, TripletRecord> map = this.isComponent(triplet.type()) ? components : entities;
        map.computeIfAbsent(triplet.subject(), TripletRecord::new).put(triplet);
    }

    private void handleComponents(Map<String, TripletRecord> entities, Map<String, TripletRecord> components, MasterSerializer serializer) {
        for (TripletRecord entity : entities.values()) {
            if (!this.hasComponents(entity)) continue;
            this.setEntityComponents(entity, components, serializer);
        }
    }

    private void setEntityComponents(TripletRecord entity, Map<String, TripletRecord> components, MasterSerializer serializer) {
        String entityId = entity.id().substring(0, entity.id().indexOf(58));
        for (TripletRecord component : components.values()) {
            if (!this.isComponentOfEntity(component, entityId)) continue;
            this.addComponentToEntity(component, entity, serializer);
        }
    }

    private void addComponentToEntity(TripletRecord component, TripletRecord entity, MasterSerializer serializer) {
        if (!this.componentsByEntityType.containsKey(entity.type())) {
            return;
        }
        String componentType = component.type();
        for (ComponentAttributeDefinition def : this.componentsByEntityType.get(entity.type())) {
            if (!def.component().equals(componentType)) continue;
            if (def.type() == ComponentAttributeDefinition.Type.Reference) {
                this.setEntityComponent(def.name(), component, entity, serializer);
                continue;
            }
            if (def.type() == ComponentAttributeDefinition.Type.List) {
                this.updateEntityComponentList(def.name(), component, entity, serializer);
                continue;
            }
            if (def.type() != ComponentAttributeDefinition.Type.Map) continue;
            this.updateEntityComponentMap(def.name(), component, entity, serializer);
        }
    }

    private void updateEntityComponentMap(String name, TripletRecord component, TripletRecord entity, MasterSerializer serializer) {
        String attrib = entity.getValue(name);
        Map<Object, Object> map = attrib == null ? new HashMap<String, String>(1) : Arrays.stream(attrib.split(",")).map(s -> s.split("=")).collect(Collectors.toMap(s -> s[0], s -> s[1]));
        map.put(component.id(), serializer.serialize(component));
        entity.put(new Triplet(entity.id(), name, map.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(","))));
    }

    private void updateEntityComponentList(String name, TripletRecord component, TripletRecord entity, MasterSerializer serializer) {
        String attrib = entity.getValue(name);
        List<Object> list = attrib == null ? new ArrayList() : Arrays.asList(attrib.split(","));
        list.add(serializer.serialize(component));
        entity.put(new Triplet(entity.id(), name, String.join((CharSequence)",", list)));
    }

    private void setEntityComponent(String name, TripletRecord component, TripletRecord entity, MasterSerializer serializer) {
        entity.put(new Triplet(entity.id(), name, serializer.serialize(component)));
    }

    private boolean isComponentOfEntity(TripletRecord component, String entityId) {
        return component.id().startsWith(entityId);
    }

    private boolean hasComponents(TripletRecord entity) {
        return this.typesWithComponents.contains(entity.type());
    }

    private boolean isComponent(String id) {
        return this.componentTypes.contains(Triplet.typeOf(id));
    }
}

