/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.master.core;

import com.hazelcast.config.NetworkConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.topic.Message;
import io.intino.alexandria.Json;
import io.intino.alexandria.logger.Logger;
import io.intino.ness.master.core.MasterInitializationException;
import io.intino.ness.master.data.FileTripletLoader;
import io.intino.ness.master.data.MasterTripletsDigester;
import io.intino.ness.master.data.TripletLoader;
import io.intino.ness.master.messages.ErrorMasterMessage;
import io.intino.ness.master.messages.MasterMessageException;
import io.intino.ness.master.messages.MasterMessagePublisher;
import io.intino.ness.master.messages.handlers.UpdateMasterMessageHandler;
import io.intino.ness.master.model.Triplet;
import io.intino.ness.master.model.TripletRecord;
import io.intino.ness.master.serialization.MasterSerializer;
import io.intino.ness.master.serialization.MasterSerializers;
import java.io.File;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class Master {
    public static final String METADATA_MAP_NAME = "metadata";
    public static final String MASTER_MAP_NAME = "master";
    public static final String NONE_TYPE = "";
    private HazelcastInstance hazelcast;
    private final Config config;
    private IMap<String, String> metadataMap;
    private IMap<String, String> masterMap;

    public Master(Config config) {
        this.config = Objects.requireNonNull(config);
        this.checkConfigValues();
    }

    public IMap<String, String> masterMap() {
        return this.masterMap;
    }

    public IMap<String, String> metadataMap() {
        return this.metadataMap;
    }

    public File datalakeRootPath() {
        return this.config.datalakeRootPath();
    }

    public String instanceName() {
        return this.config.instanceName();
    }

    public int port() {
        return this.config.port();
    }

    public String host() {
        return this.config.host();
    }

    public MasterTripletsDigester tripletsDigester() {
        return this.config.tripletsDigester();
    }

    public TripletLoader tripletLoader() {
        return this.config.tripletLoader();
    }

    public void start() {
        Logger.trace((String)"Initializing Master...");
        Map<String, TripletRecord> data = this.loadData();
        this.initHazelcast();
        this.initMaps(data);
        this.setupListeners();
        System.gc();
        Logger.trace((String)("Data loaded into Master:\n" + this.histogram()));
        Logger.info((String)("Master initialized. Using " + this.getHazelcastMemoryUsedMB() + " MB"));
    }

    public void stop() {
        this.hazelcast.shutdown();
    }

    private void initHazelcast() {
        Logger.trace((String)"Initializing hazelcast instance...");
        this.hazelcast = Hazelcast.newHazelcastInstance((com.hazelcast.config.Config)this.getHazelcastConfig());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.hazelcast.shutdown(), "Master-Shutdown"));
    }

    protected void initMaps(Map<String, TripletRecord> data) {
        MasterSerializer serializer = this.serializer();
        this.metadataMap = this.hazelcast.getMap(METADATA_MAP_NAME);
        this.metadataMap.set((Object)"instanceName", (Object)this.config.instanceName());
        this.metadataMap.set((Object)"port", (Object)String.valueOf(this.config.port()));
        this.metadataMap.set((Object)"host", (Object)this.config.host());
        this.metadataMap.set((Object)"serializer", (Object)serializer.name());
        this.metadataMap.set((Object)"datalakeRootPath", (Object)this.config.datalakeRootPath().getPath());
        this.masterMap = this.hazelcast.getMap(MASTER_MAP_NAME);
        this.masterMap.setAll(data.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, String>((String)e.getKey(), serializer.serialize((TripletRecord)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    protected Map<String, TripletRecord> loadData() {
        try {
            Logger.trace((String)"Loading data...");
            long start = System.currentTimeMillis();
            MasterTripletsDigester.Result result = this.config.tripletsDigester().load(this.config.tripletLoader(), this.serializer());
            result.stats().put("Num records", result.records().size());
            long time = System.currentTimeMillis() - start;
            Logger.debug((String)("Data loaded after " + time + " ms. Stats:\n" + Json.toJsonPretty(result.stats().map())));
            return result.records();
        }
        catch (Exception e) {
            throw new MasterInitializationException("Could not load master data due to a " + e.getClass().getSimpleName() + ": " + e.getMessage(), e);
        }
    }

    protected void setupListeners() {
        this.hazelcast.getTopic("MASTER_UPDATE_TOPIC").addMessageListener(this::handleRequestMessage);
    }

    protected void handleRequestMessage(Message<Object> hzMessage) {
        try {
            new UpdateMasterMessageHandler(this).handle(hzMessage.getMessageObject());
        }
        catch (MasterMessageException e) {
            Logger.error((Throwable)e);
            this.notifyError(e);
        }
    }

    private void notifyError(MasterMessageException error) {
        try {
            MasterMessagePublisher.publishMessage(this.hazelcast, "MASTER_ERROR_TOPIC", new ErrorMasterMessage(error));
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
        }
    }

    public MasterSerializer serializer() {
        return this.config.serializer();
    }

    protected com.hazelcast.config.Config getHazelcastConfig() {
        com.hazelcast.config.Config hzConfig = new com.hazelcast.config.Config();
        this.config.properties().forEach((arg_0, arg_1) -> ((com.hazelcast.config.Config)hzConfig).setProperty(arg_0, arg_1));
        hzConfig.setInstanceName(this.config.instanceName());
        hzConfig.setNetworkConfig(new NetworkConfig().setPort(this.config.port()));
        return hzConfig;
    }

    private void checkConfigValues() {
        if (this.config.instanceName() == null) {
            throw new MasterInitializationException("Instance name cannot be null");
        }
        if (this.config.datalakeRootPath() == null) {
            throw new MasterInitializationException("Data directory cannot be null");
        }
        if (this.config.host() == null) {
            throw new MasterInitializationException("Host cannot be null");
        }
        if (this.config.port() <= 0) {
            throw new MasterInitializationException("Port is invalid");
        }
        if (this.config.serializer() == null) {
            throw new MasterInitializationException("Serializer cannot be null");
        }
        if (this.config.serializer().name() == null) {
            throw new MasterInitializationException("Serializer name cannot be null");
        }
        if (this.config.tripletsDigester() == null) {
            throw new MasterInitializationException("Triplet digester cannot be null");
        }
        if (this.config.tripletLoader() == null) {
            throw new MasterInitializationException("Triplet loader cannot be null");
        }
    }

    private float getHazelcastMemoryUsedMB() {
        long metadata = this.metadataMap.getLocalMapStats().getOwnedEntryMemoryCost();
        long data = this.masterMap.getLocalMapStats().getOwnedEntryMemoryCost();
        return (float)(metadata + data) / 1024.0f / 1024.0f;
    }

    private String histogram() {
        HashMap histogram = new HashMap();
        this.masterMap.keySet().stream().map(Triplet::typeOf).map(t -> "\"" + t + "\"").forEach(key -> histogram.compute(key, (k, v) -> v == null ? 1 : v + 1));
        return "  " + histogram.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).map(e -> (String)e.getKey() + ": " + e.getValue()).collect(Collectors.joining("\n  "));
    }

    public HazelcastInstance hazelcast() {
        return this.hazelcast;
    }

    public static class Config {
        public static final int DEFAULT_PORT = 5701;
        public static final String DEFAULT_INSTANCE_NAME = "master";
        public static final String DEFAULT_HOST = "localhost";
        public static final String DEFAULT_LOG_API = "none";
        private File datalakeRootPath;
        private String instanceName = "master";
        private int port = 5701;
        private String host = "localhost";
        private MasterSerializer serializer = MasterSerializers.getDefault();
        private MasterTripletsDigester tripletsDigester = MasterTripletsDigester.createDefault();
        private TripletLoader tripletLoader;
        private final Map<String, String> properties = new HashMap<String, String>(this){
            final /* synthetic */ Config this$0;
            {
                this.this$0 = this$0;
                this.put("hazelcast.logging.type", Config.DEFAULT_LOG_API);
            }
        };

        public Config() {
        }

        public Config(Map<String, String> arguments) {
            this.datalakeRootPath = new File(arguments.get("datalake_path"));
            this.instanceName = arguments.getOrDefault("master_instance_name", this.instanceName);
            this.port = Integer.parseInt(arguments.getOrDefault("port", String.valueOf(this.port)));
            this.serializer = MasterSerializers.get(arguments.getOrDefault("serializer", MasterSerializers.Standard.getDefault()));
            this.host = arguments.getOrDefault("host", this.host);
            this.tripletLoader = new FileTripletLoader(this.datalakeRootPath);
        }

        public Config(String[] args) {
            this(Config.toMap(args));
        }

        public File datalakeRootPath() {
            return this.datalakeRootPath;
        }

        public Config datalakeRootPath(File datalakeRootPath) {
            this.datalakeRootPath = datalakeRootPath;
            return this;
        }

        public String instanceName() {
            return this.instanceName;
        }

        public Config instanceName(String instanceName) {
            this.instanceName = instanceName == null ? "master" : instanceName;
            return this;
        }

        public int port() {
            return this.port;
        }

        public Config port(Integer port) {
            this.port = port == null ? 5701 : port;
            return this;
        }

        public String host() {
            return this.host;
        }

        public Config host(String host) {
            this.host = host == null ? DEFAULT_HOST : host;
            return this;
        }

        public MasterSerializer serializer() {
            return this.serializer;
        }

        public Config serializer(MasterSerializer serializer) {
            this.serializer = serializer == null ? MasterSerializers.getDefault() : serializer;
            return this;
        }

        private static Map<String, String> toMap(String[] args) {
            return Arrays.stream(args).map(s -> s.split("=")).collect(Collectors.toMap(s -> s[0].trim(), s -> s[1].trim()));
        }

        public MasterTripletsDigester tripletsDigester() {
            return this.tripletsDigester;
        }

        public Config tripletsDigester(MasterTripletsDigester digester) {
            this.tripletsDigester = digester;
            return this;
        }

        public TripletLoader tripletLoader() {
            return this.tripletLoader;
        }

        public Config tripletsLoader(TripletLoader tripletLoader) {
            this.tripletLoader = tripletLoader;
            return this;
        }

        public Map<String, String> properties() {
            return this.properties;
        }

        public Config putProperty(String key, String value) {
            this.properties.put(key, value);
            return this;
        }
    }
}

