/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.inl;

import io.intino.ness.inl.Message;
import io.intino.ness.inl.MessageReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public interface MessageInputStream {
    public String name();

    public void name(String var1);

    public Message next() throws IOException;

    public void close() throws IOException;

    public static class Empty
    implements MessageInputStream {
        @Override
        public String name() {
            return "empty";
        }

        @Override
        public void name(String value) {
        }

        @Override
        public Message next() throws IOException {
            return null;
        }

        @Override
        public void close() throws IOException {
        }

        public String toString() {
            return this.name();
        }
    }

    public static class Sort
    extends Collection {
        public Sort(Iterator<Message> iterator) {
            super(iterator);
        }

        public static MessageInputStream of(MessageInputStream ... inputs) throws IOException {
            ArrayList<Message> messages = new ArrayList<Message>();
            String name = "sort";
            for (MessageInputStream input : inputs) {
                messages.addAll(MessageReader.readAll(input));
                name = name + ":" + input.name();
            }
            Collections.sort(messages, Sort.byTs());
            Sort sort = new Sort(messages.iterator());
            sort.name(name);
            return sort;
        }

        private static Comparator<Message> byTs() {
            return new Comparator<Message>(){

                @Override
                public int compare(Message o1, Message o2) {
                    return o1.ts().compareTo(o2.ts());
                }
            };
        }
    }

    public static class Collection
    implements MessageInputStream {
        private String name;
        private Iterator<Message> iterator;

        public Collection(Iterator<Message> iterator) {
            this.iterator = iterator;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public void name(String value) {
            this.name = value;
        }

        @Override
        public Message next() throws IOException {
            return this.iterator.hasNext() ? this.iterator.next() : null;
        }

        @Override
        public void close() throws IOException {
        }

        public String toString() {
            return this.name;
        }
    }
}

