/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.inl;

import io.intino.ness.inl.Message;
import io.intino.ness.inl.MessageOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileMessageOutputStream
implements MessageOutputStream {
    private final ZipOutputStream os;

    public static FileMessageOutputStream of(File file) throws IOException {
        return new FileMessageOutputStream(file);
    }

    private FileMessageOutputStream(File file) throws IOException {
        file.getParentFile().mkdir();
        this.os = new ZipOutputStream(new FileOutputStream(file));
        this.os.putNextEntry(new ZipEntry("events.inl"));
    }

    @Override
    public void write(String message) throws IOException {
        String data = message + "\n\n";
        this.os.write(data.getBytes());
    }

    @Override
    public void write(Message message) throws IOException {
        this.write(message.toString());
    }

    @Override
    public void close() throws IOException {
        this.os.closeEntry();
        this.os.close();
    }
}

