/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.inl;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class Accessory {
    public static final Map<Class, Formatter> formatters = new HashMap<Class, Formatter>();
    public static final Map<Class, Parser> parsers = new HashMap<Class, Parser>();
    private static final DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
    private static final String NullValue = "\u0000";

    static FieldQuery fieldsOf(Object object) {
        return new FieldQuery(object);
    }

    static List<Field> fieldsOf(Class type) {
        if (type == null) {
            return new ArrayList<Field>();
        }
        List<Field> list = Accessory.fieldsOf(type.getSuperclass());
        list.addAll(Arrays.asList(type.getDeclaredFields()));
        return list;
    }

    static String normalize(String line) {
        if (line == null) {
            return null;
        }
        if (line.startsWith("\t")) {
            return line;
        }
        if ((line = line.trim()).isEmpty()) {
            return line;
        }
        if (line.startsWith("[")) {
            return line;
        }
        return line.replaceAll("(\\w*)\\s*[:=]\\s*(.*)", "$1:$2");
    }

    static String unwrap(String text) {
        return text.startsWith("[") ? text.substring(1, text.length() - 1) : text;
    }

    static boolean isMultilineIn(String line) {
        return line.startsWith("\t");
    }

    static boolean isMessageIn(String line) {
        return line.startsWith("[");
    }

    static boolean isAttributeIn(String line) {
        return line.contains(":");
    }

    private static String formatText(Object o) {
        if (o == null) {
            return NullValue;
        }
        String text = o.toString();
        return text.contains("\n") ? "\n\t" + text.replaceAll("\n", "\n\t") : text;
    }

    private static Date parseDate(String text) {
        try {
            return dateFormatter.parse(text);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private static Class<?> instantClass() {
        try {
            return Class.forName("java.time.Instant");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Parser instantParserOf(Class<?> instantClass) {
        try {
            final Method method = instantClass.getDeclaredMethod("parse", CharSequence.class);
            return new Parser(){

                @Override
                public Object parse(String text) {
                    try {
                        return method.invoke(null, text);
                    }
                    catch (Throwable e) {
                        return Accessory.simpleDateFormatter(text);
                    }
                }
            };
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Object simpleDateFormatter(String text) {
        try {
            Date date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").parse(text);
            Method toInstant = Date.class.getDeclaredMethod("toInstant", new Class[0]);
            try {
                return toInstant.invoke((Object)date, text);
            }
            catch (Throwable e) {
                return null;
            }
        }
        catch (NoSuchMethodException | ParseException e) {
            return null;
        }
    }

    private static Formatter instantFormatter() {
        return new Formatter(){

            @Override
            public String format(Object value) {
                return value.toString();
            }
        };
    }

    static {
        dateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        parsers.put(Boolean.TYPE, new Parser(){

            @Override
            public Object parse(String text) {
                return Boolean.parseBoolean(text);
            }
        });
        parsers.put(Byte.TYPE, new Parser(){

            @Override
            public Object parse(String text) {
                return Byte.parseByte(text);
            }
        });
        parsers.put(Integer.TYPE, new Parser(){

            @Override
            public Object parse(String text) {
                return Integer.parseInt(text);
            }
        });
        parsers.put(Float.TYPE, new Parser(){

            @Override
            public Object parse(String text) {
                return Float.valueOf(Float.parseFloat(text));
            }
        });
        parsers.put(Double.TYPE, new Parser(){

            @Override
            public Object parse(String text) {
                return Double.parseDouble(text);
            }
        });
        parsers.put(Boolean.class, parsers.get(Boolean.TYPE));
        parsers.put(Byte.class, parsers.get(Byte.TYPE));
        parsers.put(Integer.class, parsers.get(Integer.TYPE));
        parsers.put(Float.class, parsers.get(Float.TYPE));
        parsers.put(Double.class, parsers.get(Double.TYPE));
        parsers.put(String.class, new Parser(){

            @Override
            public Object parse(String text) {
                return text;
            }
        });
        parsers.put(Date.class, new Parser(){

            @Override
            public Object parse(String text) {
                return Accessory.parseDate(text);
            }
        });
        parsers.put(Boolean[].class, new Parser(){

            @Override
            public Object parse(String text) {
                return ArrayParser.of(Boolean.class).parse(text);
            }
        });
        parsers.put(Byte[].class, new Parser(){

            @Override
            public Object parse(String text) {
                return ArrayParser.of(Byte.class).parse(text);
            }
        });
        parsers.put(Integer[].class, new Parser(){

            @Override
            public Object parse(String text) {
                return ArrayParser.of(Integer.class).parse(text);
            }
        });
        parsers.put(Float[].class, new Parser(){

            @Override
            public Object parse(String text) {
                return ArrayParser.of(Float.class).parse(text);
            }
        });
        parsers.put(Double[].class, new Parser(){

            @Override
            public Object parse(String text) {
                return ArrayParser.of(Double.class).parse(text);
            }
        });
        parsers.put(String[].class, new Parser(){

            @Override
            public Object parse(String text) {
                return ArrayParser.of(String.class).parse(text);
            }
        });
        parsers.put(Date[].class, new Parser(){

            @Override
            public Object parse(String text) {
                return ArrayParser.of(Date.class).parse(text);
            }
        });
        formatters.put(Boolean.class, new Formatter(){

            @Override
            public String format(Object data) {
                return data.toString();
            }
        });
        formatters.put(Byte.class, new Formatter(){

            @Override
            public String format(Object data) {
                return data.toString();
            }
        });
        formatters.put(Integer.class, new Formatter(){

            @Override
            public String format(Object data) {
                return data.toString();
            }
        });
        formatters.put(Float.class, new Formatter(){

            @Override
            public String format(Object data) {
                return data.toString();
            }
        });
        formatters.put(Double.class, new Formatter(){

            @Override
            public String format(Object data) {
                return data.toString();
            }
        });
        formatters.put(String.class, new Formatter(){

            @Override
            public String format(Object text) {
                return Accessory.formatText(text);
            }
        });
        formatters.put(Date.class, new Formatter(){

            @Override
            public String format(Object date) {
                return dateFormatter.format(date);
            }
        });
        formatters.put(Boolean[].class, new Formatter(){

            @Override
            public String format(Object array) {
                return ArrayFormatter.of(Boolean.class).format(array);
            }
        });
        formatters.put(Byte[].class, new Formatter(){

            @Override
            public String format(Object array) {
                return ArrayFormatter.of(Byte.class).format(array);
            }
        });
        formatters.put(Integer[].class, new Formatter(){

            @Override
            public String format(Object array) {
                return ArrayFormatter.of(Integer.class).format(array);
            }
        });
        formatters.put(Float[].class, new Formatter(){

            @Override
            public String format(Object array) {
                return ArrayFormatter.of(Float.class).format(array);
            }
        });
        formatters.put(Double[].class, new Formatter(){

            @Override
            public String format(Object array) {
                return ArrayFormatter.of(Double.class).format(array);
            }
        });
        formatters.put(String[].class, new Formatter(){

            @Override
            public String format(Object array) {
                return ArrayFormatter.of(String.class).format(array);
            }
        });
        formatters.put(Date[].class, new Formatter(){

            @Override
            public String format(Object array) {
                return ArrayFormatter.of(Date.class).format(array);
            }
        });
        String version = System.getProperty("java.version");
        Class<?> instantClass = Accessory.instantClass();
        if (version.startsWith("1.8") && instantClass != null) {
            formatters.put(instantClass, Accessory.instantFormatter());
            parsers.put(instantClass, Accessory.instantParserOf(instantClass));
        }
    }

    private static class ArrayParser {
        private Class type;
        private Parser parser;

        ArrayParser(Class type, Parser parser) {
            this.type = type;
            this.parser = parser;
        }

        static ArrayParser of(Class type) {
            return new ArrayParser(type, parsers.get(type));
        }

        Object parse(String text) {
            String[] lines = text.split("\n");
            Object result = Array.newInstance(this.type, lines.length);
            for (int i = 0; i < lines.length; ++i) {
                Array.set(result, i, Accessory.NullValue.equals(lines[i]) ? null : this.parser.parse(lines[i]));
            }
            return result;
        }
    }

    private static class ArrayFormatter {
        private Formatter formatter;

        ArrayFormatter(Formatter formatter) {
            this.formatter = formatter;
        }

        static ArrayFormatter of(Class type) {
            return new ArrayFormatter(formatters.get(type));
        }

        String format(Object o) {
            String result = "";
            for (Object item : (Object[])o) {
                result = result + "\n\t" + (item == null ? Accessory.NullValue : this.formatter.format(item));
            }
            return result;
        }
    }

    static class FieldQuery
    extends Accessory {
        private final Object object;

        FieldQuery(Object object) {
            this.object = object;
        }

        List<Field> asList() {
            return FieldQuery.fieldsOf(this.object.getClass());
        }

        Field get(String name) {
            for (Field field : FieldQuery.fieldsOf(this.object.getClass())) {
                if (!name.equalsIgnoreCase(field.getName())) continue;
                return field;
            }
            throw new RuntimeException(name + " attribute doesn't exist");
        }
    }

    static class Mapping {
        private Map<String, String> map = new HashMap<String, String>();

        Mapping() {
        }

        public void put(String from, String to) {
            this.map.put(from.toLowerCase(), to);
        }

        public String get(String text) {
            return this.map.containsKey(text.toLowerCase()) ? this.map.get(text.toLowerCase()) : text;
        }
    }

    public static interface Formatter {
        public String format(Object var1);
    }

    public static interface Parser {
        public Object parse(String var1);
    }
}

