/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.inl;

import io.intino.ness.inl.Accessory;
import io.intino.ness.inl.Message;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class Deserializer {
    private final BufferedReader reader;
    private Accessory.Mapping mapping = new Accessory.Mapping();
    private String line;

    public static Deserializer deserialize(InputStream is) {
        return new Deserializer(is);
    }

    public static Deserializer deserialize(String text) {
        return Deserializer.deserialize(new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8)));
    }

    private Deserializer(InputStream is) {
        this.reader = new BufferedReader(new InputStreamReader(is));
        this.nextLine();
    }

    public <T> T next(Class<T> type) {
        if (!this.startBlockOf(type)) {
            return null;
        }
        return (T)this.fill(this.create(type));
    }

    private boolean startBlockOf(Class type) {
        return this.line != null && this.map(Accessory.unwrap(this.line)).equalsIgnoreCase(type.getSimpleName());
    }

    private String map(String id) {
        return this.mapping.get(id);
    }

    private <T> T fill(T object) {
        Object scope = object;
        Message.Attribute attribute = new Message.Attribute();
        this.nextLine();
        while (!this.isTerminated(object)) {
            if (Accessory.isMultilineIn(this.line)) {
                this.setAttribute(scope, attribute.add(this.line.substring(1)));
            } else if (Accessory.isMessageIn(this.line)) {
                scope = this.addComponent(object, this.line.substring(1, this.line.length() - 1));
            } else if (Accessory.isAttributeIn(this.line)) {
                this.setAttribute(scope, attribute.parse(this.line));
            }
            this.nextLine();
        }
        return object;
    }

    private boolean isTerminated(Object object) {
        return this.line == null || this.startBlockOf(object.getClass());
    }

    private Object addComponent(Object scope, String path) {
        String[] paths = path.split("\\.");
        for (int i = 1; i < paths.length - 1; ++i) {
            if ((scope = this.findScope(scope, paths[i])) != null) continue;
            return null;
        }
        return this.createComponent(paths[paths.length - 1], scope);
    }

    private void setAttribute(Object object, Message.Attribute attribute) {
        if (object == null || attribute.value == null) {
            return;
        }
        Field field = Accessory.fieldsOf(object).get(this.map(attribute.name));
        this.setField(field, object, this.parserOf(field).parse(attribute.value));
    }

    private Object findScope(Object object, String attribute) {
        for (Field field : Accessory.fieldsOf(object).asList()) {
            if (!this.match(field, attribute)) continue;
            Object result = this.valueOf(field, object);
            return result instanceof List ? this.lastItemOf((List)result) : result;
        }
        return null;
    }

    private boolean match(Field field, String attribute) {
        return attribute.equalsIgnoreCase(field.getName()) || attribute.equalsIgnoreCase(this.classOf(field).getSimpleName());
    }

    private Object valueOf(Field field, Object object) {
        try {
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private Object lastItemOf(List list) {
        return list.get(list.size() - 1);
    }

    private Class classOf(Field field) {
        if (!(field.getGenericType() instanceof ParameterizedType)) {
            return field.getType();
        }
        ParameterizedType ptype = (ParameterizedType)field.getGenericType();
        return (Class)ptype.getActualTypeArguments()[0];
    }

    private Object createComponent(String type, Object object) {
        return this.createComponent(this.findField(type, object), object);
    }

    private Object createComponent(Field field, Object object) {
        if (field == null) {
            return null;
        }
        if (this.isList(field)) {
            return this.createListItem(field, object);
        }
        return this.setField(field, object, this.create(this.classOf(field)));
    }

    private Object createListItem(Field field, Object object) {
        ArrayList<Object> list = (ArrayList<Object>)this.valueOf(field, object);
        if (list == null) {
            list = new ArrayList<Object>();
            this.setField(field, object, list);
        }
        Object item = this.create(this.classOf(field));
        list.add(item);
        return item;
    }

    private boolean isList(Field field) {
        return field.getType().isAssignableFrom(List.class);
    }

    private Object setField(Field field, Object object, Object value) {
        if (field == null) {
            return null;
        }
        try {
            field.setAccessible(true);
            field.set(object, value);
            return value;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private Field findField(String type, Object object) {
        for (Field field : Accessory.fieldsOf(object).asList()) {
            if (!this.match(field, type) || !this.isList(field) && this.valueOf(field, object) != null) continue;
            return field;
        }
        return null;
    }

    private Object create(Class<?> type) {
        try {
            return type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    private void nextLine() {
        try {
            do {
                this.line = Accessory.normalize(this.reader.readLine());
            } while (this.line != null && this.line.isEmpty());
        }
        catch (IOException e) {
            this.line = null;
        }
    }

    private Accessory.Parser parserOf(Field field) {
        return Accessory.parsers.get(field.getType());
    }

    public Deserializer map(String from, String to) {
        this.mapping.put(from, to);
        return this;
    }
}

