/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.ingestion;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.triplestore.TripleStore;
import io.intino.ness.ingestion.Fingerprint;
import io.intino.ness.ingestion.Session;
import io.intino.ness.ingestion.SessionHandler;
import io.intino.ness.ingestion.SetSessionWriter;
import java.util.Arrays;
import java.util.stream.Stream;

public class SetSession {
    private final SetSessionWriter writer;
    private final TripleStore.Builder tripleStore;
    private final int maxSize;
    private int count = 0;

    public SetSession(SessionHandler.Provider provider, SetSessionWriter writer) {
        this(provider, writer, 1000000);
    }

    public SetSession(SessionHandler.Provider provider, SetSessionWriter writer, int autoFlushSize) {
        this.writer = writer;
        this.tripleStore = new TripleStore.Builder(provider.outputStream(Session.Type.setMetadata));
        this.maxSize = autoFlushSize;
    }

    public void put(String tank, Timetag timetag, String set, Stream<Long> ids) {
        ids.forEach(i -> this.writer.add(tank, timetag, set, (long)i));
        if (this.count++ >= this.maxSize) {
            this.doFlush();
        }
    }

    public void put(String tank, Timetag timetag, String set, long ... ids) {
        this.put(tank, timetag, set, Arrays.stream(ids).boxed());
    }

    public void define(String tank, Timetag timetag, String set, String variable, String value) {
        this.tripleStore.put(Fingerprint.of(tank, timetag, set).toString(), variable, (Object)value);
    }

    public void flush() {
        this.writer.flush();
        this.count = 0;
    }

    public void close() {
        this.writer.close();
        this.tripleStore.close();
    }

    private void doFlush() {
        this.flush();
    }
}

