/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.ingestion;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.mapp.MappBuilder;
import io.intino.alexandria.mapp.MappStream;
import io.intino.alexandria.zet.ZFile;
import io.intino.alexandria.zet.ZetReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SetIndexer {
    private final File tank;

    public SetIndexer(File tank) {
        this.tank = tank;
    }

    public void make() {
        Arrays.stream((Object[])Objects.requireNonNull(this.tank.listFiles(File::isDirectory))).forEach(this::processTubs);
    }

    public void processTubs(File tank) {
        ((Stream)Arrays.stream((Object[])Objects.requireNonNull(tank.listFiles(File::isDirectory))).filter(tub -> !new File((File)tub, ".mapp").exists()).parallel()).forEach(this::makeIndex);
    }

    private void makeIndex(File timetag) {
        File destinationFile = new File(timetag, ".mapp");
        List<Zet> zets = this.streamOf(timetag);
        MappBuilder builder = new MappBuilder(zets.stream().map(z -> z.name).collect(Collectors.toList()));
        builder.put(MappStream.Merge.of(zets.stream().map(this::mappStream).collect(Collectors.toList())));
        try {
            builder.save(destinationFile);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private List<Zet> streamOf(File directory) {
        return this.zetInfos(directory).stream().sorted(Comparator.comparing(s -> s.size)).collect(Collectors.toList());
    }

    private List<Zet> zetInfos(File directory) {
        return Arrays.stream((Object[])Objects.requireNonNull(directory.listFiles(f -> f.getName().endsWith(".zet")))).map(Zet::new).collect(Collectors.toList());
    }

    private MappStream mappStream(final Zet zet) {
        return new MappStream(){
            ZetReader reader;
            {
                this.reader = new ZetReader(zet.inputStream());
            }

            public MappStream.Item next() {
                final long key = this.reader.next();
                return new MappStream.Item(){

                    public long key() {
                        return key;
                    }

                    public String value() {
                        return zet.name;
                    }
                };
            }

            public boolean hasNext() {
                return this.reader.hasNext();
            }

            public void close() {
            }
        };
    }

    private static class Zet {
        final int size;
        final String name;
        InputStream inputStream;

        public Zet(File file) {
            this.name = this.nameOf(file);
            this.size = this.sizeOf(file);
            try {
                this.inputStream = new ByteArrayInputStream(Files.readAllBytes(file.toPath()));
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
            }
        }

        InputStream inputStream() {
            return this.inputStream;
        }

        private int sizeOf(File file) {
            try {
                return (int)new ZFile(file).size();
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
                return 0;
            }
        }

        private String nameOf(File file) {
            return file.getName().substring(0, file.getName().lastIndexOf(46));
        }
    }
}

