/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.ingestion;

import io.intino.alexandria.logger.Logger;
import io.intino.ness.ingestion.FS;
import io.intino.ness.ingestion.Session;
import io.intino.ness.ingestion.Stage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.time.Instant;
import java.util.Arrays;
import java.util.stream.Stream;

class FileStage
implements Stage {
    private final File stageFolder;
    private final File sessionsFolder;

    FileStage(File stageFolder, File sessionsFolder) {
        this.stageFolder = stageFolder;
        this.sessionsFolder = sessionsFolder;
        this.stageFolder.mkdirs();
        this.sessionsFolder.mkdirs();
    }

    @Override
    public void push(Stream<Session> sessions) {
        sessions.forEach(s -> this.push((Session)s, this.stageFolder));
    }

    @Override
    public void clear() {
        File treatedFolder = new File(this.sessionsFolder, this.sealDateFolderName());
        treatedFolder.mkdirs();
        FS.filesIn(this.stageFolder, File::isFile).forEach(f -> this.move((File)f, treatedFolder));
    }

    private void push(Session session, File stageFolder) {
        FS.copyInto(this.fileFor(session, stageFolder), session.inputStream());
    }

    private File fileFor(Session session, File stageFolder) {
        return new File(stageFolder, this.filename(session));
    }

    private String filename(Session session) {
        return session.name() + "." + (Object)((Object)session.type()) + ".session";
    }

    private void move(File stageFile, File treatedFolder) {
        try {
            Files.move(stageFile.toPath(), new File(treatedFolder, stageFile.getName()).toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    @Override
    public Stream<Session> sessions() {
        return this.files().map(FileSession::new);
    }

    private String sealDateFolderName() {
        return Instant.now().toString().substring(0, 19).replaceAll("[:T\\-]", "");
    }

    private Stream<File> files() {
        return FS.allFilesIn(this.stageFolder, this::sessions);
    }

    private boolean sessions(File file) {
        return file.isDirectory() || file.getName().endsWith(".session");
    }

    private static class FileSession
    implements Session {
        private final File file;
        private final Session.Type type;

        FileSession(File file) {
            this.file = file;
            this.type = this.typeOf(file.getName());
        }

        @Override
        public String name() {
            String name = this.file.getName();
            return name.substring(0, name.lastIndexOf("."));
        }

        private Session.Type typeOf(String filename) {
            return Arrays.stream(Session.Type.values()).filter(type -> filename.endsWith(this.extensionOf((Session.Type)((Object)type)))).findFirst().orElse(null);
        }

        private String extensionOf(Session.Type type) {
            return "." + type.name() + ".session";
        }

        @Override
        public Session.Type type() {
            return this.type;
        }

        @Override
        public InputStream inputStream() {
            return new BufferedInputStream(this.inputStreamOfFile());
        }

        private InputStream inputStreamOfFile() {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                Logger.error((Throwable)e);
                return new ByteArrayInputStream(new byte[0]);
            }
        }
    }
}

