/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.ingestion;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.zim.ZimBuilder;
import io.intino.alexandria.zim.ZimReader;
import io.intino.alexandria.zim.ZimStream;
import io.intino.ness.ingestion.EventSorter;
import io.intino.ness.ingestion.FS;
import io.intino.ness.ingestion.Fingerprint;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EventSessionManager {
    public static void seal(File stageFolder, File eventStoreFolder, File tempFolder) {
        ((Stream)EventSessionManager.eventSessions(stageFolder).collect(Collectors.groupingBy(EventSessionManager::fingerprintOf)).entrySet().stream().sorted(Comparator.comparing(t -> ((Fingerprint)t.getKey()).toString())).parallel()).forEach(e -> new Sealer(eventStoreFolder, tempFolder).seal((Fingerprint)e.getKey(), (List<File>)((List)e.getValue())));
    }

    private static Stream<File> eventSessions(File eventStageFolder) {
        return FS.filesIn(eventStageFolder, f -> f.getName().endsWith(".event.session") && (float)f.length() > 0.0f);
    }

    private static ZimReader reader(File zimFile) {
        return new ZimReader(zimFile);
    }

    private static Fingerprint fingerprintOf(File file) {
        return new Fingerprint(EventSessionManager.cleanedNameOf(file));
    }

    private static String cleanedNameOf(File file) {
        return file.getName().substring(0, file.getName().indexOf("#")).replace("-", "/").replace(".event.session", "");
    }

    private static class Sealer {
        private final File eventStoreFolder;
        private final File tempFolder;

        Sealer(File eventStoreFolder, File tempFolder) {
            this.eventStoreFolder = eventStoreFolder;
            this.tempFolder = tempFolder;
        }

        public void seal(Fingerprint fingerprint, List<File> files) {
            this.seal(this.datalakeFile(fingerprint), this.sort(files));
        }

        private void seal(File datalakeFile, List<File> files) {
            new ZimBuilder(datalakeFile).put((ZimStream)this.zimStreamOf(files));
        }

        private List<File> sort(List<File> files) {
            try {
                for (File file : files) {
                    new EventSorter(file, this.tempFolder).sort();
                }
                return files;
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
                return Collections.emptyList();
            }
        }

        private ZimStream.Merge zimStreamOf(List<File> files) {
            return ZimStream.Merge.of((ZimStream[])((ZimStream[])files.stream().map(x$0 -> EventSessionManager.reader(x$0)).toArray(ZimStream[]::new)));
        }

        private File datalakeFile(Fingerprint fingerprint) {
            File zimFile = new File(this.eventStoreFolder, fingerprint.toString() + ".zim");
            zimFile.getParentFile().mkdirs();
            return zimFile;
        }
    }
}

