/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.ingestion;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.inl.Message;
import io.intino.alexandria.inl.MessageWriter;
import io.intino.alexandria.logger.Logger;
import io.intino.ness.ingestion.Fingerprint;
import io.intino.ness.ingestion.Session;
import io.intino.ness.ingestion.SessionHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;

public class EventSession {
    private final Map<Fingerprint, MessageWriter> writers = new HashMap<Fingerprint, MessageWriter>();
    private SessionHandler.Provider provider;

    public EventSession(SessionHandler.Provider provider) {
        this.provider = provider;
    }

    public void put(String tank, Timetag timetag, Message ... messages) {
        this.put(tank, timetag, Arrays.stream(messages));
    }

    public void put(String tank, Timetag timetag, Stream<Message> messages) {
        this.put(this.writerOf(tank, timetag), messages);
    }

    public void flush() {
        try {
            for (MessageWriter w : this.writers.values()) {
                w.flush();
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    public void close() {
        try {
            for (MessageWriter w : this.writers.values()) {
                w.close();
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void put(MessageWriter writer, Stream<Message> messages) {
        messages.forEach(m -> this.write(writer, (Message)m));
    }

    private void write(MessageWriter writer, Message message) {
        try {
            writer.write(message);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private MessageWriter writerOf(String tank, Timetag timetag) {
        return this.writerOf(Fingerprint.of(tank, timetag));
    }

    private MessageWriter writerOf(Fingerprint fingerprint) {
        if (!this.writers.containsKey(fingerprint)) {
            this.writers.put(fingerprint, this.createWriter(fingerprint));
        }
        return this.writers.get(fingerprint);
    }

    private MessageWriter createWriter(Fingerprint fingerprint) {
        return new MessageWriter((OutputStream)this.zipStream(this.provider.outputStream(fingerprint.name(), Session.Type.event)));
    }

    private GZIPOutputStream zipStream(OutputStream outputStream) {
        try {
            return new GZIPOutputStream(outputStream);
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }
}

