/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.datamarts;

import io.intino.Configuration;
import io.intino.datahub.model.Datamart;
import io.intino.datahub.model.Entity;
import io.intino.datahub.model.NessGraph;
import io.intino.datahub.model.Reel;
import io.intino.datahub.model.Struct;
import io.intino.datahub.model.Terminal;
import io.intino.datahub.model.Timeline;
import io.intino.datahub.model.rules.SnapshotScale;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;
import io.intino.magritte.framework.Layer;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.datamarts.AttributesTemplate;
import io.intino.ness.datahubterminalplugin.datamarts.ConceptAttribute;
import io.intino.ness.datahubterminalplugin.datamarts.ConceptRenderer;
import io.intino.ness.datahubterminalplugin.datamarts.DatamartImplTemplate;
import io.intino.ness.datahubterminalplugin.datamarts.DatamartTemplate;
import io.intino.ness.datahubterminalplugin.datamarts.DictionaryImplTemplate;
import io.intino.ness.datahubterminalplugin.datamarts.EntityFrameFactory;
import io.intino.ness.datahubterminalplugin.datamarts.EntityImplTemplate;
import io.intino.ness.datahubterminalplugin.datamarts.EntityMounterFrameFactory;
import io.intino.ness.datahubterminalplugin.datamarts.EntityMounterTemplate;
import io.intino.ness.datahubterminalplugin.datamarts.EntityTemplate;
import io.intino.ness.datahubterminalplugin.datamarts.StructFrameFactory;
import io.intino.ness.datahubterminalplugin.datamarts.StructImplTemplate;
import io.intino.ness.datahubterminalplugin.datamarts.StructTemplate;
import io.intino.ness.datahubterminalplugin.datamarts.TimelineUtils;
import io.intino.ness.datahubterminalplugin.datamarts.nodes.IndicatorImplTemplate;
import io.intino.ness.datahubterminalplugin.datamarts.nodes.ReelNodeImplTemplate;
import io.intino.ness.datahubterminalplugin.datamarts.nodes.TimelineNodeImplTemplate;
import io.intino.ness.datahubterminalplugin.util.ErrorUtils;
import io.intino.plugin.PluginLauncher;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DatamartsRenderer
implements ConceptRenderer {
    private static final String DOT = ".";
    private static final String JAVA = ".java";
    private final File srcFolder;
    private final NessGraph model;
    private final Configuration conf;
    private final PrintStream logger;
    private final PluginLauncher.Notifier notifier;
    private String modelPackage;
    private final Templates templates;

    public DatamartsRenderer(File srcDir, NessGraph model, Configuration conf, PrintStream logger, PluginLauncher.Notifier notifier, String basePackage) {
        this.srcFolder = srcDir;
        this.model = model;
        this.conf = conf;
        this.logger = logger;
        this.notifier = notifier;
        this.srcFolder.mkdirs();
        this.modelPackage = basePackage;
        this.templates = new Templates();
    }

    public void render(Terminal terminal, String terminalPackage) {
        TerminalInfo terminalInfo = new TerminalInfo(terminal, terminalPackage);
        String basePackage = this.modelPackage + ".datamarts";
        for (Datamart datamart : terminal.datamarts().list()) {
            this.modelPackage = basePackage + DOT + datamart.name$().toLowerCase();
            this.renderDatamart(datamart, terminalInfo);
        }
    }

    private void renderDatamart(Datamart datamart, TerminalInfo terminalInfo) {
        try {
            this.write(this.renderImplementationOf(datamart, terminalInfo));
            this.write(this.entityMounterClassesOf(datamart, terminalInfo));
        }
        catch (Throwable e) {
            this.notifier.notifyError("Error during java className generation: " + ErrorUtils.getMessage(e));
            throw new RuntimeException(e);
        }
    }

    public void render() {
        String basePackage = this.modelPackage + ".datamarts";
        for (Datamart datamart : this.model.datamartList()) {
            this.modelPackage = basePackage + DOT + datamart.name$().toLowerCase();
            this.renderDatamart(datamart);
            this.renderOntologyClassesOf(datamart);
        }
    }

    private void renderDatamart(Datamart datamart) {
        try {
            this.write(this.renderInterfaceOf(datamart));
        }
        catch (Throwable e) {
            this.notifier.notifyError("Error during java className generation: " + ErrorUtils.getMessage(e));
            throw new RuntimeException(e);
        }
    }

    private void renderOntologyClassesOf(Datamart datamart) {
        try {
            this.logger.println("Rendering entities and structs of " + datamart.name$() + "...");
            this.write(this.structClassesOf(datamart));
            this.write(this.entityClassesOf(datamart));
        }
        catch (Exception e) {
            this.notifier.notifyError("Error during java className generation: " + ErrorUtils.getMessage(e));
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> entityMounterClassesOf(Datamart datamart, TerminalInfo terminalInfo) {
        HashMap<String, String> outputs = new HashMap<String, String>();
        outputs.put(this.destination(this.baseEntityMounterName(datamart, terminalInfo)), this.templates.entityMounter.render((Object)this.entityMounterInterface(datamart, terminalInfo)));
        datamart.entityList().stream().filter(e -> e.from() != null).forEach(e -> outputs.putAll(this.renderEntityMounter((Entity)e, datamart, terminalInfo)));
        return outputs;
    }

    private String baseEntityMounterName(Datamart datamart, TerminalInfo terminalInfo) {
        return terminalInfo.terminalPackage + DOT + this.subPackageOf(datamart) + DOT + this.firstUpperCase(datamart.name$()) + "Mounter";
    }

    private FrameBuilder entityMounterInterface(Datamart datamart, TerminalInfo terminalInfo) {
        return new FrameBuilder(new String[]{"mounter", "interface"}).add("package", (Object)(terminalInfo.terminalPackage + this.subPackageOf(datamart))).add("ontologypackage", (Object)this.modelPackage).add("datamart", (Object)datamart.name$());
    }

    private String subPackageOf(Datamart datamart) {
        return ".datamarts." + Formatters.javaValidName().format((Object)datamart.name$().toLowerCase());
    }

    private Map<String, String> entityClassesOf(Datamart datamart) {
        HashMap<String, String> outputs = new HashMap<String, String>();
        this.renderEntityBase(datamart, outputs);
        datamart.entityList().forEach(e -> outputs.putAll(this.renderEntity((Entity)e, datamart)));
        return outputs;
    }

    private void renderEntityBase(Datamart datamart, Map<String, String> outputs) {
        outputs.put(this.entityDestination(this.entityBaseName(datamart)), this.templates.entity.render((Object)this.entityBaseBuilder(datamart)));
    }

    private String entityBaseName(Datamart datamart) {
        return this.modelPackage + DOT + Formatters.javaValidName().format((Object)(this.firstUpperCase(datamart.name$()) + "Entity")).toString();
    }

    private FrameBuilder entityBaseBuilder(Datamart datamart) {
        return new FrameBuilder(new String[]{"entity", "base"}).add("package", (Object)this.modelPackage).add("datamart", (Object)datamart.name$());
    }

    private Map<String, String> structClassesOf(Datamart datamart) {
        HashMap<String, String> output = new HashMap<String, String>();
        this.renderStructBase(datamart, output);
        datamart.structList().stream().map(struct -> this.renderStruct(datamart, (Struct)struct)).forEach(output::putAll);
        return output;
    }

    private void renderStructBase(Datamart datamart, Map<String, String> output) {
        output.put(this.destination(this.structBaseName(datamart)), this.templates.struct.render((Object)this.structBaseBuilder(datamart)));
    }

    private String structBaseName(Datamart datamart) {
        return this.modelPackage + DOT + Formatters.javaValidName().format((Object)(this.firstUpperCase(datamart.name$()) + "Struct")).toString();
    }

    private FrameBuilder structBaseBuilder(Datamart datamart) {
        return new FrameBuilder(new String[]{"struct", "base"}).add("package", (Object)this.modelPackage).add("datamart", (Object)datamart.name$());
    }

    private Map<String, String> renderInterfaceOf(Datamart datamart) {
        String theInterface = this.modelPackage + DOT + this.firstUpperCase(Formatters.javaValidName().format((Object)(datamart.name$() + "Datamart")).toString());
        return Map.of(this.destination(theInterface), this.templates.datamart.render((Object)this.datamartInterfaceBuilder(datamart).toFrame()));
    }

    private Map<String, String> renderImplementationOf(Datamart datamart, TerminalInfo terminalInfo) {
        String theImplementation = this.modelPackage + DOT + this.firstUpperCase(Formatters.javaValidName().format((Object)(datamart.name$() + "DatamartImpl")).toString());
        return Map.of(this.destination(theImplementation), this.templates.datamartImpl.render((Object)this.datamartImplBuilder(datamart, terminalInfo).toFrame()));
    }

    private FrameBuilder datamartInterfaceBuilder(Datamart datamart) {
        FrameBuilder builder = new FrameBuilder(new String[]{"datamart", "interface"});
        builder.add("package", (Object)this.modelPackage);
        builder.add("name", (Object)this.firstUpperCase(datamart.name$()));
        builder.add("entity", (Object)this.entitiesOf(datamart));
        if (!datamart.timelineList().isEmpty()) {
            builder.add("hasTimelines", (Object)"");
            builder.add("timeline", (Object)this.timelinesOf(datamart));
            builder.add("indicator", (Object)this.indicatorsOf(datamart));
        }
        if (!datamart.reelList().isEmpty()) {
            builder.add("hasReels", (Object)"");
            builder.add("reel", (Object)this.reelsOf(datamart));
        }
        return builder;
    }

    private Frame dictionaryImpl() {
        FrameBuilder b = new FrameBuilder(new String[]{"dictionary", "default"});
        return b.toFrame();
    }

    private Frame reelNode(Datamart datamart) {
        FrameBuilder b = new FrameBuilder(new String[]{"reelNode", "default"});
        b.add("datamart", (Object)datamart.name$());
        b.add("chronosObject", (Object)"Reel");
        return b.toFrame();
    }

    private String reelEvents(Datamart datamart) {
        return datamart.reelList().stream().map(r -> Formatters.quoted().format((Object)r.tank().message().name$()).toString()).distinct().collect(Collectors.joining(","));
    }

    private Frame[] reelsOf(Datamart datamart) {
        return (Frame[])datamart.reelList().stream().map(this::reelFrame).toArray(Frame[]::new);
    }

    private Frame reelFrame(Reel reel) {
        FrameBuilder b = new FrameBuilder(new String[]{"reel"});
        b.add("package", (Object)this.modelPackage);
        b.add("name", (Object)reel.tank().message().name$());
        b.add("sources", (Object)this.sourcesOf(reel));
        b.add("entity", (Object)this.firstUpperCase(reel.entity().name$()));
        return b.toFrame();
    }

    private String sourcesOf(Reel reel) {
        ArrayList<String> sources = new ArrayList<String>(List.of(Formatters.quoted().format((Object)reel.tank()).toString()));
        if (reel.entity() != null && reel.entity().from() != null) {
            sources.add(Formatters.quoted().format((Object)reel.entity().from().message().name$()).toString());
        }
        return String.join((CharSequence)",", sources);
    }

    private Frame timelineNode(Datamart datamart) {
        FrameBuilder b = new FrameBuilder(new String[]{"timelineNode", "default"});
        b.add("datamart", (Object)datamart.name$());
        b.add("chronosObject", (Object)"Timeline");
        return b.toFrame();
    }

    private Frame indicatorNode(Datamart datamart) {
        FrameBuilder b = new FrameBuilder(new String[]{"indicatorNode", "default"});
        b.add("datamart", (Object)datamart.name$());
        b.add("chronosObject", (Object)"Indicator");
        return b.toFrame();
    }

    private String timelineEvents(Datamart datamart) {
        return datamart.timelineList().stream().flatMap(TimelineUtils::types).distinct().map(t -> Formatters.quoted().format(t).toString()).collect(Collectors.joining(","));
    }

    private Frame[] indicatorsOf(Datamart datamart) {
        Stream cooked = datamart.timelineList().stream().filter(Timeline::isCooked).filter(Timeline::isIndicator).map(Timeline::asCooked).flatMap(this::indicatorFrames);
        Stream raw = datamart.timelineList().stream().filter(Timeline::isRaw).filter(Timeline::isIndicator).map(Timeline::asRaw).flatMap(this::indicatorFrames);
        return (Frame[])Stream.concat(cooked, raw).toArray(Frame[]::new);
    }

    private Frame[] timelinesOf(Datamart datamart) {
        ArrayList<Frame> frames = new ArrayList<Frame>();
        frames.addAll(datamart.timelineList().stream().filter(Timeline::isRaw).map(Timeline::asRaw).map(this::timelineFrame).toList());
        frames.addAll(datamart.timelineList().stream().filter(Timeline::isCooked).map(Timeline::asCooked).map(this::timelineFrame).toList());
        return frames.toArray(new Frame[0]);
    }

    private Stream<Frame> indicatorFrames(Timeline.Cooked timeline) {
        return timeline.timeSeriesList().stream().map(Layer::name$).map(ts -> new FrameBuilder(new String[]{"indicator"}).add("package", (Object)this.modelPackage).add("label", (Object)Formatters.firstLowerCase(ts)).add("name", (Object)(timeline.name$() + DOT + ts)).add("sources", (Object)TimelineUtils.types(timeline.asTimeline()).map(t -> Formatters.quoted().format(t).toString()).collect(Collectors.joining(","))).add("entity", (Object)this.firstUpperCase(timeline.entity().name$())).toFrame());
    }

    private Stream<Frame> indicatorFrames(Timeline.Raw timeline) {
        return timeline.tank().sensor().magnitudeList().stream().map(Layer::name$).map(ts -> new FrameBuilder(new String[]{"indicator"}).add("package", (Object)this.modelPackage).add("label", (Object)Formatters.firstLowerCase(ts)).add("name", (Object)(timeline.tank().asTank().asMeasurement().sensor().name$() + DOT + ts)).add("sources", (Object)TimelineUtils.types(timeline.asTimeline()).map(t -> Formatters.quoted().format(t).toString()).collect(Collectors.joining(","))).add("entity", (Object)this.firstUpperCase(timeline.entity().name$())).toFrame());
    }

    private Frame timelineFrame(Timeline.Raw timeline) {
        FrameBuilder b = new FrameBuilder(new String[]{"timeline", "raw"});
        b.add("package", (Object)this.modelPackage);
        b.add("name", (Object)timeline.tank().sensor().name$());
        b.add("sources", (Object)this.sourcesOf(timeline));
        b.add("entity", (Object)this.firstUpperCase(timeline.entity().name$()));
        return b.toFrame();
    }

    private Frame timelineFrame(Timeline.Cooked timeline) {
        FrameBuilder b = new FrameBuilder(new String[]{"timeline", "cooked"});
        b.add("package", (Object)this.modelPackage);
        b.add("name", (Object)timeline.name$());
        b.add("sources", (Object)TimelineUtils.types(timeline.asTimeline()).map(t -> Formatters.quoted().format(t).toString()).collect(Collectors.joining(",")));
        b.add("entity", (Object)this.firstUpperCase(timeline.entity().name$()));
        return b.toFrame();
    }

    private String sourcesOf(Timeline.Raw timeline) {
        String sensor = Formatters.quoted().format((Object)timeline.tank().sensor().name$()).toString();
        if (timeline.entity() != null && timeline.entity().from() != null) {
            return sensor + "," + Formatters.quoted().format((Object)timeline.entity().from().message().name$()).toString();
        }
        return sensor;
    }

    private FrameBuilder datamartImplBuilder(Datamart datamart, TerminalInfo terminalInfo) {
        FrameBuilder builder = new FrameBuilder(new String[]{"datamart", "message", "impl"});
        builder.add("package", (Object)(terminalInfo.terminalPackage + this.subPackageOf(datamart)));
        Datamart.Snapshots snapshots = datamart.snapshots();
        builder.add("name", (Object)datamart.name$()).add("scale", (Object)(snapshots == null || snapshots.scale() == null ? SnapshotScale.None.name() : snapshots.scale().name()));
        builder.add("entity", (Object)this.entitiesOf(datamart));
        builder.add("struct", (Object)this.structsOf(datamart));
        builder.add("numEntities", (Object)datamart.entityList().size());
        builder.add("numStructs", (Object)datamart.structList().size());
        builder.add("ontologypackage", (Object)this.modelPackage);
        builder.add("terminal", (Object)String.format(terminalInfo.terminalPackage + DOT + this.firstUpperCase(Formatters.javaValidName().format((Object)terminalInfo.terminal.name$()).toString()), new Object[0]));
        builder.add("lineSeparator", (Object)"\n");
        if (!datamart.timelineList().isEmpty()) {
            builder.add("hasTimelines", (Object)"");
            builder.add("timelineEvents", (Object)this.timelineEvents(datamart));
            builder.add("timeline", (Object)this.timelinesOf(datamart));
            builder.add("timelineNode", (Object)this.timelineNode(datamart));
            builder.add("indicator", (Object)this.indicatorsOf(datamart));
            builder.add("indicatorNode", (Object)this.indicatorNode(datamart));
        }
        if (!datamart.reelList().isEmpty()) {
            builder.add("hasReels", (Object)"");
            builder.add("reelEvents", (Object)this.reelEvents(datamart));
            builder.add("reel", (Object)this.reelsOf(datamart));
            builder.add("reelNode", (Object)this.reelNode(datamart));
        }
        builder.add("hasDictionary", (Object)"").add("dictionary", (Object)this.dictionaryImpl());
        return builder;
    }

    private Frame[] structsOf(Datamart datamart) {
        List structFrames = datamart.structList().stream().flatMap(struct -> this.framesOf((Struct)struct, this.modelPackage + ".structs", null)).collect(Collectors.toList());
        for (Entity entity : datamart.entityList()) {
            entity.structList().stream().flatMap(struct -> this.framesOf((Struct)struct, this.modelPackage + ".entities." + entity.name$(), entity.name$())).forEach(structFrames::add);
        }
        return (Frame[])structFrames.toArray(Frame[]::new);
    }

    private Stream<Frame> framesOf(Struct struct, String thePackage, String owner) {
        String fullname = owner == null ? this.fullNameOf(struct) : owner + "$" + this.fullNameOf(struct);
        List<ConceptAttribute> attributes = this.attributesOf(struct);
        attributes.forEach(a -> a.ownerFullName(fullname));
        FrameBuilder b = new FrameBuilder(new String[]{"struct"});
        b.add("package", (Object)thePackage);
        b.add("name", (Object)this.firstUpperCase(struct.name$()));
        b.add("fullName", (Object)fullname);
        b.add("attribute", (Object)this.attributeFrames(attributes));
        ArrayList<Frame> frames = new ArrayList<Frame>(1);
        frames.add(b.toFrame());
        for (Struct s : struct.structList()) {
            this.framesOf(s, thePackage + DOT + struct.name$(), fullname).forEach(frames::add);
        }
        return frames.stream();
    }

    private Frame[] entitiesOf(Datamart datamart) {
        return (Frame[])datamart.entityList().stream().map(entity -> {
            FrameBuilder b = new FrameBuilder(new String[]{"entity"}).add("package", (Object)this.modelPackage);
            b.add("name", (Object)this.firstUpperCase(entity.name$())).add("fullName", (Object)this.fullNameOf((Entity)entity));
            b.add("datamart", (Object)datamart.name$());
            b.add("attribute", (Object)this.attributeFrames(this.attributesOf((Entity)entity)));
            if (entity.from() != null) {
                b.add("event", (Object)this.firstUpperCase(entity.from().message().name$()));
            }
            if (entity.isExtensionOf()) {
                b.add("parent", (Object)entity.asExtensionOf().entity().name$());
                b.add("ancestor", (Object)this.ancestorsOf((Entity)entity));
            } else {
                b.add("hasNoParents", (Object)"true");
            }
            if (entity.isAbstract()) {
                b.add("abstract");
            }
            b.add("isAbstract", (Object)entity.isAbstract());
            this.setDescendantsInfo(datamart, (Entity)entity, b);
            return b.toFrame();
        }).toArray(Frame[]::new);
    }

    @Override
    public List<ConceptAttribute> attributesOf(Entity entity) {
        List<ConceptAttribute> attributes = ConceptRenderer.super.attributesOf(entity);
        entity.structList().stream().map(struct -> this.attrOf(entity.core$(), (Struct)struct)).forEach(attributes::add);
        return attributes;
    }

    @Override
    public List<ConceptAttribute> attributesOf(Struct struct) {
        List<ConceptAttribute> attributes = ConceptRenderer.super.attributesOf(struct);
        struct.structList().stream().map(s -> this.attrOf(struct.core$(), (Struct)s)).filter(a -> !attributes.contains(a)).forEach(attributes::add);
        return attributes;
    }

    private void setDescendantsInfo(Datamart datamart, Entity entity, FrameBuilder b) {
        Entity[] descendants = this.descendantsOf(entity, datamart);
        if (descendants.length == 0) {
            return;
        }
        b.add("superclass");
        b.add("descendant", Arrays.stream(descendants).map(e -> new FrameBuilder(new String[]{"descendant"}).add("entity").add("name", (Object)e.name$()).toFrame()).toArray(Frame[]::new));
        b.add("subclasstop", (Object)this.framesOfNonAbstractTopLevelDescendants(entity, datamart));
        b.add("subclass", (Object)this.framesOfNonAbstractDescendants(entity, datamart));
    }

    private Frame[] ancestorsOf(Entity entity) {
        ArrayList<Frame> ancestors = new ArrayList<Frame>();
        Entity parent = entity.asExtensionOf().entity();
        while (parent != null) {
            ancestors.add(new FrameBuilder(new String[]{"ancestor", "entity"}).add("name", (Object)parent.name$()).toFrame());
            parent = parent.isExtensionOf() ? parent.asExtensionOf().entity() : null;
        }
        return (Frame[])ancestors.toArray(Frame[]::new);
    }

    private Frame[] attributeFrames(List<ConceptAttribute> attributes) {
        return (Frame[])attributes.stream().map(this::attributeFrameBuilder).map(FrameBuilder::toFrame).toArray(Frame[]::new);
    }

    private FrameBuilder attributeFrameBuilder(ConceptAttribute attr) {
        FrameBuilder b = new FrameBuilder(new String[]{"attribute"});
        if (attr.isList() || attr.isSet()) {
            this.setAttribCollectionInfo(attr, b);
        } else if (attr.isMap()) {
            b.add("type", (Object)"java.util.Map").add("collection").add("parameterTypeName", (Object)"java.lang.String").add("parameterType", (Object)"java.lang.String");
            b.add("parameter", (Object)new FrameBuilder(new String[]{"parameter"}));
        } else if (attr.isEntity()) {
            b.add("type", (Object)(this.modelPackage + ".entities." + attr.asEntity().entity().name$()));
        } else if (attr.isStruct()) {
            b.add("type", (Object)(this.modelPackage + ".entities." + attr.ownerFullName().replace("$", DOT) + DOT + attr.asStruct().name$()));
        } else if (attr.isWord()) {
            b.add("type", (Object)(this.modelPackage + ".entities." + attr.ownerFullName().replace("$", DOT) + DOT + attr.type()));
        } else {
            b.add("type", (Object)attr.type());
        }
        b.add("name", (Object)attr.name$());
        if (attr.inherited()) {
            b.add("inherited");
        }
        return b;
    }

    private void setAttribCollectionInfo(ConceptAttribute attr, FrameBuilder b) {
        b.add("type", (Object)(attr.isList() ? "java.util.List" : "java.util.Set"));
        b.add("collection");
        Object parameterType = attr.type();
        String parameterTypeName = parameterType;
        if (attr.isEntity()) {
            parameterType = this.modelPackage + ".entities." + this.firstUpperCase(attr.asEntity().entity().name$());
            parameterTypeName = this.firstUpperCase(attr.asEntity().entity().name$());
        } else if (attr.isStruct()) {
            parameterType = this.modelPackage + ".entities." + attr.ownerFullName() + DOT + this.firstUpperCase(attr.asStruct().name$());
            parameterTypeName = this.firstUpperCase(attr.asStruct().name$());
        } else if (attr.isWord()) {
            parameterType = this.modelPackage + ".entities." + this.firstUpperCase(attr.owner().name()) + DOT + (String)parameterType;
        }
        b.add("parameterType", (Object)((String)parameterType).replace("$", DOT));
        b.add("parameterTypeName", (Object)parameterTypeName);
        FrameBuilder param = new FrameBuilder(new String[]{"parameter"});
        if (attr.isEntity()) {
            param.add("entity");
        } else if (attr.isStruct()) {
            param.add("struct");
        } else if (attr.isWord()) {
            param.add("word");
        }
        if (attr.isStruct()) {
            param.add("name", (Object)(attr.ownerFullName() + "$" + this.firstUpperCase(attr.asStruct().name$())));
        } else {
            param.add("name", (Object)parameterTypeName);
        }
        b.add("parameter", (Object)param);
    }

    private String firstUpperCase(String name) {
        return Formatters.firstUpperCase(name);
    }

    private String fullNameOf(Entity e) {
        if (!e.isExtensionOf()) {
            return this.firstUpperCase(e.name$());
        }
        ArrayList<String> names = new ArrayList<String>(4);
        Entity parent = e.asExtensionOf().entity();
        while (parent != null) {
            names.add(this.firstUpperCase(parent.name$()));
            parent = parent.isExtensionOf() ? parent.asExtensionOf().entity() : null;
        }
        Collections.reverse(names);
        names.add(this.firstUpperCase(e.name$()));
        return String.join((CharSequence)DOT, names);
    }

    private String fullNameOf(Struct s) {
        return this.firstUpperCase(s.name$());
    }

    private Frame[] framesOfNonAbstractTopLevelDescendants(Entity parent, Datamart datamart) {
        return (Frame[])Arrays.stream(this.upperLevelDescendantsOf(parent, datamart)).map(c -> new FrameBuilder(new String[]{"subclasstop"}).add("package", (Object)(this.modelPackage + ".entities")).add("name", (Object)c.name$()).toFrame()).toArray(Frame[]::new);
    }

    private Frame[] framesOfNonAbstractDescendants(Entity parent, Datamart datamart) {
        return (Frame[])Arrays.stream(this.nonAbstractDescendants(parent, datamart)).map(c -> new FrameBuilder(new String[]{"subclass"}).add("package", (Object)(this.modelPackage + ".entities")).add("name", (Object)c.name$()).toFrame()).toArray(Frame[]::new);
    }

    private Entity[] descendantsOf(Entity parent, Datamart datamart) {
        return (Entity[])datamart.entityList(e -> DatamartsRenderer.isDescendantOf(e, parent)).toArray(Entity[]::new);
    }

    private Entity[] nonAbstractDescendants(Entity parent, Datamart datamart) {
        return (Entity[])datamart.entityList(e -> !e.isAbstract() && DatamartsRenderer.isDescendantOf(e, parent)).toArray(Entity[]::new);
    }

    private Entity[] upperLevelDescendantsOf(Entity parent, Datamart datamart) {
        ArrayList<Entity> upperLevelDescendants = new ArrayList<Entity>();
        for (Entity entity : datamart.entityList(e -> DatamartsRenderer.isDescendantOf(e, parent) && !e.isAbstract())) {
            if (this.anAncestorOfThisEntityIsAlreadyPresent(entity, upperLevelDescendants)) continue;
            this.removeAnyDescendantOfThisEntityIfPresent(entity, upperLevelDescendants);
            upperLevelDescendants.add(entity);
        }
        return upperLevelDescendants.toArray(new Entity[0]);
    }

    private boolean anAncestorOfThisEntityIsAlreadyPresent(Entity entity, List<Entity> upperLevelDescendants) {
        return upperLevelDescendants.stream().anyMatch(ancestor -> DatamartsRenderer.isDescendantOf(entity, ancestor));
    }

    private void removeAnyDescendantOfThisEntityIfPresent(Entity ancestor, List<Entity> upperLevelDescendants) {
        upperLevelDescendants.removeIf(e -> DatamartsRenderer.isDescendantOf(e, ancestor));
    }

    private static boolean isDescendantOf(Entity node, Entity expectedParent) {
        if (!node.isExtensionOf()) {
            return false;
        }
        Entity parent = node.asExtensionOf().entity();
        return parent.equals(expectedParent) || DatamartsRenderer.isDescendantOf(parent, expectedParent);
    }

    private Map<String, String> renderEntity(Entity entity, Datamart datamart) {
        return new EntityFrameFactory(this.modelPackage, datamart).create(entity).entrySet().stream().collect(Collectors.toMap(e -> this.entityDestination((String)e.getKey()), e -> this.templates.entityImpl.render(e.getValue())));
    }

    private Map<String, String> renderStruct(Datamart datamart, Struct struct) {
        return new StructFrameFactory(datamart, this.modelPackage).create(struct).entrySet().stream().collect(Collectors.toMap(e -> this.destination((String)e.getKey()), e -> this.templates.structImpl.render(e.getValue())));
    }

    private Map<String, String> renderEntityMounter(Entity entity, Datamart datamart, TerminalInfo terminalInfo) {
        return new EntityMounterFrameFactory(terminalInfo.terminalPackage + this.subPackageOf(datamart), this.modelPackage, datamart).create(entity).entrySet().stream().collect(Collectors.toMap(e -> this.entityDestination((String)e.getKey()), e -> this.templates.entityMounter.render(e.getValue())));
    }

    private void write(Map<String, String> outputsMap) {
        outputsMap.forEach((key, value) -> {
            File file = new File((String)key);
            if (value.isEmpty() || this.isUnderSource(file) && file.exists()) {
                return;
            }
            file.getParentFile().mkdirs();
            this.write(file, (String)value);
        });
    }

    private boolean isUnderSource(File file) {
        return file.getAbsolutePath().startsWith(this.srcFolder.getAbsolutePath());
    }

    private void write(File file, String text) {
        try {
            file.getParentFile().mkdirs();
            BufferedWriter fileWriter = new BufferedWriter(new FileWriter(file));
            fileWriter.write(text);
            fileWriter.close();
        }
        catch (IOException e) {
            this.notifier.notifyError(e.getMessage());
        }
    }

    private String destination(String path) {
        return new File(this.srcFolder, path.replace(DOT, File.separator) + JAVA).getAbsolutePath();
    }

    private String entityDestination(String path) {
        return new File(this.srcFolder, path.replace(DOT, File.separator) + JAVA).getAbsolutePath();
    }

    @Override
    public Datamart datamart() {
        return null;
    }

    @Override
    public String workingPackage() {
        return null;
    }

    private static class Templates {
        final Template datamart = Templates.append(Formatters.customize(new DatamartTemplate()), new Template[0]);
        final Template datamartImpl = Templates.append(Formatters.customize(new DatamartImplTemplate()), Formatters.customize(new IndicatorImplTemplate()), Formatters.customize(new ReelNodeImplTemplate()), Formatters.customize(new TimelineNodeImplTemplate()), Formatters.customize(new DictionaryImplTemplate()));
        final Template entity = Formatters.customize(new EntityTemplate());
        final Template entityImpl = Templates.append(Formatters.customize(new EntityImplTemplate()), Formatters.customize(new StructImplTemplate()), Formatters.customize(new AttributesTemplate()));
        final Template entityMounter = Formatters.customize(new EntityMounterTemplate());
        final Template structImpl = Formatters.customize(new StructImplTemplate());
        final Template struct = Templates.append(Formatters.customize(new StructTemplate()), Formatters.customize(new AttributesTemplate()));

        private Templates() {
        }

        private static Template append(Template t1, Template ... others) {
            final RuleSet rules = new RuleSet();
            Templates.addRulesOf(t1, rules);
            for (Template t : others) {
                Templates.addRulesOf(t, rules);
            }
            return new Template(){

                protected RuleSet ruleSet() {
                    return rules;
                }
            };
        }

        private static void addRulesOf(Template t, RuleSet rules) {
            try {
                Method method = t.getClass().getDeclaredMethod("ruleSet", new Class[0]);
                method.setAccessible(true);
                RuleSet ruleSet = (RuleSet)method.invoke((Object)t, new Object[0]);
                ruleSet.forEach(xva$0 -> rules.add(new Rule[]{xva$0}));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public record TerminalInfo(Terminal terminal, String terminalPackage) {
    }
}

