/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin;

import io.intino.ness.datahubterminalplugin.IntinoException;

public class Version
implements Comparable<Version> {
    private static final String SNAPSHOT = "-SNAPSHOT";
    private String version;

    public Version(String version) throws IntinoException {
        if (version == null) {
            throw new IntinoException("Version can not be null");
        }
        if (!version.matches("[0-9]+(\\.[0-9]+)*(-SNAPSHOT)?")) {
            throw new IntinoException("Invalid version format: " + version);
        }
        this.version = version;
    }

    public final String get() {
        return this.version;
    }

    public Level distanceTo(Version that) {
        String[] thatParts;
        String[] thisParts = this.get().split("\\.");
        if (!thisParts[0].equals((thatParts = that.get().split("\\."))[0])) {
            return Level.Mayor;
        }
        if (!thisParts[1].equals(thatParts[1])) {
            return Level.Medium;
        }
        return Level.Minor;
    }

    public String toString() {
        return this.version;
    }

    public boolean isSnapshot() {
        return this.version.endsWith(SNAPSHOT);
    }

    public Version nextSnapshot() throws IntinoException {
        String v = this.version.replace(SNAPSHOT, "");
        CharSequence[] split = v.split("\\.");
        split[split.length - 1] = String.valueOf(Integer.parseInt(split[split.length - 1]) + 1);
        return new Version(String.join((CharSequence)".", split) + SNAPSHOT);
    }

    public Version nextRelease(Level level) throws IntinoException {
        String v = this.version.replace(SNAPSHOT, "");
        CharSequence[] split = v.split("\\.");
        split[split.length - 1 - level.ordinal()] = String.valueOf(Integer.parseInt(split[split.length - 1 - level.ordinal()]) + 1);
        return new Version(String.join((CharSequence)".", split));
    }

    public Version next() throws IntinoException {
        CharSequence[] split = this.version.split("\\.");
        split[split.length - 1] = String.valueOf(Integer.parseInt(split[split.length - 1]) + 1);
        return new Version(String.join((CharSequence)".", split));
    }

    @Override
    public int compareTo(Version that) {
        if (that == null) {
            return 1;
        }
        String[] thisParts = this.get().split("\\.");
        String[] thatParts = that.get().split("\\.");
        int length = Math.max(thisParts.length, thatParts.length);
        for (int i = 0; i < length; ++i) {
            int thatPart;
            int thisPart = i < thisParts.length ? Integer.parseInt(thisParts[i]) : 0;
            int n = thatPart = i < thatParts.length ? Integer.parseInt(thatParts[i]) : 0;
            if (thisPart < thatPart) {
                return -1;
            }
            if (thisPart <= thatPart) continue;
            return 1;
        }
        return 0;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        return this.compareTo((Version)that) == 0;
    }

    public static enum Level {
        Minor,
        Medium,
        Mayor;

    }
}

