/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin;

import io.intino.Configuration;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.model.NessGraph;
import io.intino.datahub.model.Terminal;
import io.intino.ness.datahubterminalplugin.ArtifactoryConnector;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.IntinoException;
import io.intino.ness.datahubterminalplugin.Safe;
import io.intino.ness.datahubterminalplugin.Version;
import io.intino.ness.datahubterminalplugin.ontology.OntologyPublisher;
import io.intino.ness.datahubterminalplugin.terminal.TerminalPublisher;
import io.intino.plugin.PluginLauncher;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;

public class DataHubTerminalsPluginLauncher
extends PluginLauncher {
    private static final String MINIMUM_CHRONOS_VERSION = "2.0.0";
    private static final String MAX_CHRONOS_VERSION = "3.0.0";
    private static final String MINIMUM_BPM_VERSION = "3.1.1";
    private static final String MAX_BPM_VERSION = "4.0.0";
    private static final String MINIMUM_TERMINAL_JMS_VERSION = "6.0.0";
    private static final String MAX_TERMINAL_JMS_VERSION = "7.0.0";
    private static final String MINIMUM_INGESTION_VERSION = "5.0.2";
    private static final String MAX_INGESTION_VERSION = "6.0.0";
    private static final String MINIMUM_MASTER_VERSION = "2.1.1";
    private static final String MAX_MASTER_VERSION = "3.0.0";
    private static final String MINIMUM_DATALAKE_VERSION = "7.0.2";
    private static final String MAX_DATALAKE_VERSION = "8.0.0";
    private static final String MINIMUM_EVENT_VERSION = "5.0.2";
    private static final String MAX_EVENT_VERSION = "6.0.0";
    private boolean deleteTempDirOnPublish = true;
    private boolean publishTerminalsIfOntologyFails = false;

    public void run() {
        if (this.invokedPhase.ordinal() < 2) {
            return;
        }
        this.logger().println("Building " + this.configuration().artifact().name() + " terminals...");
        File tempDir = this.tempDirectory();
        this.run(tempDir);
    }

    public void run(File tempDir) {
        File outDirectory;
        if (this.logger() != null) {
            this.logger().println("Maven HOME: " + this.systemProperties.mavenHome.getAbsolutePath());
        }
        if (!(outDirectory = this.moduleStructure().outDirectory).exists()) {
            this.notifier().notifyError("Compiled model not found. Please compile module");
            return;
        }
        NessGraph graph = this.loadGraph(outDirectory);
        if (this.hasErrors(graph)) {
            return;
        }
        Map<String, String> versions = this.versions();
        if (!this.publishOntology(graph, versions, tempDir) && !this.publishTerminalsIfOntologyFails) {
            return;
        }
        this.publishTerminals(graph, versions, tempDir);
        this.logger().println("Finished generation of terminals!");
    }

    private Map<String, String> versions() {
        return Map.of("terminal-jms", this.terminalJmsVersion(), "ingestion", this.ingestionVersion(), "bpm", this.bpmVersion(), "master", this.masterVersion(), "event", this.eventVersion(), "datalake", this.datalakeVersion(), "chronos", this.chronosVersion());
    }

    private boolean publishOntology(NessGraph graph, Map<String, String> versions, File tempDir) {
        try {
            AtomicBoolean published = new AtomicBoolean(true);
            published.set(new OntologyPublisher(new File(tempDir, "ontology"), graph, this.configuration(), this.moduleStructure(), versions, this.systemProperties(), this.invokedPhase, this.logger(), this.notifier()).publish() & published.get());
            if (published.get() && this.notifier() != null) {
                this.notifier().notify("Ontology " + this.participle() + ". Copy maven dependency:\n" + this.accessorDependency(this.configuration().artifact().groupId() + "." + Formatters.snakeCaseToCamelCase().format((Object)this.configuration().artifact().name()).toString().toLowerCase(), "ontology", this.configuration().artifact().version()));
            }
            this.handleTempDir(tempDir, published);
            return published.get();
        }
        catch (Throwable e) {
            this.logger().println(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private void publishTerminals(NessGraph nessGraph, Map<String, String> versions, File tempDir) {
        try {
            AtomicBoolean published = new AtomicBoolean(true);
            ExecutorService threadPool = Executors.newFixedThreadPool(Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
            threadPool.invokeAll(nessGraph.terminalList().stream().map(terminal -> () -> this.publishTerminal(versions, tempDir, published, (Terminal)terminal)).toList());
            threadPool.shutdownNow();
            this.handleTempDir(tempDir, published);
        }
        catch (Throwable e) {
            this.logger().println(e.getMessage());
            e.printStackTrace();
        }
    }

    private Void publishTerminal(Map<String, String> versions, File tempDir, AtomicBoolean published, Terminal terminal) {
        published.set(new TerminalPublisher(new File(tempDir, terminal.name$()), terminal, this.configuration(), versions, this.systemProperties(), this.invokedPhase, this.logger(), this.notifier()).publish() & published.get());
        if (published.get() && this.notifier() != null) {
            this.notifier().notify("Terminal " + terminal.name$() + " " + this.participle() + ". Copy maven dependency:\n" + this.accessorDependency(this.configuration().artifact().groupId() + "." + Formatters.snakeCaseToCamelCase().format((Object)this.configuration().artifact().name()).toString().toLowerCase(), this.terminalNameArtifact(terminal), this.configuration().artifact().version()));
        }
        return null;
    }

    private void handleTempDir(File tempDir, AtomicBoolean published) throws IOException {
        if (published.get() && this.deleteTempDirOnPublish) {
            FileUtils.deleteDirectory((File)tempDir);
        }
    }

    private NessGraph loadGraph(File outDirectory) {
        NessGraph nessGraph;
        URLClassLoader urlClassLoader = new URLClassLoader(this.urlOf(outDirectory), ((Object)((Object)this)).getClass().getClassLoader());
        try {
            Configuration.Artifact.Code code = this.configuration().artifact().code();
            Class<?> aClass = urlClassLoader.loadClass(code.generationPackage() + "." + code.modelPackage() + ".GraphLoader");
            NessGraph graph = (NessGraph)aClass.getMethod("load", new Class[0]).invoke(null, new Object[0]);
            if (graph.messageList(t -> t.name$().equals("Session")).findAny().isEmpty()) {
                graph.create("Session", "Session").message();
            }
            nessGraph = graph;
        }
        catch (Throwable throwable) {
            try {
                try {
                    urlClassLoader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                Logger.error((Throwable)e);
                return null;
            }
        }
        urlClassLoader.close();
        return nessGraph;
    }

    private URL[] urlOf(File outDirectory) {
        try {
            return new URL[]{outDirectory.toPath().toUri().toURL()};
        }
        catch (MalformedURLException e) {
            Logger.error((Throwable)e);
            return new URL[0];
        }
    }

    private boolean hasErrors(NessGraph graph) {
        if (graph == null) {
            this.notifier().notifyError("Couldn't load graph. Please recompile module");
            return true;
        }
        if (DataHubTerminalsPluginLauncher.safe(() -> this.configuration().artifact().distribution()) != null && DataHubTerminalsPluginLauncher.safe(() -> this.configuration().artifact().distribution().snapshot()) == null && this.isSnapshotVersion()) {
            this.notifier().notifyError("Snapshot distribution repository not found");
            return true;
        }
        return false;
    }

    private File resDirectory(List<File> directories) {
        File stashFiles = directories.stream().filter(d -> {
            File[] files = d.getAbsoluteFile().listFiles(f -> f.getName().endsWith(".stash"));
            return files != null && files.length > 0;
        }).findFirst().orElse(null);
        if (stashFiles == null) {
            this.notifier().notifyError("Stashes not found. Please compile module");
            return null;
        }
        return stashFiles;
    }

    private String terminalNameArtifact(Terminal terminal) {
        return Formatters.firstLowerCase(Formatters.camelCaseToSnakeCase().format((Object)terminal.name$()).toString());
    }

    private String terminalJmsVersion() {
        return this.suitableVersion(ArtifactoryConnector.terminalVersions(), "6.0.0", MAX_TERMINAL_JMS_VERSION);
    }

    private String masterVersion() {
        return this.suitableVersion(ArtifactoryConnector.masterVersions(), MINIMUM_MASTER_VERSION, "3.0.0");
    }

    private String ingestionVersion() {
        return this.suitableVersion(ArtifactoryConnector.ingestionVersions(), "5.0.2", "6.0.0");
    }

    private String eventVersion() {
        return this.suitableVersion(ArtifactoryConnector.eventVersions(), "5.0.2", "6.0.0");
    }

    private String datalakeVersion() {
        return this.suitableVersion(ArtifactoryConnector.datalakeVersions(), MINIMUM_DATALAKE_VERSION, MAX_DATALAKE_VERSION);
    }

    private String chronosVersion() {
        return this.suitableVersion(ArtifactoryConnector.chronosVersions(), MINIMUM_CHRONOS_VERSION, "3.0.0");
    }

    private String bpmVersion() {
        return this.suitableVersion(ArtifactoryConnector.bpmVersions(), MINIMUM_BPM_VERSION, MAX_BPM_VERSION);
    }

    private String suitableVersion(List<Version> versions, String min, String max) {
        try {
            Version maxVersion = new Version(max);
            Version minVersion = new Version(min);
            return versions.stream().sorted(Comparator.reverseOrder()).filter(v -> v.compareTo(maxVersion) < 0).findFirst().orElse(minVersion).get();
        }
        catch (IntinoException e) {
            Logger.error((Throwable)e);
            return min;
        }
    }

    private boolean isSnapshotVersion() {
        return this.configuration().artifact().version().contains("SNAPSHOT");
    }

    private String participle() {
        return this.invokedPhase == PluginLauncher.Phase.INSTALL ? "installed" : "distributed";
    }

    private String accessorDependency(String groupId, String artifactId, String version) {
        return "<dependency>\n    <groupId>" + groupId.toLowerCase() + "</groupId>\n    <artifactId>" + artifactId.toLowerCase() + "</artifactId>\n    <version>" + version + "</version>\n</dependency>";
    }

    private File tempDirectory() {
        try {
            return Files.createTempDirectory("_temp", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return new File("");
        }
    }

    public static <T> T safe(Safe.Wrapper<T> wrapper) {
        try {
            return wrapper.value();
        }
        catch (Throwable var2) {
            return null;
        }
    }

    public void deleteTempDirOnPublish(boolean deleteTempDirOnPublish) {
        this.deleteTempDirOnPublish = deleteTempDirOnPublish;
    }

    public void publishTerminalsIfOntologyFails(boolean publishTerminalsIfOntologyFails) {
        this.publishTerminalsIfOntologyFails = publishTerminalsIfOntologyFails;
    }
}

