package io.intino.ness.datahubterminalplugin.datamarts;

import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class EntityMounterTemplate extends Template {

	public RuleSet ruleSet() {
		return new RuleSet().add(
			rule().condition((allTypes("mounter","interface"))).output(literal("package ")).output(mark("package")).output(literal(";\n\npublic interface ")).output(mark("datamart", "FirstUpperCase")).output(literal("Mounter {\n\n\tvoid mount(io.intino.alexandria.event.Event event);\n\n\t")).output(mark("datamart", "FirstUpperCase")).output(literal("Mounter useListeners(boolean useListeners);\n\n\tdefault void update(")).output(mark("datamart", "FirstUpperCase")).output(literal("Entity entity, String attribute, Object value) {\n\t\tentity.updateAttribute(attribute, value);\n\t}\n\n   \tdefault void update(")).output(mark("datamart", "FirstUpperCase")).output(literal("Struct struct, String attribute, Object value) {\n   \t\tstruct.updateAttribute(attribute, value);\n   \t}\n\n\tenum Operation {\n\t\tCreate, Update, Remove, Skip\n\t}\n}")),
			rule().condition(not(type("abstract")), (type("mounter")), (type("message"))).output(literal("package ")).output(mark("package")).output(literal(".mounters;\n\nimport io.intino.ness.master.Datamart.EntityListener;\nimport ")).output(mark("ontologypackage")).output(literal(".")).output(mark("datamart", "FirstUpperCase")).output(literal("Datamart;\n\nimport java.time.*;\nimport java.util.*;\nimport java.util.stream.*;\n\nimport io.intino.alexandria.event.Event;\nimport io.intino.alexandria.event.message.MessageEvent;\nimport io.intino.alexandria.message.Message;\nimport ")).output(mark("ontologypackage")).output(literal(".")).output(mark("datamart", "FirstUpperCase")).output(literal("Entity;\nimport ")).output(mark("ontologypackage")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal(";\n\nimport static ")).output(mark("package")).output(literal(".")).output(mark("datamart", "FirstUpperCase")).output(literal("Mounter.Operation.*;\n\npublic class ")).output(mark("name", "FirstUpperCase")).output(literal("Mounter implements ")).output(mark("package")).output(literal(".")).output(mark("datamart", "FirstUpperCase")).output(literal("Mounter {\n\n\tprivate final ")).output(mark("datamart", "FirstUpperCase")).output(literal("Datamart.Entities entities;\n\tprivate final List<EntityListener> listeners;\n\tprivate boolean useListeners = true;\n\n\tpublic ")).output(mark("name", "FirstUpperCase")).output(literal("Mounter(")).output(mark("datamart", "FirstUpperCase")).output(literal("Datamart.Entities entities, List<EntityListener> listeners) {\n\t\tthis.entities = entities;\n\t\tthis.listeners = listeners;\n\t}\n\n\t@Override\n\tpublic ")).output(mark("name", "FirstUpperCase")).output(literal("Mounter useListeners(boolean useListeners) {\n\t\tthis.useListeners = useListeners;\n\t\treturn this;\n\t}\n\n\t@Override\n\tpublic void mount(Event event) {\n\t\tMessage message = ((MessageEvent)event).toMessage();\n\t\tString id = message.get(\"id\").asString();\n\t\tOperation[] operation = {Update};\n\t\t")).output(mark("datamart", "FirstUpperCase")).output(literal("Entity entity = findOrCreateEntity(id, operation);\n\t\tupdateAttributes(message, operation, entity);\n\t\tif(operation[0] != Skip && useListeners) notifyListeners(operation[0], entity);\n\t}\n\n\tprivate void updateAttributes(Message message, Operation[] operation, ")).output(mark("datamart", "FirstUpperCase")).output(literal("Entity owner) {\n\t\tfor(String attr : message.attributes()) {\n\t\t\tupdate(owner, attr, parse(attr, message));\n\t\t\tif(attr.equals(\"enabled\")) {\n\t\t\t\tif(message.get(\"enabled\").asBoolean()) {\n\t\t\t\t\tentities.enable(owner.id());\n\t\t\t\t} else {\n\t\t\t\t\tentities.disable(owner.id());\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t")).output(expression().output(literal("Map<String, List<Message>> components = message.components().stream().collect(Collectors.groupingBy(Message::type));")).output(literal("\n")).output(mark("struct", "setStructComponent").multiple("\n"))).output(literal("\n\t}\n\n\tprivate ")).output(mark("datamart", "FirstUpperCase")).output(literal("Entity findOrCreateEntity(String id, Operation[] operation) {\n\t\t")).output(mark("datamart", "FirstUpperCase")).output(literal("Entity entity = entities.get(")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal(".definition, id);\n\t\tif(entity == null) entity = entities.getDisabled(")).output(mark("package")).output(literal(".entities.")).output(mark("name", "FirstUpperCase")).output(literal(".definition, id);\n\t\tif(entity == null) {\n\t\t\tentity = new ")).output(mark("name", "FirstUpperCase")).output(literal("(id, entities.datamart());\n\t\t\tentities.add(entity);\n\t\t\toperation[0] = Create;\n\t\t}\n\t\treturn entity;\n\t}\n\n\tprivate void notifyListeners(Operation operation, ")).output(mark("datamart", "FirstUpperCase")).output(literal("Entity entity) {\n\t\tfor(EntityListener listener : listeners) {\n\t\t\tswitch(operation) {\n\t\t\t\tcase Create: new Thread(() -> listener.onCreate(entity), \"")).output(mark("datamart", "FirstUpperCase")).output(literal("Listener-")).output(mark("name", "FirstUpperCase")).output(literal("Mounter-\" + System.currentTimeMillis()).start(); break;\n\t\t\t\tcase Update: new Thread(() -> listener.onUpdate(entity), \"")).output(mark("datamart", "FirstUpperCase")).output(literal("Listener-")).output(mark("name", "FirstUpperCase")).output(literal("Mounter-\" + System.currentTimeMillis()).start(); break;\n\t\t\t\tcase Remove: new Thread(() -> listener.onRemove(entity), \"")).output(mark("datamart", "FirstUpperCase")).output(literal("Listener-")).output(mark("name", "FirstUpperCase")).output(literal("Mounter-\" + System.currentTimeMillis()).start(); break;\n\t\t\t}\n\t\t}\n\t}\n\n\tprivate Object parse(String attribute, Message message) {\n\t\tif(message.get(attribute).isNull()) return null;\n\t\tswitch(attribute) {\n\t\t\t")).output(expression().output(mark("attribute", "parseSwitchCase").multiple("\n"))).output(literal("\n\t\t}\n\t\treturn message.get(attribute).asString();\n\t}\n\n\t")).output(expression().output(mark("attribute", "parseMethod").multiple("\n\n"))).output(literal("\n\n\t")).output(expression().output(mark("struct", "factory").multiple("\n\n"))).output(literal("\n}")),
			rule().condition((type("struct")), (trigger("factory"))).output(literal(" private class ")).output(mark("name")).output(literal("StructFactory {\n\n\tprivate List<")).output(mark("package")).output(literal(".")).output(mark("fullName")).output(literal("> create(List<Message> components) {\n\t\tList<")).output(mark("package")).output(literal(".")).output(mark("fullName")).output(literal("> structs = new ArrayList<>();\n\t\tfor(Message component : components) structs.add(create(component));\n\t\treturn structs;\n\t}\n\n\tprivate ")).output(mark("package")).output(literal(".")).output(mark("fullName")).output(literal(" create(Message component) {\n\t\t")).output(mark("package")).output(literal(".")).output(mark("fullName")).output(literal(" owner = new ")).output(mark("package")).output(literal(".")).output(mark("fullName")).output(literal("(entities.datamart());\n\t\tfor(String attrib : component.attributes()) {\n\t\t\tupdate(owner, attrib, this.parse(attrib, component));\n\t\t}\n\n\t\t")).output(expression().output(literal("Map<String, List<Message>> components = component.components().stream().collect(Collectors.groupingBy(Message::type));")).output(literal("\n")).output(mark("struct", "setStructComponent").multiple("\n"))).output(literal("\n\n\t\treturn owner;\n\t}\n\n \tprivate Object parse(String attribute, Message message) {\n    \tif(message.get(attribute).isNull()) return null;\n    \tswitch(attribute) {\n    \t\t")).output(expression().output(mark("attribute", "parseSwitchCase").multiple("\n"))).output(literal("\n    \t}\n    \treturn message.get(attribute).asString();\n    }\n\n    ")).output(expression().output(mark("attribute", "parseMethod").multiple("\n\n"))).output(literal("\n\n    ")).output(expression().output(mark("struct", "factory").multiple("\n\n"))).output(literal("\n }")),
			rule().condition((type("multiple")), (trigger("setstructcomponent"))).output(literal("if(components.containsKey(\"")).output(mark("typename")).output(literal("\")) update(owner, \"")).output(mark("attribName", "firstLowerCase")).output(literal("\", new ")).output(mark("name")).output(literal("StructFactory().create(components.get(\"")).output(mark("typename")).output(literal("\")));")),
			rule().condition((trigger("setstructcomponent"))).output(literal("if(components.containsKey(\"")).output(mark("typename")).output(literal("\")) update(owner, \"")).output(mark("attribName", "firstLowerCase")).output(literal("\", new ")).output(mark("name")).output(literal("StructFactory().create(components.get(\"")).output(mark("typename")).output(literal("\").get(0)));")),
			rule().condition((trigger("parseswitchcase"))).output(literal("case \"")).output(mark("name")).output(literal("\": return parse")).output(mark("name", "FirstUpperCase")).output(literal("(message);")),
			rule().condition((type("attribute")), (type("list")), (type("entity")), (trigger("parsemethod"))).output(literal("private java.util.List<String> parse")).output(mark("name", "FirstUpperCase")).output(literal("(Message m) {\n\tvar value = m.get(\"")).output(mark("name")).output(literal("\");\n\treturn value.data().isEmpty() ? java.util.Collections.emptyList() : value.asList(String.class);\n}")),
			rule().condition((type("attribute")), (type("set")), (type("entity")), (trigger("parsemethod"))).output(literal("private java.util.Set<String> parse")).output(mark("name", "FirstUpperCase")).output(literal("(Message m) {\n\tvar value = m.get(\"")).output(mark("name")).output(literal("\");\n\treturn value.data().isEmpty() ? java.util.Collections.emptySet() : value.asSet(String.class);\n}")),
			rule().condition((type("attribute")), (anyTypes("list","set")), (anyTypes("date","datetime")), (trigger("parsemethod"))).output(literal("private static final java.time.format.DateTimeFormatter ")).output(mark("name", "FirstUpperCase")).output(literal("Formatter = java.time.format.DateTimeFormatter.ofPattern(\"")).output(mark("format")).output(literal("\");\nprivate ")).output(mark("type")).output(literal(" parse")).output(mark("name", "FirstUpperCase")).output(literal("(Message m) {\n\ttry {\n\t\treturn java.util.Arrays.stream(m.get(\"")).output(mark("name")).output(literal("\").as(String[].class))\n\t\t\t.map(s -> {try{return ")).output(mark("typeParameter")).output(literal(".parse(s, ")).output(mark("name", "FirstUpperCase")).output(literal("Formatter);}catch(Exception ignored){return null;}})\n\t\t\t.filter(java.util.Objects::nonNull)\n\t\t\t.collect(java.util.stream.Collectors.to")).output(mark("collectionType", "FirstUpperCase")).output(literal("());\n\t} catch(Exception ignored) {\n\t\treturn ")).output(mark("defaultValue")).output(literal(";\n\t}\n}")),
			rule().condition((type("attribute")), (type("list")), (trigger("parsemethod"))).output(literal("private java.util.List<")).output(mark("typeParameter")).output(literal("> parse")).output(mark("name", "FirstUpperCase")).output(literal("(Message m) {\n\tvar value = m.get(\"")).output(mark("name")).output(literal("\");\n\treturn value.data().isEmpty() ? java.util.Collections.emptyList() : value.asList(")).output(mark("typeParameter")).output(literal(".class);\n}")),
			rule().condition((type("attribute")), (type("set")), (trigger("parsemethod"))).output(literal("private java.util.Set<")).output(mark("typeParameter")).output(literal("> parse")).output(mark("name", "FirstUpperCase")).output(literal("(Message m) {\n\tvar value = m.get(\"")).output(mark("name")).output(literal("\");\n\treturn value.data().isEmpty() ? java.util.Collections.emptySet() : value.asSet(")).output(mark("typeParameter")).output(literal(".class);\n}")),
			rule().condition((type("attribute")), (type("entity")), (trigger("parsemethod"))).output(literal("private String parse")).output(mark("name", "FirstUpperCase")).output(literal("(Message m) {\n\treturn m.get(\"")).output(mark("name")).output(literal("\").asString();\n}")),
			rule().condition((type("attribute")), (type("struct")), (trigger("parsemethod"))).output(literal("private ")).output(mark("type")).output(literal(" parse")).output(mark("name", "FirstUpperCase")).output(literal("(Message m) {\n\treturn m.get(\"")).output(mark("name")).output(literal("\").as(")).output(mark("type")).output(literal(".class);\n}")),
			rule().condition((type("attribute")), (type("map")), (trigger("parsemethod"))).output(literal("private java.util.Map<String, String> parse")).output(mark("name", "FirstUpperCase")).output(literal("(Message m) {\n\tvar value = m.get(\"")).output(mark("name")).output(literal("\");\n\treturn value.data().isEmpty() ? java.util.Collections.emptyMap() : value.as(java.util.Map.class);\n}")),
			rule().condition((type("attribute")), (anyTypes("date","datetime")), (trigger("parsemethod"))).output(literal("private static final java.time.format.DateTimeFormatter ")).output(mark("name", "FirstUpperCase")).output(literal("Formatter = java.time.format.DateTimeFormatter.ofPattern(\"")).output(mark("format")).output(literal("\");\nprivate ")).output(mark("type")).output(literal(" parse")).output(mark("name", "FirstUpperCase")).output(literal("(Message m) {\n\ttry {\n\t\treturn ")).output(mark("type")).output(literal(".parse((m.get(\"")).output(mark("name")).output(literal("\").asString()), ")).output(mark("name", "FirstUpperCase")).output(literal("Formatter);\n\t} catch(Exception ignored) {\n\t\treturn ")).output(mark("defaultValue")).output(literal(";\n\t}\n}")),
			rule().condition((type("attribute")), (type("word")), (trigger("parsemethod"))).output(literal("private ")).output(mark("package")).output(literal(".entities.")).output(mark("type")).output(literal(" parse")).output(mark("name", "FirstUpperCase")).output(literal("(Message m) {\n\ttry {\n\t\treturn ")).output(mark("package")).output(literal(".entities.")).output(mark("type")).output(literal(".valueOf(m.get(\"")).output(mark("name")).output(literal("\").asString());\n\t} catch(Exception ignored) {\n\t\treturn ")).output(mark("defaultValue")).output(literal(";\n\t}\n}")),
			rule().condition((type("attribute")), (trigger("parsemethod"))).output(literal("private ")).output(mark("type")).output(literal(" parse")).output(mark("name", "FirstUpperCase")).output(literal("(Message m) {\n\treturn m.get(\"")).output(mark("name")).output(literal("\").as(")).output(mark("type")).output(literal(".class);\n}"))
		);
	}
}