/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.terminal;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class TerminalTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.type("terminal"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[]{"validPackage"})}).output(new Rule.Output[]{this.literal(";\n\nimport io.intino.alexandria.Scale;\nimport io.intino.alexandria.Timetag;\nimport io.intino.alexandria.event.Event;\nimport io.intino.alexandria.event.message.MessageEvent;\nimport io.intino.alexandria.logger.Logger;\nimport org.apache.activemq.command.ActiveMQTextMessage;\n\nimport javax.jms.JMSException;\nimport javax.jms.Message;\nimport javax.jms.TextMessage;\nimport java.io.File;\nimport java.time.Instant;\nimport java.util.List;\nimport java.util.Map;\nimport java.util.Collections;\nimport java.util.concurrent.TimeUnit;\nimport java.util.stream.Stream;\nimport java.util.stream.Collectors;\n\nimport java.lang.reflect.Field;\nimport java.lang.reflect.Method;\n\npublic class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal(" {\n\tpublic static String[] subscriptionChannels = new String[]{")}).output(new Rule.Output[]{this.mark("subscribe", new String[]{"channel"})}).output(new Rule.Output[]{this.literal("};\n\tprivate final io.intino.alexandria.terminal.Connector connector;\n\tprivate final java.util.Map<java.util.function.BiConsumer<?, String>, List<java.util.function.Consumer<io.intino.alexandria.event.Event>>> consumers = new java.util.HashMap<>();\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("datamart", new String[]{"declaration"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\n\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("(io.intino.alexandria.terminal.Connector connector) {\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("this(connector, ")}).output(new Rule.Output[]{this.mark("datamart", new String[]{"retryConfigDefault"})}).output(new Rule.Output[]{this.literal(");")}).next(this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("this.connector = connector;")}))}).output(new Rule.Output[]{this.literal("\n\t}\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("datamart", new String[]{"constructor"})})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("datamart", new String[]{"getter"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\n\n\tpublic void initDatamarts() {\n\t\tinitDatamarts(null);\n\t}\n\n\tpublic void initDatamarts(String sourceSelector) {\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("datamart", new String[]{"init"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t}\n\n\tpublic void publish(Event event) {\n\t\tswitch(event.type()) {\n\t\t\t")}).output(new Rule.Output[]{this.mark("publish", new String[]{"publishSwitchCase"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t\t\tdefault: Logger.warn(getClass().getSimpleName() + \" is not configured to publish \" + event.type() + \" events.\");\n\t\t}\n\t}\n\n\tpublic void publish(Event first, Event ...others) {\n\t\tpublish(Stream.concat(Stream.of(first), java.util.Arrays.stream(others)));\n\t}\n\n\tpublic void publish(Event[] events) {\n\t\tpublish(java.util.Arrays.stream(events));\n\t}\n\n\tpublic void publish(java.util.Collection<Event> events) {\n\t\tpublish(events.stream());\n\t}\n\n\tpublic void publish(Stream<Event> events) {\n\t\tevents.filter(e -> channelOf(e.type()) != null)\n\t\t\t.collect(Collectors.groupingBy(Event::type))\n\t\t\t.forEach((type, eventList) -> connector.sendEvents(channelOf(type), eventList));\n\t}\n\n\tpublic io.intino.alexandria.datalake.Datalake datalake() {\n\t\ttry {\n\t\t\tMessage message = connector.requestResponse(io.intino.alexandria.terminal.remotedatalake.DatalakeAccessor.PATH, request(\"Datalake\"), 5, TimeUnit.SECONDS);\n\t\t\tif (message == null) return null;\n\t\t\tString path = ((TextMessage) message).getText();\n\t\t\tif (path == null) return null;\n\t\t\treturn new File(path).exists()\n\t\t\t\t\t? new io.intino.alexandria.datalake.file.FileDatalake(new File(path))\n\t\t\t\t\t: new io.intino.alexandria.terminal.remotedatalake.RemoteDatalake((io.intino.alexandria.terminal.JmsConnector) connector);\n\n\t\t} catch (JMSException e) {\n\t\t\tLogger.error(e);\n\t\t\treturn null;\n\t\t}\n\t}\n\n\tpublic BatchSession batch(java.io.File temporalStageDirectory) {\n\t\treturn new BatchSession(temporalStageDirectory);\n\t}\n\n\tpublic BatchSession batch(java.io.File temporalStageDirectory, Config config) {\n\t\treturn new BatchSession(temporalStageDirectory, config);\n\t}\n\n\t")}).output(new Rule.Output[]{this.mark("publish", new String[0]).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.mark("subscribe", new String[0]).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\n\tpublic synchronized void requestSeal() {\n\t\tconnector.requestResponse(\"service.ness.seal\", request(\"Seal\"), 30, TimeUnit.MINUTES);\n\t}\n\n\tpublic synchronized Instant requestLastSeal() {\n\t\tMessage message = connector.requestResponse(\"service.ness.seal.last\", request(\"LastSeal\"), 10, TimeUnit.MINUTES);\n\t\tif (message == null) return Instant.now();\n\t\ttry {\n\t\t\treturn Instant.parse(((TextMessage) message).getText());\n\t\t} catch (Exception e) {\n\t\t\tLogger.error(e);\n\t\t\treturn Instant.now();\n\t\t}\n\t}\n\n\tprivate javax.jms.Message request(String type) {\n\t\treturn request(type, Collections.emptyMap());\n\t}\n\n\tprivate javax.jms.Message request(String type, Map<String, String> attributes) {\n\t\ttry {\n\t\t\tActiveMQTextMessage m = new ActiveMQTextMessage();\n\t\t\tio.intino.alexandria.message.Message message = new io.intino.alexandria.message.Message(type);\n\t\t\tattributes.forEach(message::set);\n\t\t\tm.setText(message.toString());\n\t\t\treturn m;\n\t\t} catch(Exception e) {\n\t\t\tthrow new RuntimeException(e);\n\t\t}\n\t}\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("datamart", new String[]{"addDatamartSubscribers"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\tprivate String channelOf(String type) {\n\t\tswitch(type) {\n\t\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("publish", new String[]{"channelOfSwitchCase"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t\t}\n\t\treturn null;\n\t}\n\n\tpublic class BatchSession {\n\t\tprivate final java.io.File temporalStage;\n\t\tprivate final io.intino.alexandria.ingestion.SessionHandler sessionHandler;\n\t\tprivate final io.intino.alexandria.ingestion.EventSession session;\n\t\tprivate final Scale scale;\n\n\t\tpublic BatchSession(java.io.File temporalStage) {\n\t\t\tthis(temporalStage, new Config());\n\t\t}\n\n\t\tpublic BatchSession(java.io.File temporalStage, Config config) {\n\t\t\tthis.temporalStage = temporalStage;\n\t\t\tthis.scale = config.scale;\n\t\t\tthis.sessionHandler = new io.intino.alexandria.ingestion.SessionHandler(temporalStage);\n\t\t\tthis.session = sessionHandler.createEventSession(config.eventsBufferSize);\n\t\t}\n\n\t\tpublic void feed(Event event) throws java.io.IOException {\n\t\t\tsession.put(tankOf(event), event.ss(), Timetag.of(event.ts(), this.scale), event.format(), event);\n\t\t}\n\n\t\tpublic void feed(Event event, Scale scale) throws java.io.IOException {\n\t\t\tsession.put(tankOf(event), event.ss(), Timetag.of(event.ts(), scale), event.format(), event);\n\t\t}\n\n\t\tpublic void flush() {\n\t\t\tsession.flush();\n\t\t}\n\n\t\tpublic void push(File dataHubStage) {\n\t\t\tsession.close();\n\t\t\tsessionHandler.pushTo(dataHubStage);\n\t\t\t//connector.sendEvent(\"service.ness.push\", new Event(new io.intino.alexandria.message.Message(\"Push\").set(\"stage\", temporalStage.getName())));\n\t\t}\n\n\t\tpublic void push(String host, String user, String dataHubStageAbsolutePath) {\n\t\t\tsession.close();\n\t\t\ttry {\n\t\t\t\tList<File> files = allFilesIn(temporalStage.toPath(), path -> path.getName().endsWith(io.intino.alexandria.Session.SessionExtension)).collect(Collectors.toList());\n\t\t\t\tupload(files, host, user, dataHubStageAbsolutePath);\n\t\t\t\ttemporalStage.renameTo(new File(temporalStage.getParentFile(), temporalStage.getName() + \".treated\"));\n\t\t\t} catch(Exception e) {\n\t\t\t\tLogger.error(e);\n\t\t\t}\n\t\t}\n\n\t\tprivate static Stream<File> allFilesIn(java.nio.file.Path path, java.util.function.Predicate<File> filter) throws Exception {\n\t\t\tStream.Builder<File> streamBuilder = Stream.builder();\n\t\t\ttry (Stream<java.nio.file.Path> paths = java.nio.file.Files.walk(path)) {\n\t\t\t\tpaths.filter(p -> java.nio.file.Files.isRegularFile(p) && filter.test(p.toFile())).forEach(p -> streamBuilder.add(p.toFile()));\n\t\t\t}\n\t\t\treturn streamBuilder.build();\n\t\t}\n\n\t\tpublic synchronized void seal() {\n\t\t\tconnector.requestResponse(\"service.ness.seal\", request(\"Seal\", Map.of(\"stage\", temporalStage.getName())));\n\t\t}\n\n\t\tprivate void upload(List<File> sessions, String host, String user, String dataHubStageAbsolutePath) {\n\t\t\ttry {\n\t\t\t\tString connectionChain = user + \"@\" + host + \":\" + dataHubStageAbsolutePath;\n\t\t\t\tLogger.info(\"Uploading sessions to \" + connectionChain + \"...\");\n\t\t\t\tfor (File s : sessions) {\n\t\t\t\t\tProcess process = new ProcessBuilder(\"scp\", s.getAbsolutePath(), connectionChain)\n\t\t\t\t\t\t\t.inheritIO()\n\t\t\t\t\t\t\t.start();\n\t\t\t\t\tprocess.waitFor(1, java.util.concurrent.TimeUnit.HOURS);\n\t\t\t\t}\n\t\t\t\tLogger.info(\"sessions uploaded\");\n\t\t\t} catch (java.io.IOException | InterruptedException ignored) {\n\t\t\t}\n\n\t\t}\n\n\t\tprivate String tankOf(Event event) {\n\t\t\t")}).output(new Rule.Output[]{this.mark("publish", new String[]{"tankOf"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t\t\treturn event.type();\n\t\t}\n\t}\n\n\tpublic static class Config {\n\t\tprivate int eventsBufferSize = 1_000_000;\n\t\tprivate int setsBufferSize = 1_000_000;\n\t\tprivate Scale scale = Scale.")}).output(new Rule.Output[]{this.mark("scale", new String[0])}).output(new Rule.Output[]{this.literal(";\n\n\t\tpublic Config scale(Scale scale) {\n\t\t\tthis.scale = scale;\n\t\t\treturn this;\n\t\t}\n\n\t\tpublic Config eventsBufferSize(int eventsBufferSize) {\n\t\t\tthis.eventsBufferSize = eventsBufferSize;\n\t\t\treturn this;\n\t\t}\n\n\t\tpublic Config setsBufferSize(int setsBufferSize) {\n\t\t\tthis.setsBufferSize = setsBufferSize;\n\t\t\treturn this;\n\t\t}\n\t}\n\n\t")}).output(new Rule.Output[]{this.mark("message", new String[]{"interface"}).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\t")}).output(new Rule.Output[]{this.mark("measurement", new String[]{"interface"}).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\t")}).output(new Rule.Output[]{this.mark("processstatus", new String[]{"interface"}).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("datamart", new String[]{"retryConfigClass"})})}).output(new Rule.Output[]{this.literal("\n}")}), this.rule().condition(this.trigger("retryconfigclass"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public static class DatamartsRetryConfig {\n\tpublic final long initialTimeoutAmount;\n\tpublic final java.util.concurrent.TimeUnit timeoutUnit;\n\tpublic final float timeoutMultiplier;\n\tpublic final int maxAttempts;\n\n\tpublic DatamartsRetryConfig() {\n\t\tthis(1, java.util.concurrent.TimeUnit.MINUTES, 2.0f, 5);\n\t}\n\n\tpublic DatamartsRetryConfig(long initialTimeoutAmount, java.util.concurrent.TimeUnit timeoutUnit, float timeoutMultiplier, int maxAttempts) {\n\t\tthis.initialTimeoutAmount = initialTimeoutAmount;\n\t\tthis.timeoutUnit = timeoutUnit;\n\t\tthis.timeoutMultiplier = timeoutMultiplier;\n\t\tthis.maxAttempts = maxAttempts;\n\t}\n}")}), this.rule().condition(this.trigger("constructor"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public ")}).output(new Rule.Output[]{this.mark("terminal", new String[]{"snakeCaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("(io.intino.alexandria.terminal.Connector connector, DatamartsRetryConfig datamartsRetryConfig) {\n\tthis.connector = connector;\n\tthis.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Datamart = new ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartImpl(connector, datamartsRetryConfig);\n}")}), this.rule().condition(this.trigger("init"), new Rule.Condition[0]).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Datamart.init(sourceSelector);\naddDatamartSubscribers(this.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Datamart, sourceSelector);")}), this.rule().condition(this.trigger("retryconfigassign"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("this.datamartsRetryConfig = datamartsRetryConfig;")}), this.rule().condition(this.trigger("retryconfigdefault"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("new DatamartsRetryConfig()")}), this.rule().condition(this.type("datamart"), new Rule.Condition[]{this.trigger("declaration")}).output(new Rule.Output[]{this.literal("private final ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartImpl ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Datamart;")}), this.rule().condition(this.type("datamart"), new Rule.Condition[]{this.trigger("instantiate")}), this.rule().condition(this.type("datamart"), new Rule.Condition[]{this.trigger("getter")}).output(new Rule.Output[]{this.literal("public ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Datamart() {\n\treturn ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Datamart;\n}")}), this.rule().condition(this.type("datamart"), new Rule.Condition[]{this.trigger("adddatamartsubscribers")}).output(new Rule.Output[]{this.literal("private void addDatamartSubscribers(")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartImpl datamart, String sourceSelector) {\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("devent", new String[]{"addSubscribe"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n}")}), this.rule().condition(this.type("devent"), new Rule.Condition[]{this.trigger("addsubscribe")}).output(new Rule.Output[]{this.literal("subscribe((")}).output(new Rule.Output[]{this.mark("namespaceQn", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.mark("message", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Consumer) (event, topic) -> datamart.mount(event), connector.clientId() + \"_")}).output(new Rule.Output[]{this.mark("datamart", new String[0])}).output(new Rule.Output[]{this.literal("_")}).output(new Rule.Output[]{this.mark("message", new String[0])}).output(new Rule.Output[]{this.literal("\", sourceSelector);")}), this.rule().condition(this.trigger("publishswitchcase"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("case \"")}).output(new Rule.Output[]{this.mark("typename", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("\": publish((event instanceof ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(" e ? e : new ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal("(((io.intino.alexandria.event.message.MessageEvent) event).toMessage()))); break;")}), this.rule().condition(this.trigger("channelofswitchcase"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("case \"")}).output(new Rule.Output[]{this.mark("typename", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("\": return \"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\";")}), this.rule().condition(this.not(this.type("bpm")), new Rule.Condition[]{this.trigger("tankof")}).output(new Rule.Output[]{this.literal("if (event instanceof ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(") return \"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\";")}), this.rule().condition(this.type("bpm"), new Rule.Condition[]{this.trigger("publish")}).output(new Rule.Output[]{this.literal("public void publish(")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(" e) {\n\tconnector.sendEvent(\"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\", e);\n}")}), this.rule().condition(this.not(this.type("bpm")), new Rule.Condition[]{this.type("measurement"), this.trigger("publish")}).output(new Rule.Output[]{this.literal("public void publish(")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(" e) {\n\tconnector.sendEvent(\"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\", e);\n}")}), this.rule().condition(this.not(this.type("bpm")), new Rule.Condition[]{this.trigger("publish")}).output(new Rule.Output[]{this.literal("public void publish(")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(" e) {\n\tconnector.sendEvent(\"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\", e);\n}\n\npublic void publish(")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(" first, ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(" ...others) {\n\t")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal("[] array = new ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal("[1 + others.length];\n\tarray[0] = first;\n\tjava.lang.System.arraycopy(others, 0, array, 1, others.length);\n\tpublish(array);\n}\n\npublic void publish(")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal("[] events) {\n\tconnector.sendEvents(\"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\", java.util.Arrays.asList(events));\n}")}), this.rule().condition(this.type("bpm"), new Rule.Condition[]{this.trigger("subscribe")}).output(new Rule.Output[]{this.literal("public void subscribe(ProcessStatusConsumer onEventReceived, String subscriberId) {\n\tconsumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.alexandria.bpm.ProcessStatus(((MessageEvent) event).toMessage()), \"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\");} catch(Throwable e) { Logger.error(e); }}));\n\tconnector.attachListener(\"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\", subscriberId, consumers.get(onEventReceived).get(0));\n}\n\npublic void subscribe(ProcessStatusConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter) {\n\tconsumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.alexandria.bpm.ProcessStatus(((MessageEvent) event).toMessage()), \"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\");} catch(Throwable e) { Logger.error(e); }}));\n\tconnector.attachListener(\"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\", subscriberId, consumers.get(onEventReceived).get(0), filter);\n}\n\npublic void subscribe(ProcessStatusConsumer onEventReceived) {\n\tconsumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.alexandria.bpm.ProcessStatus(((MessageEvent) event).toMessage()), \"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\");} catch(Throwable e) { Logger.error(e); }}));\n\tconnector.attachListener(\"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\", consumers.get(onEventReceived).get(0));\n}\n\npublic void unsubscribe(ProcessStatusConsumer onEventReceived) {\n\tconsumers.get(onEventReceived).forEach(connector::detachListeners);\n}")}), this.rule().condition(this.type("measurement"), new Rule.Condition[]{this.trigger("subscribe")}).output(new Rule.Output[]{this.literal("public void subscribe(")}).output(new Rule.Output[]{this.mark("namespaceQn", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.mark("message", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Consumer onEventReceived, String subscriberId) {\n\tconsumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept((")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(") event, \"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\");} catch(Throwable e) { Logger.error(e); }}));\n\tconnector.attachListener(\"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\", subscriberId, consumers.get(onEventReceived).get(0));\n}\n\npublic void subscribe(")}).output(new Rule.Output[]{this.mark("namespaceQn", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.mark("message", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Consumer onEventReceived, String subscriberId, String sourceSelector) {\n\tconsumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept((")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(") event, \"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\");} catch(Throwable e) { Logger.error(e); }}));\n\tconnector.attachListener(\"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);\n}\n\npublic void subscribe(")}).output(new Rule.Output[]{this.mark("namespaceQn", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.mark("message", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Consumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter) {\n\tconsumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept((")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(") event, \"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\");} catch(Throwable e) { Logger.error(e); }}));\n\tconnector.attachListener(\"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\", subscriberId, consumers.get(onEventReceived).get(0), filter);\n}\n\npublic void subscribe(")}).output(new Rule.Output[]{this.mark("namespaceQn", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.mark("message", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Consumer onEventReceived) {\n\tconsumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept((")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(") event, \"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\");} catch(Throwable e) { Logger.error(e); }}));\n\tconnector.attachListener(\"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\", consumers.get(onEventReceived).get(0));\n}\n\npublic void unsubscribe(")}).output(new Rule.Output[]{this.mark("namespaceQn", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.mark("message", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Consumer onEventReceived) {\n\tconsumers.get(onEventReceived).forEach(connector::detachListeners);\n}")}), this.rule().condition(this.type("message"), new Rule.Condition[]{this.trigger("subscribe")}).output(new Rule.Output[]{this.literal("public void subscribe(")}).output(new Rule.Output[]{this.mark("namespaceQn", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.mark("message", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Consumer onEventReceived, String subscriberId) {\n\tconsumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal("((MessageEvent) event), \"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\");} catch(Throwable e) { Logger.error(e); }}));\n\tconnector.attachListener(\"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\", subscriberId, consumers.get(onEventReceived).get(0));\n}\n\npublic void subscribe(")}).output(new Rule.Output[]{this.mark("namespaceQn", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.mark("message", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Consumer onEventReceived, String subscriberId, String sourceSelector) {\n\tconsumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal("((MessageEvent) event), \"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\");} catch(Throwable e) { Logger.error(e); }}));\n\tconnector.attachListener(\"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\", subscriberId, consumers.get(onEventReceived).get(0), sourceSelector);\n}\n\npublic void subscribe(")}).output(new Rule.Output[]{this.mark("namespaceQn", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.mark("message", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Consumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter) {\n\tconsumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal("((MessageEvent) event), \"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\");} catch(Throwable e) { Logger.error(e); }}));\n\tconnector.attachListener(\"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\", subscriberId, consumers.get(onEventReceived).get(0), filter);\n}\n\npublic void subscribe(")}).output(new Rule.Output[]{this.mark("namespaceQn", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.mark("message", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Consumer onEventReceived) {\n\tconsumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal("((MessageEvent) event), \"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\");} catch(Throwable e) { Logger.error(e); }}));\n\tconnector.attachListener(\"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\", consumers.get(onEventReceived).get(0));\n}\n\npublic void unsubscribe(")}).output(new Rule.Output[]{this.mark("namespaceQn", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.mark("message", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Consumer onEventReceived) {\n\tconsumers.get(onEventReceived).forEach(connector::detachListeners);\n}")}), this.rule().condition(this.type("resource"), new Rule.Condition[]{this.trigger("subscribe")}).output(new Rule.Output[]{this.literal("public void subscribe(")}).output(new Rule.Output[]{this.mark("namespaceQn", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.mark("message", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Consumer onEventReceived, String subscriberId) {\n\tconsumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal("((ResourceEvent) event), \"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\");} catch(Throwable e) { Logger.error(e); }}));\n\tconnector.attachListener(\"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\", subscriberId, consumers.get(onEventReceived).get(0));\n}\n\npublic void subscribe(")}).output(new Rule.Output[]{this.mark("namespaceQn", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.mark("message", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Consumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter) {\n\tconsumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal("((ResourceEvent) event), \"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\");} catch(Throwable e) { Logger.error(e); }}));\n\tconnector.attachListener(\"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\", subscriberId, consumers.get(onEventReceived).get(0), filter);\n}\n\npublic void subscribe(")}).output(new Rule.Output[]{this.mark("namespaceQn", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.mark("message", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Consumer onEventReceived) {\n\tconsumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal("((ResourceEvent) event), \"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\");} catch(Throwable e) { Logger.error(e); }}));\n\tconnector.attachListener(\"")}).output(new Rule.Output[]{this.mark("channel", new String[0])}).output(new Rule.Output[]{this.literal("\", consumers.get(onEventReceived).get(0));\n}\n\npublic void unsubscribe(")}).output(new Rule.Output[]{this.mark("namespaceQn", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.mark("message", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Consumer onEventReceived) {\n\tconsumers.get(onEventReceived).forEach(connector::detachListeners);\n}")}), this.rule().condition(this.trigger("quoted"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("\"")}).output(new Rule.Output[]{this.mark("", new String[0])}).output(new Rule.Output[]{this.literal("\"")}), this.rule().condition(this.trigger("interface"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public interface ")}).output(new Rule.Output[]{this.mark("namespaceQn", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Consumer extends java.util.function.BiConsumer<")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(", String> {\n}")})});
    }
}

