/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.ontology;

import io.intino.Configuration;
import io.intino.datahub.model.Datalake;
import io.intino.datahub.model.Message;
import io.intino.datahub.model.NessGraph;
import io.intino.datahub.model.Resource;
import io.intino.datahub.model.Sensor;
import io.intino.ness.datahubterminalplugin.datamarts.DatamartsRenderer;
import io.intino.ness.datahubterminalplugin.measurement.MeasurementRenderer;
import io.intino.ness.datahubterminalplugin.message.MessageRenderer;
import io.intino.ness.datahubterminalplugin.resource.ResourceRenderer;
import io.intino.plugin.PluginLauncher;
import java.io.File;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class OntologyRenderer {
    private final NessGraph graph;
    private final Configuration conf;
    private final PrintStream logger;
    private final PluginLauncher.Notifier notifier;
    private final File srcDir;
    private final String basePackage;

    OntologyRenderer(NessGraph graph, Configuration conf, File srcDir, String basePackage, PrintStream logger, PluginLauncher.Notifier notifier) {
        this.graph = graph;
        this.conf = conf;
        this.logger = logger;
        this.notifier = notifier;
        this.srcDir = srcDir;
        this.basePackage = basePackage;
        srcDir.mkdirs();
    }

    public boolean render() {
        this.renderMessages();
        this.renderMeasurements();
        this.renderDatamarts();
        return true;
    }

    private void renderMessages() {
        this.graph.core$().find(Message.class).forEach(event -> new MessageRenderer((Message)event, this.srcDir, this.basePackage).render());
    }

    private void renderMeasurements() {
        this.measurements().forEach(m -> new MeasurementRenderer((Sensor)m, this.srcDir, this.basePackage).render());
    }

    private void renderResources() {
        this.graph.core$().find(Resource.class).forEach(r -> new ResourceRenderer((Resource)r, this.srcDir, this.basePackage).render());
    }

    private void renderDatamarts() {
        new DatamartsRenderer(this.srcDir, this.graph, this.conf, this.logger, this.notifier, this.basePackage).render();
    }

    private List<Sensor> measurements() {
        return this.graph.datalake() == null ? Collections.emptyList() : this.graph.datalake().tankList().stream().filter(Datalake.Tank::isMeasurement).map(tank -> tank.asMeasurement().sensor()).collect(Collectors.toList());
    }
}

