/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.master;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class DatamartTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.allTypes(new String[]{"datamart", "interface"}), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(";\n\nimport java.util.List;\nimport java.util.Map;\nimport java.util.concurrent.ConcurrentHashMap;\nimport java.util.stream.Stream;\nimport java.util.stream.Collectors;\n\nimport io.intino.ness.master.Datamart;\nimport io.intino.ness.master.model.Entity;\nimport io.intino.ness.master.reflection.*;\n\npublic interface ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart extends Datamart {\n\n\tDatamartDefinition definition = new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart.DatamartDefinitionInternal();\n\n\tList<String> listSnapshots();\n\t")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart snapshot(String timetag);\n\n\t")}).output(new Rule.Output[]{this.mark("entity", new String[]{"getterSignature"}).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\n\tclass Entities {\n\n\t\tprivate final ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart datamart;\n\t\tprivate final Map<EntityDefinition, Map<String, ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity>> entitiesByType;\n\n\t\tpublic Entities(")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart datamart) {\n\t\t\tthis.datamart = datamart;\n\t\t\tthis.entitiesByType = new ConcurrentHashMap<>();\n\t\t\tdatamart.getDefinition().entities().stream().filter(e -> !e.isAbstract()).forEach(entity -> entitiesByType.put(entity, new ConcurrentHashMap<>()));\n\t\t}\n\n\t\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart datamart() {\n\t\t\treturn datamart;\n\t\t}\n\n    \tpublic int size() {\n    \t\treturn entitiesByType.values().stream().mapToInt(Map::size).sum();\n    \t}\n\n    \tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity get(String id) {\n    \t\treturn mapOf(id).map(map -> map.get(id)).orElse(null);\n    \t}\n\n    \tpublic <T extends ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity> T getDescendant(EntityDefinition definition, String id) {\n    \t\tT entity = get(definition, id);\n    \t\treturn entity != null ? entity: definition.descendants().stream()\n    \t\t\t.filter(descendant -> !descendant.isAbstract())\n    \t\t\t.map(descendant -> this.<T>get(descendant, id))\n    \t\t\t.filter(java.util.Objects::nonNull).findFirst().orElse(null);\n    \t}\n\n\t\t@SuppressWarnings(\"unchecked\")\n    \tpublic <T extends ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity> T get(EntityDefinition type, String id) {\n    \t\treturn entitiesByType.containsKey(type) ? (T) entitiesByType.get(type).get(id) : null;\n        }\n\n    \tpublic void add(")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity entity) {\n    \t\tentitiesByType.get(entity.getDefinition()).put(entity.id(), entity);\n    \t}\n\n    \tpublic void remove(String id) {\n    \t\tmapOf(id).ifPresent(map -> map.remove(id));\n    \t}\n\n    \tpublic Stream<")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity> stream() {\n    \t\treturn entitiesByType.values().stream().flatMap(map -> map.values().stream());\n    \t}\n\n\t\t@SuppressWarnings(\"unchecked\")\n    \tpublic <T extends ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity> Stream<T> stream(EntityDefinition type) {\n    \t\treturn (Stream<T>) (entitiesByType.containsKey(type) ? entitiesByType.get(type).values().stream() : Stream.empty());\n    \t}\n\n    \tpublic Stream<Entity> streamGeneric() {\n        \treturn entitiesByType.values().stream().flatMap(map -> map.values().stream());\n        }\n\n    \tprivate java.util.Optional<Map<String, ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Entity>> mapOf(String id) {\n    \t\treturn entitiesByType.values().stream().filter(map -> map.containsKey(id)).findFirst();\n    \t}\n    }\n\n\tfinal class DatamartDefinitionInternal implements DatamartDefinition {\n\t\tprivate DatamartDefinition definition;\n\t\tprivate DatamartDefinitionInternal() {}\n\t\t@Override\n\t\tpublic String name() {return definition().name();}\n\t\t@Override\n\t\tpublic Datamart.Scale scale() {return definition().scale();}\n\t\t@Override\n\t\tpublic Query<EntityDefinition> entities() {return definition().entities();}\n\t\t@Override\n\t\tpublic Query<StructDefinition> structs() {return definition().structs();}\n\t\tprivate DatamartDefinition definition() {\n\t\t\tif(definition == null) throw new IllegalStateException(\"")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart is not initialized\");\n\t\t\treturn definition;\n\t\t}\n\t}\n}")}), this.rule().condition(this.allTypes(new String[]{"datamart", "message", "impl"}), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(";\n\nimport io.intino.alexandria.Timetag;\nimport io.intino.alexandria.event.Event;\nimport io.intino.alexandria.logger.Logger;\nimport io.intino.alexandria.terminal.Connector;\nimport io.intino.ness.master.reflection.*;\nimport io.intino.ness.master.model.Entity;\n\nimport org.apache.activemq.command.ActiveMQTextMessage;\n\nimport java.util.List;\nimport java.util.ArrayList;\nimport java.util.Map;\nimport java.util.HashMap;\nimport java.util.Optional;\nimport java.util.concurrent.atomic.AtomicBoolean;\nimport java.util.stream.Stream;\nimport java.util.stream.Collectors;\nimport java.time.LocalDate;\nimport java.time.LocalDateTime;\nimport java.time.Instant;\n\nimport ")}).output(new Rule.Output[]{this.mark("ontologypackage", new String[0])}).output(new Rule.Output[]{this.literal(".*;\n\nimport static java.util.Objects.requireNonNull;\n\npublic class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartImpl implements ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart {\n\n\tprivate static final String DATAHUB_MESSAGE_TOPIC = \"service.ness.datamarts\";\n\tprivate static final ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartImpl.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartDefinition definition = new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartImpl.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartDefinition();\n\n\tprivate final Connector connector;\n\tprivate final ")}).output(new Rule.Output[]{this.mark("terminal", new String[0])}).output(new Rule.Output[]{this.literal(".DatamartsRetryConfig retryConfig;\n\tprivate final AtomicBoolean initialized = new AtomicBoolean(false);\n\tprivate final List<EntityListener> entityListeners = new ArrayList<>();\n\tprivate final ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart.Entities entities;\n\tprivate final Map<String, List<MasterMounter>> mounters = new HashMap<>();\n\n\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartImpl(Connector connector, ")}).output(new Rule.Output[]{this.mark("terminal", new String[0])}).output(new Rule.Output[]{this.literal(".DatamartsRetryConfig retryConfig) {\n\t\tthis.connector = requireNonNull(connector);\n\t\tthis.retryConfig = requireNonNull(retryConfig);\n\t\tthis.entities = new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart.Entities(this);\n\t\tinitMounters();\n\t}\n\n\tpublic synchronized ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartImpl init() {\n\t\ttry {\n\t\t\tif(!initialized.compareAndSet(false, true)) return this;\n\t\t\tdownloadDatamartFromDatahub();\n\t\t\tLogger.info(\"")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart (\" + (snapshotTimetag().isEmpty() ? \"\" : \"snapshot \" + snapshotTimetag() + \", \")  + connector.clientId() + \") initialized successfully.\");\n\t\t} catch(Exception e) {\n\t\t\tthrow new ExceptionInInitializerError(\"")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart failed to start because a \" + e.getClass().getName() + \" occurred: \" + e.getMessage());\n\t\t}\n\t\treturn this;\n\t}\n\n\t@Override\n\tpublic int size() {\n\t\treturn entities.size();\n\t}\n\n\t@Override\n\t@SuppressWarnings(\"unchecked\")\n\tpublic <T extends Entity> T get(String id) {\n\t\treturn (T) entities.get(id);\n\t}\n\n\t@Override\n\tpublic Stream<Entity> entities() {\n\t\treturn entities.streamGeneric();\n\t}\n\n\t@Override\n\tpublic void addEntityListener(EntityListener listener) {\n\t\tif(listener == null) throw new NullPointerException(\"EntityListener cannot be null\");\n\t\tentityListeners.add(listener);\n\t}\n\n\t@Override\n\tpublic DatamartDefinition getDefinition() {\n\t\treturn definition;\n\t}\n\n\t@Override\n    public List<String> listSnapshots() {\n    \ttry {\n    \t\tjavax.jms.Message message = requestResponseFromDatahub(\"listSnapshots\", listSnapshotsRequest());\n    \t\treturn handleListSnapshotsResponse(message);\n    \t} catch (Exception e) {\n    \t\tLogger.error(\"Could not download list of available snapshots: \" + e.getMessage(), e);\n    \t\treturn java.util.Collections.emptyList();\n    \t}\n    }\n\n    private javax.jms.Message listSnapshotsRequest() throws Exception {\n    \tActiveMQTextMessage message = new ActiveMQTextMessage();\n    \tmessage.setText(\"datamart:\" + name() + \":snapshots\");\n    \treturn message;\n    }\n\n    private List<String> handleListSnapshotsResponse(javax.jms.Message message) throws Exception {\n    \treturn java.util.Arrays.stream(((javax.jms.TextMessage) message).getText().split(\",\")).collect(Collectors.toList());\n    }\n\n    @Override\n    public synchronized ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart snapshot(String timetag) {\n    \tif(timetag == null) return this;\n    \treturn new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartImpl(connector, retryConfig) {\n    \t\t@Override\n    \t\tprotected String snapshotTimetag() {\n    \t\t\treturn timetag;\n    \t\t}\n    \t\t@Override\n    \t\tpublic synchronized MasterDatamart snapshot(String timetag) {\n    \t\t\tthrow new java.lang.UnsupportedOperationException(\"Cannot request snapshots to snapshot instances of a datamart\");\n    \t\t}\n    \t}.init();\n    }\n\n\t")}).output(new Rule.Output[]{this.mark("entity", new String[]{"getter"}).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\n\tprivate void downloadDatamartFromDatahub() {\n\t\tLogger.debug(\"Downloading datamart from datahub...\");\n\t\tlong start = java.lang.System.currentTimeMillis();\n\t\tint[] numEvents = new int[1];\n\t\tloadEntitiesFromEvents(downloadEvents(numEvents), numEvents);\n\t\tlong time = java.lang.System.currentTimeMillis() - start;\n\t\tLogger.debug(\"Datamart downloaded from datahub after \" + time + \" ms\");\n\t}\n\n\tprivate Stream<Event> downloadEvents(int[] numEvents) {\n\t\ttry {\n\t\t\tjavax.jms.Message message = requestResponseFromDatahub(\"downloadEvents\", downloadRequest());\n\t\t\treturn handleDownloadResponse(message, numEvents);\n\t\t} catch (NullPointerException e) {\n\t\t\tthrow new NullPointerException(\"Could not download datamart: no response from datahub.\");\n\t\t} catch (Exception e) {\n\t\t\tthrow new RuntimeException(\"Could not download datamart: \" + e.getMessage());\n\t\t}\n\t}\n\n\tprivate javax.jms.Message downloadRequest() throws Exception {\n\t\tActiveMQTextMessage message = new ActiveMQTextMessage();\n\t\tmessage.setText(\"datamart:\" + name() + \":\" + snapshotTimetag());\n\t\treturn message;\n\t}\n\n\tprotected String snapshotTimetag() {\n\t\treturn \"\";\n\t}\n\n\tprivate Stream<Event> handleDownloadResponse(javax.jms.Message message, int[] numEvents) throws Exception {\n\t\tjavax.jms.BytesMessage m = (javax.jms.BytesMessage) message;\n\t\tnumEvents[0] = m.getIntProperty(\"size\");\n\t\tint size = m.getIntProperty(\"content-size\");\n\t\tbyte[] bytes = new byte[size];\n\t\tm.readBytes(bytes, size);\n\t\treturn io.intino.alexandria.zim.ZimStream.of(new java.io.ByteArrayInputStream(bytes)).map(io.intino.alexandria.event.message.MessageEvent::new);\n\t}\n\n\tprivate void loadEntitiesFromEvents(Stream<Event> events, int[] numEvents) {\n\t\tif(availableThreads() >= 4 && numEvents[0] > 100)\n\t\t\tevents.parallel().forEach(this::mount);\n\t\telse\n\t\t\tevents.forEach(this::mount);\n\t}\n\n\tpublic void mount(Event event) {\n\t\tif(event == null) return;\n\t\ttry {\n\t\t\tjava.util.Optional.ofNullable(this.mounters.get(event.type())).ifPresent(mounters -> mounters.forEach(mounter -> mounter.mount(event)));\n\t\t} catch(Exception e) {\n\t\t\tLogger.error(\"Failed to mount event of type \" + event.type() + \": \" + e.getMessage(), e);\n\t\t}\n\t}\n\n\tprivate void initMounters() {\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("entity", new String[]{"registerMounter"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t}\n\n\tprivate static int availableThreads() {\n\t\treturn Runtime.getRuntime().availableProcessors();\n\t}\n\n\tprivate javax.jms.Message requestResponseFromDatahub(String requestName, javax.jms.Message request) throws Exception {\n    \tlong timeout = retryConfig.initialTimeoutAmount;\n    \tfor(int i = 0;i < retryConfig.maxAttempts;i++) {\n    \t\tjavax.jms.Message message = connector.requestResponse(DATAHUB_MESSAGE_TOPIC, request, timeout, retryConfig.timeoutUnit);\n    \t\tif(message != null) return message;\n    \t\tif(i < retryConfig.maxAttempts - 1) Logger.warn(\"(\"+(i+1)+\") Datahub did not respond after \" + timeout + \" \" + retryConfig.timeoutUnit + \" to the request '\" + requestName + \"'. Trying again...\");\n    \t\ttimeout *= retryConfig.timeoutMultiplier;\n    \t}\n    \tthrow new RuntimeException(\"Datahub did not respond to the request '\" + requestName + \"' after \" + retryConfig.maxAttempts);\n    }\n\n\t// WARNING: extremely compacted and ugly code ahead... continue at your own discretion.\n\n\tpublic static final class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartDefinition implements DatamartDefinition {\n\n\t\t@Override\n\t\tpublic String name() {\n\t\t\treturn \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\";\n\t\t}\n\n\t\t@Override\n\t\tpublic Scale scale() {\n\t\t\treturn Scale.")}).output(new Rule.Output[]{this.mark("scale", new String[0])}).output(new Rule.Output[]{this.literal(";\n\t\t}\n\n\t\t@Override\n\t\tpublic Query<EntityDefinition> entities() {\n\t\t\treturn new Query<EntityDefinition>(List.of(")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("entity", new String[]{"definition"}).multiple(",")})}).output(new Rule.Output[]{this.literal("));\n\t\t}\n\n\t\t@Override\n\t\tpublic Query<StructDefinition> structs() {\n\t\t\treturn new Query<StructDefinition>(List.of(")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("struct", new String[]{"definition"}).multiple(",")})}).output(new Rule.Output[]{this.literal("));\n\t\t}\n\n\t\t@Override\n\t\tpublic Optional<EntityDefinition> entity(String name) {\n\t\t\tswitch(name) {\n\t\t\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("entity", new String[]{"defSwitchCase"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t\t\t}\n\t\t\treturn Optional.empty();\n\t\t}\n\n\t\t@Override\n    \tpublic Optional<StructDefinition> struct(String name) {\n    \t\tswitch(name) {\n    \t\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("struct", new String[]{"defSwitchCase"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n    \t\t}\n    \t\treturn Optional.empty();\n    \t}\n\n\t\tprivate ")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("DatamartDefinition datamart() {\n\t\t\treturn this;\n\t\t}\n\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("entity", new String[]{"declareDefinition"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\n\t\t// Seriously why the heck are you reading this?? Are you a masochist or what\n\n        ")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("struct", new String[]{"declareDefinition"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n\t}\n\n\tstatic {\n\t\ttry {\n\t\t\tObject ref = ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart.class.getDeclaredField(\"definition\").get(null);\n\t\t\tjava.lang.reflect.Field field = ref.getClass().getDeclaredField(\"definition\");\n\t\t\tfield.setAccessible(true);\n\t\t\tfield.set(ref, definition);\n\t\t\tfield.setAccessible(false);\n\t\t} catch (Exception e) {\n\t\t\tthrow new ExceptionInInitializerError(\"Could not set ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Datamart.definition field\");\n\t\t}\n\t}\n}")}), this.rule().condition(this.type("entity"), new Rule.Condition[]{this.trigger("definition")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition")}), this.rule().condition(this.type("struct"), new Rule.Condition[]{this.trigger("definition")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("StructDefinition")}), this.rule().condition(this.type("entity"), new Rule.Condition[]{this.trigger("defswitchcase")}).output(new Rule.Output[]{this.literal("case \"")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("\": return Optional.of(")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition);")}), this.rule().condition(this.type("struct"), new Rule.Condition[]{this.trigger("defswitchcase")}).output(new Rule.Output[]{this.literal("case \"")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("\": return Optional.of(")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("StructDefinition);")}), this.rule().condition(this.type("entity"), new Rule.Condition[]{this.trigger("declaredefinition")}).output(new Rule.Output[]{this.literal("public final EntityDefinition ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition = new EntityDefinition() {\n\tprivate final List<AttributeDefinition> declaredAttributes = initAttributeDefinitions();\n\tpublic String fullName() {return \"")}).output(new Rule.Output[]{this.mark("fullName", new String[0])}).output(new Rule.Output[]{this.literal("\";}\n\tpublic String name() {return \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\";}\n\tpublic boolean isAbstract() {return ")}).output(new Rule.Output[]{this.mark("isAbstract", new String[0])}).output(new Rule.Output[]{this.literal(";}\n\tpublic List<AttributeDefinition> declaredAttributes() {\treturn declaredAttributes;}\n\tpublic Optional<EntityDefinition> parent() {return ")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("Optional.of(")}).output(new Rule.Output[]{this.mark("parent", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition)")}).next(this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("Optional.empty()")}))}).output(new Rule.Output[]{this.literal(";}\n\tpublic List<EntityDefinition> ancestors() {return java.util.List.of(")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("ancestor", new String[]{"definition"}).multiple(",")})}).output(new Rule.Output[]{this.literal(");}\n\tpublic List<EntityDefinition> descendants() {return java.util.List.of(")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("descendant", new String[]{"definition"}).multiple(",")})}).output(new Rule.Output[]{this.literal(");}\n\tpublic Class<?> javaClass() {return ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".class;}\n\tprivate List<AttributeDefinition> initAttributeDefinitions() {\n\t\tArrayList<AttributeDefinition> list = new ArrayList<>();\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("hasNoParents", new String[]{"addIdAndEnabledAttributes"})})}).output(new Rule.Output[]{this.literal("\n    \t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("attribute", new String[]{"addDefinition"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n    \tlist.trimToSize();\n    \treturn list;\n\t}\n\tpublic boolean equals(Object other) {\n\t\tif(other == null || other.getClass() != getClass()) return false;\n\t\treturn fullName().equals(((EntityDefinition)other).fullName());\n\t}\n\tpublic int hashCode() {return fullName().hashCode();}\n\tpublic String toString() {return fullName();}\n};")}), this.rule().condition(this.type("struct"), new Rule.Condition[]{this.trigger("declaredefinition")}).output(new Rule.Output[]{this.literal("public final StructDefinition ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("StructDefinition = new StructDefinition() {\n\tprivate final List<AttributeDefinition> declaredAttributes = initAttributeDefinitions();\n\tpublic String fullName() {return \"")}).output(new Rule.Output[]{this.mark("fullName", new String[0])}).output(new Rule.Output[]{this.literal("\";}\n\tpublic String name() {return \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\";}\n\tpublic List<AttributeDefinition> declaredAttributes() {return declaredAttributes;}\n\tpublic Optional<StructDefinition> parent() {return ")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("Optional.of(")}).output(new Rule.Output[]{this.mark("parent", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("StructDefinition)")}).next(this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("Optional.empty()")}))}).output(new Rule.Output[]{this.literal(";}\n\tpublic List<StructDefinition> ancestors() {return java.util.List.of(")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("ancestor", new String[]{"definition"}).multiple(",")})}).output(new Rule.Output[]{this.literal(");}\n\tpublic List<StructDefinition> descendants() {return java.util.List.of(")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("descendant", new String[]{"definition"}).multiple(",")})}).output(new Rule.Output[]{this.literal(");}\n\tpublic Class<?> javaClass() {return ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".structs.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(".class;}\n\tprivate List<AttributeDefinition> initAttributeDefinitions() {\n\t\tList<AttributeDefinition> list = new ArrayList<>(")}).output(new Rule.Output[]{this.mark("numAttributes", new String[0])}).output(new Rule.Output[]{this.literal(");\n    \t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("attribute", new String[]{"addDefinition"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n    \treturn list;\n\t}\n\tpublic boolean equals(Object other) {\n    \tif(other == null || other.getClass() != getClass()) return false;\n    \treturn fullName().equals(((StructDefinition)other).fullName());\n    }\n    public int hashCode() {return fullName().hashCode();}\n    public String toString() {return fullName();}\n};")}), this.rule().condition(this.type("subclass"), new Rule.Condition[]{this.trigger("name")}).output(new Rule.Output[]{this.literal("\"")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("\"")}), this.rule().condition(this.type("entity"), new Rule.Condition[]{this.anyTypes(new String[]{"descendant", "ancestor"}), this.trigger("definition")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition")}), this.rule().condition(this.type("struct"), new Rule.Condition[]{this.anyTypes(new String[]{"descendant", "ancestor"}), this.trigger("definition")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("StructDefinition")}), this.rule().condition(this.trigger("addidandenabledattributes"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("list.add(new AttributeDefinition() {\n\tpublic String name() {return \"id\";}\n\tpublic Class<?> type() {return String.class;}\n\tpublic String toString() {return name();}\n});\nlist.add(new AttributeDefinition() {\n\tpublic String name() {return \"enabled\";}\n\tpublic Class<?> type() {return Boolean.class;}\n\tpublic String toString() {return name();}\n});")}), this.rule().condition(this.type("attribute"), new Rule.Condition[]{this.not(this.type("inherited")), this.type("collection"), this.trigger("adddefinition")}).output(new Rule.Output[]{this.literal("list.add(new AttributeDefinition() {\n\tpublic String name() {return \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\";}\n\tpublic Class<?> type() {return ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(".class;}\n\tpublic String toString() {return name();}\n\tpublic List<ParameterDefinition> parameters() {\n\t\treturn List.of(new ParameterDefinition() {\n\t\t\tpublic Optional<ConceptDefinition<?>> asConceptDefinition() {return ")}).output(new Rule.Output[]{this.mark("parameter", new String[]{"asConceptDefinition"})}).output(new Rule.Output[]{this.literal(";}\n\t\t\tpublic Class<?> javaClass() {return ")}).output(new Rule.Output[]{this.mark("parameterType", new String[0])}).output(new Rule.Output[]{this.literal(".class;}\n\t\t\tpublic String toString() {return javaClass().getSimpleName();}\n\t\t});\n\t}\n});")}), this.rule().condition(this.type("attribute"), new Rule.Condition[]{this.not(this.type("inherited")), this.trigger("adddefinition")}).output(new Rule.Output[]{this.literal("list.add(new AttributeDefinition() {\n\tpublic String name() {return \"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\";}\n\tpublic Class<?> type() {return ")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(".class;}\n\tpublic String toString() {return name();}\n});")}), this.rule().condition(this.type("parameter"), new Rule.Condition[]{this.type("entity"), this.trigger("asconceptdefinition")}).output(new Rule.Output[]{this.literal("Optional.of(datamart().")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition)")}), this.rule().condition(this.type("parameter"), new Rule.Condition[]{this.type("struct"), this.trigger("asconceptdefinition")}).output(new Rule.Output[]{this.literal("Optional.of(datamart().")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("StructDefinition)")}), this.rule().condition(this.type("parameter"), new Rule.Condition[]{this.trigger("asconceptdefinition")}).output(new Rule.Output[]{this.literal("Optional.empty()")}), this.rule().condition(this.not(this.type("abstract")), new Rule.Condition[]{this.type("entity"), this.trigger("registermounter")}).output(new Rule.Output[]{this.literal("mounters.computeIfAbsent(\"")}).output(new Rule.Output[]{this.mark("event", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("\", type -> new ArrayList<>(1)).add(new ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".mounters.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Mounter(entities, entityListeners));")}), this.rule().condition(this.type("subclass"), new Rule.Condition[]{this.trigger("getallstream")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("()")}), this.rule().condition(this.type("abstract"), new Rule.Condition[]{this.trigger("getter")}).output(new Rule.Output[]{this.literal("@Override\npublic ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(String id) {\n\treturn id == null ? null : entities.getDescendant(definition.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition, id);\n}\n\n@Override\npublic Stream<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn Stream.of(\n\t\t")}).output(new Rule.Output[]{this.mark("subclass", new String[]{"getAllStream"}).multiple(",\n")}).output(new Rule.Output[]{this.literal("\n\t).<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(">flatMap(java.util.function.Function.identity());//.distinct();\n}")}), this.rule().condition(this.type("superclass"), new Rule.Condition[]{this.not(this.type("abstract")), this.trigger("getter")}).output(new Rule.Output[]{this.literal("@Override\npublic ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(String id) {\n\treturn id == null ? null : entities.getDescendant(definition.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition, id);\n}\n\n@Override\npublic Stream<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn Stream.of(\n\t\tentities.<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(">stream(definition.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition),\n\t\t")}).output(new Rule.Output[]{this.mark("subclass", new String[]{"getAllStream"}).multiple(",\n")}).output(new Rule.Output[]{this.literal("\n\t).<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(">flatMap(java.util.function.Function.identity());//.distinct();\n}")}), this.rule().condition(this.trigger("getter"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("@Override\npublic ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(String id) {\n\treturn id == null ? null : entities.get(definition.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition, id);\n}\n\n@Override\npublic Stream<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("() {\n\treturn entities.stream(definition.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("EntityDefinition);\n}")}), this.rule().condition(this.trigger("gettersignature"), new Rule.Condition[0]).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(String id);\nStream<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("();\ndefault List<")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".entities.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("List() {return ")}).output(new Rule.Output[]{this.mark("name", new String[]{"Plural", "firstLowerCase"})}).output(new Rule.Output[]{this.literal("().collect(Collectors.toList());}")})});
    }
}

