/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.measurement;

import io.intino.datahub.model.Measurement;
import io.intino.datahub.model.Namespace;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.ness.datahubterminalplugin.Commons;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.measurement.MeasurementTemplate;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class MeasurementRenderer {
    private final Measurement measurement;
    private final File destination;
    private final String rootPackage;

    public MeasurementRenderer(Measurement measurement, File destination, String rootPackage) {
        this.measurement = measurement;
        this.destination = destination;
        this.rootPackage = rootPackage;
    }

    public void render() {
        String rootPackage = this.rootPackage();
        File packageFolder = new File(this.destination, rootPackage.replace(".", File.separator));
        Frame frame = this.createMeasurementFrame(this.measurement, rootPackage);
        Commons.writeFrame(packageFolder, this.measurement.name$(), this.template().render((Object)frame));
    }

    private Frame createMeasurementFrame(Measurement measurement, String packageName) {
        FrameBuilder eventFrame = new FrameBuilder(new String[]{"measurement"}).add("name", (Object)measurement.name$()).add("size", (Object)measurement.valueList().size()).add("package", (Object)packageName);
        ArrayList<Frame> list = new ArrayList<Frame>();
        List values = measurement.valueList();
        for (int i = 0; i < values.size(); ++i) {
            list.add(MeasurementRenderer.frame(measurement.name$(), (Measurement.Value)values.get(i), i));
        }
        eventFrame.add("value", (Object)list.toArray(new Frame[0]));
        return eventFrame.toFrame();
    }

    private static Frame frame(String measurement, Measurement.Value value, int i) {
        FrameBuilder fb = new FrameBuilder(new String[]{"value"}).add("index", (Object)i).add("name", (Object)value.name$()).add("owner", (Object)measurement);
        if (!value.attributeList().isEmpty()) {
            fb.add("attribute", (Object)MeasurementRenderer.toString(value.attributeList()));
        }
        return fb.toFrame();
    }

    private static String[] toString(List<Measurement.Value.Attribute> attributes) {
        return (String[])attributes.stream().map(a -> a.name$() + ":" + a.value()).toArray(String[]::new);
    }

    private String rootPackage() {
        Object rootPackage = this.measurementsPackage();
        if (this.measurement.core$().owner().is(Namespace.class)) {
            rootPackage = (String)rootPackage + "." + ((Namespace)this.measurement.core$().ownerAs(Namespace.class)).qn();
        }
        return rootPackage;
    }

    private String measurementsPackage() {
        return this.rootPackage + ".measurements";
    }

    private Template template() {
        return Formatters.customize(new MeasurementTemplate()).add("typeFormat", value -> {
            if (value.toString().contains(".")) {
                return Formatters.firstLowerCase(value.toString());
            }
            return value;
        });
    }
}

