/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.master;

import io.intino.datahub.model.Datamart;
import io.intino.datahub.model.Expression;
import io.intino.datahub.model.Struct;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.formatters.StringFormatters;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.Predicate;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.master.ConceptAttribute;
import io.intino.ness.datahubterminalplugin.master.ConceptRenderer;
import io.intino.ness.datahubterminalplugin.master.DefaultValueHelper;
import io.intino.ness.datahubterminalplugin.master.ExpressionHelper;
import io.intino.ness.datahubterminalplugin.master.Parameter;
import java.util.HashMap;
import java.util.Map;

public class StructFrameFactory
implements ConceptRenderer {
    private static final String DOT = ".";
    private final Datamart datamart;
    private final String workingPackage;

    public StructFrameFactory(Datamart datamart, String workingPackage) {
        this.datamart = datamart;
        this.workingPackage = workingPackage;
    }

    public Map<String, Frame> create(Struct struct) {
        HashMap<String, Frame> map = new HashMap<String, Frame>(4);
        map.put(this.calculateStructPath(struct, this.workingPackage), this.frameOf(struct).toFrame());
        return map;
    }

    private FrameBuilder frameOf(Struct struct) {
        return new FrameBuilder(new String[]{"struct", "class"}).add("package", (Object)this.workingPackage).add("name", (Object)struct.name$()).add("datamart", (Object)this.datamart.name$()).add("parent", (Object)(this.workingPackage + DOT + StringFormatters.firstUpperCase().format((Object)this.datamart.name$()) + "Struct")).add("expression", struct.methodList().stream().map(e -> ExpressionHelper.exprFrameOf((Expression)e, this.workingPackage)).toArray(Frame[]::new)).add("attribute", this.attributesOf(struct).stream().map(this::attrFrameOf).toArray(Frame[]::new));
    }

    private Frame attrFrameOf(ConceptAttribute attr) {
        String entity;
        FrameBuilder builder = new FrameBuilder().add("attribute");
        String type = attr.type();
        builder.add(type);
        if (attr.inherited()) {
            builder.add("inherited");
        }
        builder.add("name", (Object)attr.name$()).add("owner", (Object)attr.core$().owner().name()).add("type", (Object)type);
        Parameter defaultValue = DefaultValueHelper.getDefaultValue(attr.core$());
        if (defaultValue != null) {
            builder.add("defaultValue", (Object)this.defaultValue(attr.core$(), type, defaultValue));
        }
        String string = entity = attr.isEntity() ? attr.asEntity().entity().name$() : null;
        if (entity != null) {
            builder.add("entity", (Object)entity);
        }
        return builder.toFrame();
    }

    private Frame defaultValue(Node attr, String type, Parameter defaultValue) {
        FrameBuilder builder = new FrameBuilder((String[])attr.conceptList().stream().map(Predicate::name).toArray(String[]::new));
        return builder.add("type", (Object)type).add("value", (Object)defaultValue.values().get(0).toString()).toFrame();
    }

    private String calculateStructPath(Struct struct, String thePackage) {
        return thePackage + ".structs." + StringFormatters.firstUpperCase().format((Object)Formatters.javaValidName().format((Object)struct.name$()).toString());
    }
}

