/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.master;

import io.intino.datahub.model.Datamart;
import io.intino.datahub.model.Entity;
import io.intino.datahub.model.Expression;
import io.intino.datahub.model.Struct;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.formatters.StringFormatters;
import io.intino.magritte.framework.Node;
import io.intino.ness.datahubterminalplugin.Formatters;
import io.intino.ness.datahubterminalplugin.master.ConceptAttribute;
import io.intino.ness.datahubterminalplugin.master.ConceptRenderer;
import io.intino.ness.datahubterminalplugin.master.DefaultValueHelper;
import io.intino.ness.datahubterminalplugin.master.ExpressionHelper;
import io.intino.ness.datahubterminalplugin.master.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntityFrameFactory
implements ConceptRenderer {
    private static final String DOT = ".";
    private final String workingPackage;
    private final Datamart datamart;

    public EntityFrameFactory(String workingPackage, Datamart datamart) {
        this.workingPackage = workingPackage;
        this.datamart = datamart;
    }

    public Map<String, Frame> create(Entity entity) {
        HashMap<String, Frame> map = new HashMap<String, Frame>(4);
        map.put(this.calculateEntityPath(entity, this.workingPackage), this.frameOf(entity).toFrame());
        if (entity.isDecorable()) {
            map.put(this.calculateDecorableEntityPath(entity.core$(), this.workingPackage), this.frameOf(entity).add("decorable").toFrame());
        }
        return map;
    }

    private FrameBuilder frameOf(Entity entity) {
        Parameter parent;
        FrameBuilder builder = new FrameBuilder(new String[]{"entity", "class"}).add("package", (Object)this.workingPackage).add("datamart", (Object)this.datamart.name$()).add("name", (Object)entity.core$().name()).add("attribute", this.attributesOf(entity).stream().map(this::attrFrameOf).toArray(FrameBuilder[]::new)).add("expression", entity.methodList().stream().map(m -> ExpressionHelper.exprFrameOf((Expression)m, this.workingPackage)).toArray(Frame[]::new));
        if (!this.datamart.structList().isEmpty()) {
            builder.add("hasStructs", (Object)new FrameBuilder().add("package", (Object)this.workingPackage));
        }
        builder.add("parent", (Object)((parent = this.parameter(entity.core$(), "entity")) != null ? this.withFullPackage(((Entity)parent.values().get(0)).name$()) : this.baseEntityName()));
        builder.add("normalizeId", (Object)new FrameBuilder(new String[]{"normalizeId", entity.isAbstract() || entity.isDecorable() ? "abstract" : ""}).add("package", (Object)this.workingPackage).add("name", (Object)entity.name$()).toFrame());
        builder.add("isAbstract", (Object)(entity.isAbstract() ? "abstract" : ""));
        return builder;
    }

    private String withFullPackage(String parent) {
        return this.entitiesPackage() + parent;
    }

    private String baseEntityName() {
        return this.workingPackage + DOT + Formatters.firstUpperCase(this.datamart.name$()) + "Entity";
    }

    private FrameBuilder attrFrameOf(ConceptAttribute attr) {
        FrameBuilder builder = new FrameBuilder().add("attribute");
        attr.conceptList().forEach(aspect -> builder.add(aspect.name()));
        Object owner = attr.owner();
        if (owner.is(Entity.Abstract.class) || owner.is(Entity.Decorable.class)) {
            builder.add("castToSubclass", (Object)("(" + owner.name() + ")"));
        }
        if (attr.inherited()) {
            builder.add("inherited");
        }
        Object type = attr.type();
        builder.add("typename", type);
        if (attr.isEntity()) {
            type = this.entitiesPackage() + (String)type;
        } else if (attr.isStruct()) {
            type = this.structsPackage() + (String)type;
        } else if (attr.isWord()) {
            type = Formatters.firstUpperCase((String)type);
        }
        this.handleCollectionType(attr, builder, (String)type);
        builder.add("name", (Object)attr.name$()).add("owner", (Object)owner.name()).add("package", (Object)this.workingPackage).add("index", (Object)owner.componentList().indexOf(attr.core$())).add("entityOwner", (Object)owner.name());
        this.processParameters(attr.core$(), builder, (String)type);
        return builder;
    }

    private void handleCollectionType(ConceptAttribute attr, FrameBuilder builder, String type) {
        if (attr.isList() || attr.isSet()) {
            String collectionType = attr.isList() ? "List" : "Set";
            builder.add("type", (Object)(collectionType + "<" + type + ">"));
            builder.add("collectionType", (Object)collectionType);
        } else if (attr.isMap()) {
            builder.add("type", (Object)"Map<String, String>");
            builder.add("collectionType", (Object)"Map");
        } else {
            builder.add("type", (Object)type);
        }
    }

    private void processParameters(Node node, FrameBuilder builder, String type) {
        Parameter struct;
        Parameter defaultValue;
        Parameter values = this.parameter(node, "values");
        if (values != null) {
            builder.add("value", (Object)values.values().stream().map(Object::toString).toArray());
        }
        if ((defaultValue = DefaultValueHelper.getDefaultValue(node)) != null) {
            builder.add("defaultValue", (Object)this.defaultValue(node, type, defaultValue));
        } else {
            builder.add("defaultValue", (Object)"null");
        }
        Parameter format = this.parameter(node, "format");
        if (format != null) {
            builder.add("format", format.values().get(0));
        } else if (type.startsWith("Date")) {
            builder.add("format", (Object)this.defaultFormat(type));
        }
        Parameter entity = this.parameter(node, "entity");
        if (entity != null) {
            String name = ((Entity)entity.values().get(0)).name$();
            builder.add("entity", (Object)name);
            Entity reference = this.datamart.entityList().stream().filter(e -> e.name$().equals(name)).findFirst().orElse(null);
            if (reference != null && reference.core$().conceptList().stream().anyMatch(c -> c.name().equals("Component"))) {
                builder.add("component");
            }
        }
        if ((struct = this.parameter(node, "struct")) != null) {
            Struct structNode = (Struct)struct.values().get(0);
            builder.add("struct", (Object)this.structFrame(structNode)).add("structLength", (Object)String.valueOf(structNode.attributeList().size()));
        }
        builder.add("attribute", (Object)builder.toFrame());
    }

    private String defaultFormat(String type) {
        return type.equals("Date") ? "dd/MM/yyyy" : "dd/MM/yyyy HH:mm:ss";
    }

    private Frame structFrame(Struct struct) {
        return new FrameBuilder(new String[]{"struct"}).add("name", (Object)struct.core$().name()).add("package", (Object)this.workingPackage).add("attribute", (Object)this.attributesOf(struct).stream().map(this::attrFrameOf).toArray()).toFrame();
    }

    private String defaultValue(Node c, String type, Parameter defaultValue) {
        return EntityFrameFactory.defaultValueOf(type, defaultValue);
    }

    private static String defaultValueOf(String type, Parameter defaultValue) {
        if (type.contains("List<")) {
            return "new java.util.ArrayList<>()";
        }
        if (type.contains("Set<")) {
            return "new java.util.HashSet<>()";
        }
        if (type.contains("Map<")) {
            return "new java.util.HashMap<>()";
        }
        return defaultValue.values().get(0).toString();
    }

    private Parameter parameter(Node c, String name) {
        List values = (List)c.variables().get(name);
        return values == null ? null : Parameter.of(values);
    }

    private String calculateEntityPath(Entity entity, String thePackage) {
        return thePackage + ".entities." + (entity.isDecorable() ? "Abstract" : "") + StringFormatters.firstUpperCase().format((Object)Formatters.javaValidName().format((Object)entity.core$().name()).toString());
    }

    private String calculateDecorableEntityPath(Node node, String aPackage) {
        return aPackage + ".entities." + StringFormatters.firstUpperCase().format((Object)Formatters.javaValidName().format((Object)node.name()).toString());
    }

    private String structsPackage() {
        return this.workingPackage + ".structs.";
    }

    private String entitiesPackage() {
        return this.workingPackage + ".entities.";
    }
}

