/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ness.datahubterminalplugin.master;

import io.intino.datahub.model.Attribute;
import io.intino.datahub.model.Entity;
import io.intino.datahub.model.Struct;
import io.intino.ness.datahubterminalplugin.master.ConceptAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public interface ConceptRenderer {
    default public List<ConceptAttribute> attributesOf(Struct struct) {
        return struct.attributeList().stream().map(a -> new ConceptAttribute(a, struct.core$())).collect(Collectors.toList());
    }

    default public List<ConceptAttribute> attributesOf(Entity entity) {
        LinkedHashMap<String, ConceptAttribute> map = new LinkedHashMap<String, ConceptAttribute>();
        Helper.getAttributesFromParents(entity, map);
        Helper.getAttributesFromEntity(entity, entity.attributeList(), map, false);
        return new ArrayList<ConceptAttribute>(map.values());
    }

    public static class Helper {
        private static void getAttributesFromEvent(Entity entity, List<Attribute> attributes, Map<String, ConceptAttribute> map) {
            for (Attribute attr : attributes) {
                if (entity.exclude().contains(attr.name$())) continue;
                map.put(attr.name$(), new ConceptAttribute(attr, entity.core$()));
            }
        }

        private static void getAttributesFromParents(Entity entity, Map<String, ConceptAttribute> map) {
            if (!entity.isExtensionOf()) {
                return;
            }
            ArrayList<Entity.Attribute> attributes = new ArrayList<Entity.Attribute>();
            Entity parent = entity.asExtensionOf().entity();
            while (parent != null) {
                attributes.addAll(parent.attributeList());
                parent = parent.isExtensionOf() ? parent.asExtensionOf().entity() : null;
            }
            Collections.reverse(attributes);
            Helper.getAttributesFromEntity(entity, attributes, map, true);
        }

        private static void getAttributesFromEntity(Entity entity, List<Entity.Attribute> attributeList, Map<String, ConceptAttribute> attribs, boolean inherited) {
            attributeList.forEach(a -> attribs.put(a.name$(), new ConceptAttribute(a, entity.core$()).inherited(inherited)));
        }
    }
}

